/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.generator;

import com.buuz135.industrial.proxy.BlockRegistry;
import com.buuz135.industrial.tile.generator.AbstractFuelGenerator;
import com.buuz135.industrial.utils.ItemStackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;

public class PitifulFuelGeneratorTile
extends AbstractFuelGenerator {
    public PitifulFuelGeneratorTile() {
        super(PitifulFuelGeneratorTile.class.getName().hashCode());
    }

    public static long getEnergy(int burnTime) {
        return burnTime / BlockRegistry.pitifulFuelGeneratorBlock.getTimeModifier();
    }

    public static boolean acceptsInputStack(ItemStack stack) {
        return !stack.func_190926_b() && TileEntityFurnace.func_145954_b((ItemStack)stack) && PitifulFuelGeneratorTile.isWoodRelated(stack);
    }

    public static boolean isWoodRelated(ItemStack stack) {
        String[] woods;
        for (String wood : woods = new String[]{"logWood", "plankWood", "slabWood", "stairWood", "fenceWood", "fenceGateWood", "doorWood", "stickWood"}) {
            if (!ItemStackUtils.isStackOreDict(stack, wood)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsItemStack(ItemStack stack) {
        return PitifulFuelGeneratorTile.acceptsInputStack(stack);
    }

    @Override
    public long getEnergyProduced(int burnTime) {
        return PitifulFuelGeneratorTile.getEnergy(burnTime);
    }

    @Override
    public float getMultiplier() {
        return BlockRegistry.pitifulFuelGeneratorBlock.getBurnTimeMultiplier();
    }
}

