/*
 * Decompiled with CFR 0.152.
 */
package info.tritusk.modpack.railcraft.patcher;

import info.tritusk.modpack.railcraft.patcher.IC2EmitterLogicPatcher;
import java.util.Collections;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class Xformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName == null) {
            return basicClass;
        }
        switch (transformedName) {
            case "mods.railcraft.common.plugins.jei.rolling.RollingMachineRecipeCategory": {
                return Xformer.tryFixRollingRecipeDisplayInJEI(basicClass);
            }
            case "mods.railcraft.common.blocks.TileRailcraft": {
                return Xformer.tryPatchingTileRailcraft(basicClass);
            }
            case "mods.railcraft.common.blocks.machine.worldspike.TileWorldspike": {
                return this.tryExpandStackSizeLimitInWorldSpike(basicClass);
            }
            case "mods.railcraft.common.blocks.structures.StructurePattern": {
                return Xformer.tryFixStructurePatternCheck(basicClass);
            }
            case "mods.railcraft.common.blocks.logic.IC2EmitterLogic": {
                return Xformer.tryFixIC2EmitterLogic(basicClass);
            }
            case "mods.railcraft.common.blocks.machine.manipulator.TileRFLoader": 
            case "mods.railcraft.common.blocks.machine.manipulator.TileRFUnloader": {
                return Xformer.tryReenableRFManipulatorGUI(basicClass);
            }
            case "mods.railcraft.common.gui.containers.RailcraftContainer": {
                return this.tryPatchRailcraftContainer(basicClass);
            }
            case "mods.railcraft.client.gui.GuiAnvil": {
                return Xformer.tryFixAnvilScreen(basicClass);
            }
            case "mods.railcraft.client.gui.GuiTrackDelayedLocking": 
            case "mods.railcraft.client.gui.GuiTrackEmbarking": 
            case "mods.railcraft.client.gui.GuiTrackLauncher": 
            case "mods.railcraft.client.gui.GuiTrackPriming": {
                return this.tryUseI18nForTrackGui(basicClass);
            }
            case "mods.railcraft.client.gui.GuiTrackActivator": {
                return this.tryMakingActivatorTrackGUIBetter(basicClass);
            }
            case "mods.railcraft.client.gui.GuiTrackRouting": {
                return this.tryFixGuiRouting(basicClass);
            }
            case "mods.railcraft.client.gui.GuiManipulatorCartRF": {
                return this.tryDisableInvTitle(basicClass);
            }
        }
        return basicClass;
    }

    private static byte[] tryReenableRFManipulatorGUI(byte[] basicClass) {
        ClassWriter writer = new ClassWriter(1);
        new ClassReader(basicClass).accept(new ClassVisitor(327680, (ClassVisitor)writer){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                if ("openGui".equals(name)) {
                    mv = new MethodVisitor(327680, mv){
                        final String teWorldHolder;
                        private boolean openGuiCall;
                        {
                            super(api, mv);
                            this.teWorldHolder = FMLDeobfuscatingRemapper.INSTANCE.mapFieldName("net/minecraft/tileentity/TileEntity", "field_145850_b", "Lnet/minecraft/world/world;");
                            this.openGuiCall = false;
                        }

                        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                            if ("mods/railcraft/common/gui/GuiHandler".equals(owner) && "openGui".equals(name)) {
                                this.openGuiCall = true;
                            }
                            super.visitMethodInsn(opcode, owner, name, desc, itf);
                        }

                        public void visitInsn(int opcode) {
                            if (opcode == 172 && !this.openGuiCall) {
                                super.visitFieldInsn(178, "mods/railcraft/common/gui/EnumGui", "MANIPULATOR_RF", "Lmods/railcraft/common/gui/EnumGui;");
                                super.visitVarInsn(25, 1);
                                super.visitVarInsn(25, 0);
                                super.visitFieldInsn(180, "mods/railcraft/common/blocks/machine/manipulator/TileRFManipulator", this.teWorldHolder, "Lnet/minecraft/world/World;");
                                super.visitVarInsn(25, 0);
                                super.visitMethodInsn(182, "mods/railcraft/common/blocks/machine/manipulator/TileRFManipulator", "getX", "()I", false);
                                super.visitVarInsn(25, 0);
                                super.visitMethodInsn(182, "mods/railcraft/common/blocks/machine/manipulator/TileRFManipulator", "getY", "()I", false);
                                super.visitVarInsn(25, 0);
                                super.visitMethodInsn(182, "mods/railcraft/common/blocks/machine/manipulator/TileRFManipulator", "getZ", "()I", false);
                                super.visitMethodInsn(184, "mods/railcraft/common/gui/GuiHandler", "openGui", "(Lmods/railcraft/common/gui/EnumGui;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/world/World;III)V", false);
                            }
                            super.visitInsn(opcode);
                        }
                    };
                }
                return mv;
            }
        }, 0);
        return writer.toByteArray();
    }

    private static byte[] tryFixIC2EmitterLogic(byte[] basicClass) {
        ClassWriter writer = new ClassWriter(0);
        new ClassReader(basicClass).accept((ClassVisitor)new IC2EmitterLogicPatcher(327680, (ClassVisitor)writer), 0);
        return writer.toByteArray();
    }

    private static byte[] tryFixStructurePatternCheck(byte[] basicClass) {
        ClassWriter writer = new ClassWriter(0);
        new ClassReader(basicClass).accept(new ClassVisitor(327680, (ClassVisitor)writer){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                if ("getPatternMarker".equals(name) && "(Lnet/minecraft/util/math/BlockPos;)C".equals(desc)) {
                    mv = new MethodVisitor(327680, mv){
                        private boolean foundFix;
                        {
                            super(api, mv);
                            this.foundFix = false;
                        }

                        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                            if (opcode == 182 && "getPatternMarker".equals(name) && !this.foundFix) {
                                opcode = 184;
                                owner = "info/tritusk/modpack/railcraft/patcher/StructurePatternHook";
                                name = "getPatternMarker0";
                                desc = "(Lmods/railcraft/common/blocks/structures/StructurePattern;III)C";
                                itf = false;
                            }
                            super.visitMethodInsn(opcode, owner, name, desc, itf);
                        }

                        public void visitIntInsn(int opcode, int operand) {
                            if (opcode == 16 && operand == 79) {
                                this.foundFix = true;
                            }
                            super.visitIntInsn(opcode, operand);
                        }
                    };
                }
                return mv;
            }
        }, 0);
        return writer.toByteArray();
    }

    private static byte[] tryFixAnvilScreen(byte[] basicClass) {
        ClassWriter writer = new ClassWriter(0);
        new ClassReader(basicClass).accept(new ClassVisitor(327680, (ClassVisitor)writer){
            final String targetMethodName = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName("net/minecraft/client/gui/inventory/GuiContainer", "func_73863_a", "(IIF)V");

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                if (this.targetMethodName.equals(name)) {
                    mv = new MethodVisitor(327680, mv){
                        final String tooltipMethod;
                        private boolean foundFix;
                        {
                            super(api, mv);
                            this.tooltipMethod = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName("net/minecraft/client/gui/inventory/GuiContainer", "func_191948_b", "(II)V");
                            this.foundFix = false;
                        }

                        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                            if (name.equals(this.tooltipMethod)) {
                                this.foundFix = true;
                            }
                            super.visitMethodInsn(opcode, owner, name, desc, itf);
                        }

                        public void visitIntInsn(int opcode, int operand) {
                            if (opcode == 17 && operand == 2896 && !this.foundFix) {
                                super.visitVarInsn(25, 0);
                                super.visitIntInsn(21, 1);
                                super.visitIntInsn(21, 2);
                                super.visitMethodInsn(182, "net/minecraft/client/gui/inventory/GuiContainer", this.tooltipMethod, "(II)V", false);
                            }
                            super.visitIntInsn(opcode, operand);
                        }
                    };
                }
                return mv;
            }
        }, 0);
        return writer.toByteArray();
    }

    private byte[] tryMakingActivatorTrackGUIBetter(byte[] basicClass) {
        ClassWriter writer = new ClassWriter(0);
        new ClassReader(basicClass).accept(new ClassVisitor(327680, (ClassVisitor)writer){
            final String targetMethodName;
            {
                this.targetMethodName = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName("net/minecraft/client/gui/inventory/GuiContainer", "func_146979_b", "(II)V");
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                if (this.targetMethodName.equals(name)) {
                    mv = new MethodVisitor(327680, mv){

                        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                            if (opcode == 184 && "drawStringCenteredAtPos".equals(name)) {
                                super.visitInsn(87);
                                super.visitInsn(87);
                                super.visitIntInsn(16, 44);
                                super.visitIntInsn(16, 28);
                            }
                            super.visitMethodInsn(opcode, owner, name, desc, itf);
                        }
                    };
                }
                return mv;
            }
        }, 0);
        return writer.toByteArray();
    }

    private byte[] tryDisableInvTitle(byte[] basicClass) {
        AbstractInsnNode endOfMethod;
        ClassNode node = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)node, 0);
        MethodNode targetMethod = null;
        for (MethodNode m : node.methods) {
            if (!"<init>".equals(m.name)) continue;
            targetMethod = m;
            break;
        }
        if (targetMethod == null) {
            return basicClass;
        }
        InsnList instructions = targetMethod.instructions;
        for (endOfMethod = instructions.getLast(); endOfMethod != null && endOfMethod.getOpcode() != 177; endOfMethod = endOfMethod.getPrevious()) {
        }
        if (endOfMethod == null) {
            return basicClass;
        }
        InsnList injectAtTail = new InsnList();
        injectAtTail.add((AbstractInsnNode)new VarInsnNode(25, 0));
        injectAtTail.add((AbstractInsnNode)new InsnNode(3));
        injectAtTail.add((AbstractInsnNode)new FieldInsnNode(181, "mods/railcraft/client/gui/GuiManipulatorCartRF", "drawInvTitle", "Z"));
        targetMethod.instructions.insertBefore(endOfMethod, injectAtTail);
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] tryPatchRailcraftContainer(byte[] basicClass) {
        ClassNode node = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)node, 0);
        MethodNode targetMethod = null;
        for (MethodNode m : node.methods) {
            if (!"addPlayerSlots".equals(m.name) || !"(Lnet/minecraft/entity/player/InventoryPlayer;I)V".equals(m.desc)) continue;
            targetMethod = m;
            break;
        }
        if (targetMethod == null) {
            return basicClass;
        }
        InsnList injectAtHead = new InsnList();
        LabelNode nullCheckPass = new LabelNode(new Label());
        injectAtHead.add((AbstractInsnNode)new VarInsnNode(25, 1));
        injectAtHead.add((AbstractInsnNode)new JumpInsnNode(199, nullCheckPass));
        injectAtHead.add((AbstractInsnNode)new InsnNode(177));
        injectAtHead.add((AbstractInsnNode)new FrameNode(1, 0, new Object[0], 1, new Object[]{"Lnet/minecraft/entity/player/InventoryPlayer;"}));
        injectAtHead.add((AbstractInsnNode)nullCheckPass);
        targetMethod.instructions.insert(injectAtHead);
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] tryFixGuiRouting(byte[] basicClass) {
        ClassWriter writer = new ClassWriter(3);
        new ClassReader(basicClass).accept(new ClassVisitor(327680, (ClassVisitor)writer){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                if ("<init>".equals(name)) {
                    mv = new MethodVisitor(327680, mv){

                        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                            if (opcode == 183 && "mods/railcraft/client/gui/GuiTitled".equals(owner)) {
                                super.visitVarInsn(25, 1);
                                super.visitFieldInsn(180, "mods/railcraft/common/gui/containers/ContainerTrackRouting", "kit", "Lmods/railcraft/common/blocks/tracks/outfitted/kits/TrackKitRailcraft;");
                                super.visitTypeInsn(192, "mods/railcraft/common/blocks/tracks/outfitted/kits/TrackKitRouting");
                                super.visitMethodInsn(182, "mods/railcraft/common/blocks/tracks/outfitted/kits/TrackKitRouting", "getTrackKit", "()Lmods/railcraft/api/tracks/TrackKit;", false);
                                super.visitMethodInsn(184, "mods/railcraft/common/plugins/forge/LocalizationPlugin", "localize", "(Lmods/railcraft/api/tracks/TrackKit;)Lnet/minecraft/util/text/ITextComponent;", false);
                                desc = "(Lnet/minecraft/world/IWorldNameable;Lmods/railcraft/common/gui/containers/RailcraftContainer;Ljava/lang/String;Lnet/minecraft/util/text/ITextComponent;)V";
                            }
                            super.visitMethodInsn(opcode, owner, name, desc, itf);
                        }
                    };
                }
                return mv;
            }
        }, 0);
        return writer.toByteArray();
    }

    private byte[] tryUseI18nForTrackGui(byte[] basicClass) {
        ClassWriter writer = new ClassWriter(0);
        new ClassReader(basicClass).accept(new ClassVisitor(327680, (ClassVisitor)writer){
            final String targetMethodName;
            {
                this.targetMethodName = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName("net/minecraft/world/IWorldNameable", "func_70005_c_", "()Ljava/lang/String;");
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                if ("<init>".equals(name)) {
                    mv = new MethodVisitor(327680, mv){

                        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                            if (opcode == 182 && targetMethodName.equals(name)) {
                                opcode = 184;
                                owner = "info/tritusk/modpack/railcraft/patcher/I18nHook";
                                name = "translateOutfittedTrackName";
                                desc = "(Lmods/railcraft/common/blocks/tracks/outfitted/TileTrackOutfitted;)Ljava/lang/String;";
                                itf = false;
                            }
                            super.visitMethodInsn(opcode, owner, name, desc, itf);
                        }
                    };
                }
                return mv;
            }
        }, 0);
        return writer.toByteArray();
    }

    private byte[] tryExpandStackSizeLimitInWorldSpike(byte[] basicClass) {
        ClassNode node = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)node, 0);
        MethodNode constructor = null;
        for (MethodNode m : node.methods) {
            if (!"<init>".equals(m.name)) continue;
            constructor = m;
            break;
        }
        if (constructor == null) {
            return basicClass;
        }
        InsnList instructions = constructor.instructions;
        AbstractInsnNode target = instructions.getLast();
        while (target.getOpcode() != 25 && (target = target.getPrevious()) != null) {
        }
        if (target == null) {
            return basicClass;
        }
        instructions.insertBefore(target, (AbstractInsnNode)new InsnNode(177));
        ClassWriter writer = new ClassWriter(3);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private static byte[] tryPatchingTileRailcraft(byte[] basicClass) {
        ClassNode node = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)node, 0);
        MethodNode markBlockForUpdateMethod = null;
        for (MethodNode m : node.methods) {
            if (!"markBlockForUpdate".equals(m.name)) continue;
            markBlockForUpdateMethod = m;
            break;
        }
        if (markBlockForUpdateMethod == null) {
            return basicClass;
        }
        InsnList instructions = new InsnList();
        instructions.add((AbstractInsnNode)new InsnNode(177));
        markBlockForUpdateMethod.instructions = instructions;
        markBlockForUpdateMethod.localVariables = Collections.emptyList();
        markBlockForUpdateMethod.visitMaxs(0, 1);
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private static byte[] tryFixRollingRecipeDisplayInJEI(byte[] basicClass) {
        ClassWriter writer = new ClassWriter(1);
        new ClassReader(basicClass).accept(new ClassVisitor(327680, (ClassVisitor)writer){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                if ("setRecipe".equals(name)) {
                    mv = new MethodVisitor(327680, mv){

                        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                            if (opcode == 185 && "setInputs".equals(name)) {
                                super.visitVarInsn(25, 2);
                                opcode = 184;
                                owner = "info/tritusk/modpack/railcraft/patcher/JEIHook";
                                name = "setInputs0";
                                desc = "(Lmezz/jei/api/gui/ICraftingGridHelper;Lmezz/jei/api/gui/IGuiItemStackGroup;Ljava/util/List;Lmezz/jei/api/recipe/IRecipeWrapper;)V";
                                itf = false;
                            }
                            super.visitMethodInsn(opcode, owner, name, desc, itf);
                        }
                    };
                }
                return mv;
            }
        }, 0);
        return writer.toByteArray();
    }
}

