/*
 * Decompiled with CFR 0.152.
 */
package silly511.backups.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.TimeUnit;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class GzipInputStream
extends InflaterInputStream {
    private FileTime modTime;
    private CRC32 crc = new CRC32();
    private boolean eos;
    private byte[] skipBuf = new byte[512];

    public GzipInputStream(InputStream stream) throws IOException {
        this(stream, 512);
    }

    public GzipInputStream(InputStream stream, int bufSize) throws IOException {
        super(stream, new Inflater(true), bufSize);
        DataInputStream in = new DataInputStream(stream);
        if (in.read() != 31 || in.read() != 139) {
            throw new IOException("Corrupted GZIP file");
        }
        if (in.readUnsignedByte() != 8) {
            throw new IOException("Unsupported compression method");
        }
        int flag = in.readUnsignedByte();
        this.modTime = FileTime.from(Integer.reverseBytes(in.readInt()), TimeUnit.SECONDS);
        in.skip(2L);
        if ((flag & 4) != 0) {
            in.skip(Short.reverseBytes(in.readShort()));
        }
        if ((flag & 8) != 0) {
            while (in.readUnsignedByte() != 0) {
            }
        }
        if ((flag & 0x10) != 0) {
            while (in.readUnsignedByte() != 0) {
            }
        }
        if ((flag & 2) != 0) {
            in.skip(2L);
        }
    }

    @Override
    public int read() throws IOException {
        if (this.eos) {
            return -1;
        }
        int b = super.read();
        if (b == -1) {
            this.readFooter();
        } else {
            this.crc.update(b);
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.eos) {
            return -1;
        }
        int l = super.read(b, off, len);
        if (l == -1) {
            this.readFooter();
        } else {
            this.crc.update(b, off, l);
        }
        return l;
    }

    @Override
    public long skip(long n) throws IOException {
        int len;
        while (n > 0L && (len = this.read(this.skipBuf, 0, (int)Math.min((long)this.skipBuf.length, n))) != -1) {
            n -= (long)len;
        }
        return n;
    }

    private void readFooter() throws IOException {
        int remaining = this.inf.getRemaining();
        InputStream in1 = remaining >= 8 ? new ByteArrayInputStream(this.buf, this.len - remaining, this.len) : (remaining > 0 ? new SequenceInputStream(new ByteArrayInputStream(this.buf, this.len - remaining, this.len), new FilterInputStream(this.in){

            @Override
            public void close() {
            }
        }) : this.in);
        DataInputStream in = new DataInputStream(in1);
        long checksum = 0xFFFFFFFFL & (long)Integer.reverseBytes(in.readInt());
        int size = Integer.reverseBytes(in.readInt());
        if (checksum != this.crc.getValue()) {
            throw new IOException("Checksum doesn't match");
        }
        if ((long)size != this.inf.getBytesWritten()) {
            throw new IOException("Checksum doesn't match");
        }
        this.eos = true;
    }

    public FileTime getModTime() {
        return this.modTime;
    }
}

