/*
 * Decompiled with CFR 0.152.
 */
package silly511.backups.helpers;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.zip.InflaterInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.ScreenShotHelper;

public final class ImageHelper {
    public static BufferedImage createIcon(int resultSize) {
        Minecraft mc = Minecraft.func_71410_x();
        BufferedImage screenShot = ScreenShotHelper.func_186719_a((int)mc.field_71443_c, (int)mc.field_71440_d, (Framebuffer)mc.func_147110_a());
        int size = Math.min(screenShot.getWidth(), screenShot.getHeight());
        int xOffset = screenShot.getWidth() / 2 - size / 2;
        int yOffset = screenShot.getHeight() / 2 - size / 2;
        BufferedImage result = new BufferedImage(resultSize, resultSize, 1);
        Graphics2D graphics = result.createGraphics();
        graphics.drawImage(screenShot, 0, 0, resultSize, resultSize, xOffset, yOffset, xOffset + size, yOffset + size, null);
        graphics.dispose();
        return result;
    }

    public static BufferedImage fromCompressedBytes(byte[] data, int width, int height) throws IOException {
        BufferedImage image = new BufferedImage(width, height, 1);
        try (InflaterInputStream stream = new InflaterInputStream(new ByteArrayInputStream(data));){
            for (int x = 0; x < image.getWidth(); ++x) {
                for (int y = 0; y < image.getHeight(); ++y) {
                    image.setRGB(x, y, new Color(stream.read(), stream.read(), stream.read(), 255).getRGB());
                }
            }
        }
        return image;
    }
}

