/*
 * Decompiled with CFR 0.152.
 */
package silly511.backups;

import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import silly511.backups.BackupsMod;
import silly511.backups.BackupsWorldCapability;
import silly511.backups.Config;
import silly511.backups.helpers.BackupHelper;
import silly511.backups.helpers.ImageHelper;

@Mod.EventBusSubscriber(modid="backups")
public class BackupManager {
    private static BackupsWorldCapability worldCapability;
    private static boolean shouldBackup;
    private static volatile BackupThread thread;
    private static Map<WorldServer, Boolean> oldSaveStates;

    public static void serverStarted() {
        worldCapability = null;
        shouldBackup = Config.backupInterval > 0 && !BackupManager.isTempWorld();
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        PlayerList playerList = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
        if (worldCapability == null) {
            WorldServer overworld = DimensionManager.getWorld((int)0);
            if (overworld != null) {
                worldCapability = (BackupsWorldCapability)overworld.getCapability(BackupsWorldCapability.capability, null);
            }
        } else if (shouldBackup && thread == null && BackupManager.worldCapability.nextBackupTimer >= Config.backupInterval * 1200 && (Config.backupWhenServerEmpty || playerList.func_181057_v().size() > 0)) {
            BackupManager.worldCapability.nextBackupTimer = 0;
            BackupManager.startBackup(BackupHelper.BackupReason.SCHEDULED, null);
        }
        if (thread != null && !thread.isAlive()) {
            BackupManager.restoreSaving();
            if (thread.errored) {
                BackupManager.postTagMessage("Backup failed! Check log for more details");
            } else {
                BackupManager.postTagMessage("Finished backup");
            }
            thread = null;
        }
        if (BackupManager.worldCapability.nextBackupTimer % 6000 == 300 && BackupManager.isTempWorld()) {
            for (EntityPlayer player : playerList.func_181057_v()) {
                player.func_146105_b(new TextComponentTranslation("backups.temp_world_warning", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)), false);
            }
        }
        ++BackupManager.worldCapability.nextBackupTimer;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void worldRenderLast(RenderWorldLastEvent event) {
        if (thread != null && thread.needsIcon && thread.icon == null) {
            thread.icon = ImageHelper.createIcon(64);
        }
    }

    public static void startBackup(BackupHelper.BackupReason reason, String label) {
        if (thread != null) {
            return;
        }
        BackupsMod.logger.info("Starting backup");
        BackupManager.postTagMessage("Started backup");
        Set<ISaveHandler> saveHandlers = BackupManager.disableSaving();
        File saveDir = DimensionManager.getCurrentSaveRootDirectory();
        thread = new BackupThread(saveHandlers, saveDir.toPath(), Paths.get(Config.backupsDir, saveDir.getName()), reason, label);
        thread.start();
    }

    public static Path getCurrentBackupsDir() {
        return Paths.get(Config.backupsDir, DimensionManager.getCurrentSaveRootDirectory().getName());
    }

    public static boolean isBackingUp() {
        return thread != null;
    }

    public static boolean isTempWorld() {
        return Paths.get("tempWorlds", new String[0]).toAbsolutePath().equals(DimensionManager.getCurrentSaveRootDirectory().getParentFile().toPath().toAbsolutePath().normalize());
    }

    private static Set<ISaveHandler> disableSaving() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        BackupsMod.logger.info("Disabling world saving");
        server.func_184103_al().func_72389_g();
        oldSaveStates = new WeakHashMap<WorldServer, Boolean>();
        HashSet<ISaveHandler> saveHandlers = new HashSet<ISaveHandler>();
        for (WorldServer worldServer : server.field_71305_c) {
            if (worldServer == null) continue;
            oldSaveStates.put(worldServer, worldServer.field_73058_d);
            try {
                worldServer.func_73044_a(true, null);
            }
            catch (MinecraftException ex) {
                BackupsMod.logger.warn("Error saving chunks", (Throwable)ex);
            }
            saveHandlers.add(worldServer.func_72860_G());
            worldServer.field_73058_d = true;
        }
        return saveHandlers;
    }

    private static void restoreSaving() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        BackupsMod.logger.info("Restoring world saving");
        for (WorldServer worldServer : server.field_71305_c) {
            Boolean oldSaveState;
            if (worldServer == null || (oldSaveState = oldSaveStates.get(worldServer)) == null) continue;
            worldServer.field_73058_d = oldSaveState;
        }
        oldSaveStates = null;
    }

    private static void postTagMessage(String msg) {
        if (Config.announceBackups == Config.AnnounceBackupsMode.OFF) {
            return;
        }
        PlayerList playerList = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
        Style prefixStyle = new Style().func_150238_a(TextFormatting.BLUE).func_150227_a(Boolean.valueOf(true));
        ITextComponent text = new TextComponentString("").func_150257_a(new TextComponentString("[Backups]: ").func_150255_a(prefixStyle)).func_150257_a((ITextComponent)new TextComponentString(msg));
        for (EntityPlayerMP player : playerList.func_181057_v()) {
            if (Config.announceBackups != Config.AnnounceBackupsMode.ALL_PLAYERS && (Config.announceBackups != Config.AnnounceBackupsMode.OPS_ONLY || !playerList.func_152596_g(player.func_146103_bH()))) continue;
            player.func_145747_a(text);
        }
    }

    public static class BackupThread
    extends Thread {
        private Set<ISaveHandler> saveHandlers;
        private Path worldDir;
        private Path backupsDir;
        private BackupHelper.BackupReason reason;
        private String label;
        @SideOnly(value=Side.CLIENT)
        private volatile BufferedImage icon;
        private volatile boolean needsIcon;
        private boolean errored;

        public BackupThread(Set<ISaveHandler> saveHandlers, Path worldDir, Path backupsDir, BackupHelper.BackupReason reason, String label) {
            this.saveHandlers = saveHandlers;
            this.worldDir = worldDir;
            this.backupsDir = backupsDir;
            this.reason = reason;
            this.label = label;
            this.setDaemon(true);
            this.setName("Backup Thread");
        }

        @Override
        public void run() {
            try {
                boolean isClient;
                BackupsMod.logger.info("Flushing world data to disk");
                for (ISaveHandler saveHandler : this.saveHandlers) {
                    saveHandler.func_75759_a();
                }
                this.saveHandlers.clear();
                boolean bl = isClient = FMLCommonHandler.instance().getSide() == Side.CLIENT;
                if (Config.trimming.trimmingEnabled) {
                    BackupsMod.logger.info("Trimming old backups");
                    BackupHelper.trimBackups(this.backupsDir);
                }
                BackupsMod.logger.info("Creating backup");
                BackupHelper.Backup backup = BackupHelper.backup(this.worldDir, this.backupsDir, this.reason, isClient ? () -> this.fetchIcon() : null);
                if (this.label != null) {
                    backup.setLabel(this.label);
                    backup.writeBackup();
                }
                BackupsMod.logger.info("Finished backup");
            }
            catch (Exception ex) {
                this.errored = true;
                BackupsMod.logger.error("Backup failed", (Throwable)ex);
            }
        }

        @SideOnly(value=Side.CLIENT)
        private BufferedImage fetchIcon() {
            this.needsIcon = true;
            for (int i = 0; i < 50 && this.icon == null; ++i) {
                try {
                    BackupThread.sleep(20L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.icon;
        }
    }
}

