/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.screen;

import java.awt.image.BufferedImage;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ChunkImage {
    private final World world;
    private final ChunkPos chunkPos;
    private final int yLevel;
    private DynamicTexture texture;

    public ChunkImage(World world, ChunkPos chunkPos, int yLevel) {
        this.world = world;
        this.chunkPos = chunkPos;
        this.yLevel = yLevel;
    }

    public void bindTexture() {
        if (this.texture == null) {
            this.texture = new DynamicTexture(this.createImage());
        }
        GlStateManager.func_179144_i((int)this.texture.func_110552_b());
    }

    public void dispose() {
        if (this.texture != null) {
            this.texture.func_147631_c();
            this.texture = null;
        }
    }

    private BufferedImage createImage() {
        int width = 16;
        int height = 16;
        BufferedImage image = new BufferedImage(16, 16, 2);
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < height; ++z) {
                int westY;
                int northY;
                BlockPos pos;
                if (this.shouldDrawAtSameLayer()) {
                    pos = this.getFirstBlockGoingDown(this.chunkPos.func_180334_c() + x, this.yLevel + 1, this.chunkPos.func_180333_d() + z, 5);
                    northY = this.getFirstBlockGoingDown(this.chunkPos.func_180334_c() + x, this.yLevel + 1, this.chunkPos.func_180333_d() + z - 1, 6).func_177956_o();
                    westY = this.getFirstBlockGoingDown(this.chunkPos.func_180334_c() + x - 1, this.yLevel + 1, this.chunkPos.func_180333_d() + z, 6).func_177956_o();
                } else {
                    pos = this.world.func_175645_m(new BlockPos(this.chunkPos.func_180334_c() + x, 0, this.chunkPos.func_180333_d() + z)).func_177977_b();
                    northY = this.world.func_189649_b(pos.func_177958_n(), pos.func_177952_p() - 1) - 1;
                    westY = this.world.func_189649_b(pos.func_177958_n() - 1, pos.func_177952_p()) - 1;
                }
                IBlockState state = this.world.func_180495_p(pos);
                MapColor color = state.func_185909_g((IBlockAccess)this.world, pos);
                int rgb = color == null ? MapColor.field_151660_b.field_76291_p : color.field_76291_p;
                int red = rgb >> 16 & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb & 0xFF;
                if (pos.func_177956_o() > northY && northY >= 0 || pos.func_177956_o() > westY && westY >= 0) {
                    if (red == 0 && green == 0 && blue == 0) {
                        red = 3;
                        green = 3;
                        blue = 3;
                    } else {
                        if (red > 0 && red < 3) {
                            red = 3;
                        }
                        if (green > 0 && green < 3) {
                            green = 3;
                        }
                        if (blue > 0 && blue < 3) {
                            blue = 3;
                        }
                        red = Math.min((int)((double)red / 0.7), 255);
                        green = Math.min((int)((double)green / 0.7), 255);
                        blue = Math.min((int)((double)blue / 0.7), 255);
                    }
                }
                if (pos.func_177956_o() < northY && northY >= 0 || pos.func_177956_o() < westY && westY >= 0) {
                    red = Math.max((int)((double)red * 0.7), 0);
                    green = Math.max((int)((double)green * 0.7), 0);
                    blue = Math.max((int)((double)blue * 0.7), 0);
                }
                image.setRGB(x, z, 0xFF000000 | red << 16 | green << 8 | blue);
            }
        }
        return image;
    }

    private BlockPos getFirstBlockGoingDown(int x, int y, int z, int maxTries) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        int tries = 0;
        while (this.world.func_175623_d((BlockPos)pos) && ++tries < maxTries) {
            pos.func_185336_p(pos.func_177956_o() - 1);
        }
        return pos;
    }

    private boolean shouldDrawAtSameLayer() {
        return this.world.field_73011_w.func_177495_o();
    }
}

