/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.inventory;

import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import network.rs485.logisticspipes.inventory.SlotAccess;
import network.rs485.logisticspipes.property.BitSetProperty;
import network.rs485.logisticspipes.property.IBitSet;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnetwork/rs485/logisticspipes/inventory/FuzzySlotAccess;", "Lnetwork/rs485/logisticspipes/inventory/SlotAccess;", "slotAccess", "fuzzyFlags", "Lnetwork/rs485/logisticspipes/property/BitSetProperty;", "(Lnetwork/rs485/logisticspipes/inventory/SlotAccess;Lnetwork/rs485/logisticspipes/property/BitSetProperty;)V", "bitsForSlot", "Lnetwork/rs485/logisticspipes/property/IBitSet;", "idx", "", "canMerge", "", "intoSlot", "fromSlot", "isSlotEmpty", "mergeSlots", "", "logisticspipes"})
public final class FuzzySlotAccess
implements SlotAccess {
    @NotNull
    private final SlotAccess slotAccess;
    @NotNull
    private final BitSetProperty fuzzyFlags;

    public FuzzySlotAccess(@NotNull SlotAccess slotAccess2, @NotNull BitSetProperty fuzzyFlags) {
        Intrinsics.checkNotNullParameter(slotAccess2, "slotAccess");
        Intrinsics.checkNotNullParameter(fuzzyFlags, "fuzzyFlags");
        this.slotAccess = slotAccess2;
        this.fuzzyFlags = fuzzyFlags;
    }

    private final IBitSet bitsForSlot(int idx) {
        int it = idx * 4;
        boolean bl = false;
        return this.fuzzyFlags.get(it, it + 3);
    }

    @Override
    public void mergeSlots(int intoSlot, int fromSlot) {
        this.slotAccess.mergeSlots(intoSlot, fromSlot);
        this.bitsForSlot(intoSlot).replaceWith(this.bitsForSlot(fromSlot));
        this.bitsForSlot(fromSlot).clear();
    }

    @Override
    public boolean canMerge(int intoSlot, int fromSlot) {
        return this.slotAccess.canMerge(intoSlot, fromSlot) && (this.isSlotEmpty(intoSlot) || Intrinsics.areEqual(this.bitsForSlot(intoSlot), this.bitsForSlot(fromSlot)));
    }

    @Override
    public boolean isSlotEmpty(int idx) {
        return this.slotAccess.isSlotEmpty(idx);
    }
}

