/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.gui.widget;

import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.utils.gui.LogisticsBaseGuiScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import network.rs485.logisticspipes.util.ColorUtilKt;
import network.rs485.logisticspipes.util.TextUtil;
import network.rs485.logisticspipes.util.math.MutableRectangle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u0005H\u0016J\u001d\u0010\u001a\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b/J\u000e\u00100\u001a\u00020\u001b2\u0006\u00101\u001a\u00020\u0003J\u0010\u00102\u001a\u00020,2\u0006\u00103\u001a\u00020\u0003H\u0016R\u0014\u0010\t\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0007\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\fR\u0014\u0010!\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001dR\u0014\u0010\b\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\fR\u0014\u0010$\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0015R\u001a\u0010&\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0017\"\u0004\b(\u0010\u0019R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\f\u00a8\u00064"}, d2={"Lnetwork/rs485/logisticspipes/gui/widget/Label;", "Lnet/minecraft/client/gui/Gui;", "fullText", "", "x", "", "y", "maxLength", "textColor", "backgroundColor", "(Ljava/lang/String;IIIII)V", "getBackgroundColor$logisticspipes", "()I", "fontRenderer", "Lnet/minecraft/client/gui/FontRenderer;", "logisticspipes.kotlin.jvm.PlatformType", "getFontRenderer$logisticspipes", "()Lnet/minecraft/client/gui/FontRenderer;", "fullRect", "Lnetwork/rs485/logisticspipes/util/math/MutableRectangle;", "getFullRect$logisticspipes", "()Lnetwork/rs485/logisticspipes/util/math/MutableRectangle;", "getFullText$logisticspipes", "()Ljava/lang/String;", "setFullText$logisticspipes", "(Ljava/lang/String;)V", "hovered", "", "getHovered$logisticspipes", "()Z", "setHovered$logisticspipes", "(Z)V", "getMaxLength$logisticspipes", "overflows", "getOverflows", "getTextColor$logisticspipes", "trimmedRect", "getTrimmedRect$logisticspipes", "trimmedText", "getTrimmedText$logisticspipes", "setTrimmedText$logisticspipes", "getX$logisticspipes", "getY$logisticspipes", "draw", "", "mouseX", "mouseY", "hovered$logisticspipes", "isTextEqual", "text", "setText", "newFullText", "logisticspipes"})
public class Label
extends Gui {
    private final int x;
    private final int y;
    private final int maxLength;
    private final int textColor;
    private final int backgroundColor;
    private final FontRenderer fontRenderer;
    @NotNull
    private final MutableRectangle fullRect;
    @NotNull
    private final MutableRectangle trimmedRect;
    @NotNull
    private String fullText;
    @NotNull
    private String trimmedText;
    private boolean hovered;

    public Label(@NotNull String fullText, int x, int y, int maxLength, int textColor, int backgroundColor) {
        Intrinsics.checkNotNullParameter(fullText, "fullText");
        this.x = x;
        this.y = y;
        this.maxLength = maxLength;
        this.textColor = textColor;
        this.backgroundColor = backgroundColor;
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.fullRect = new MutableRectangle().setPos(this.x, this.y);
        this.trimmedRect = new MutableRectangle().setPos(this.x, this.y);
        this.fullText = "";
        this.trimmedText = "";
        this.setText(fullText);
    }

    public final int getX$logisticspipes() {
        return this.x;
    }

    public final int getY$logisticspipes() {
        return this.y;
    }

    public final int getMaxLength$logisticspipes() {
        return this.maxLength;
    }

    public final int getTextColor$logisticspipes() {
        return this.textColor;
    }

    public final int getBackgroundColor$logisticspipes() {
        return this.backgroundColor;
    }

    public boolean getOverflows() {
        return this.fullRect.getWidth() > (float)this.maxLength;
    }

    public final FontRenderer getFontRenderer$logisticspipes() {
        return this.fontRenderer;
    }

    @NotNull
    public final MutableRectangle getFullRect$logisticspipes() {
        return this.fullRect;
    }

    @NotNull
    public final MutableRectangle getTrimmedRect$logisticspipes() {
        return this.trimmedRect;
    }

    @NotNull
    public final String getFullText$logisticspipes() {
        return this.fullText;
    }

    public final void setFullText$logisticspipes(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.fullText = string;
    }

    @NotNull
    public final String getTrimmedText$logisticspipes() {
        return this.trimmedText;
    }

    public final void setTrimmedText$logisticspipes(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.trimmedText = string;
    }

    public final boolean getHovered$logisticspipes() {
        return this.hovered;
    }

    public final void setHovered$logisticspipes(boolean bl) {
        this.hovered = bl;
    }

    public void draw(int mouseX, int mouseY) {
        String string;
        String string2;
        this.hovered = this.hovered$logisticspipes(mouseX, mouseY);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.fullRect.getX0(), (float)this.fullRect.getY0(), (float)0.0f);
        if (this.getOverflows() && this.hovered) {
            this.func_73733_a(0, -1, this.fullRect.getRoundedWidth(), this.fullRect.getRoundedHeight() + 1, this.backgroundColor, this.backgroundColor);
            LogisticsBaseGuiScreen.drawHorizontalGradientRect(this.fullRect.getRoundedWidth(), -2, this.fullRect.getRoundedWidth() + 1, this.fullRect.getRoundedHeight() + 1, 0, ColorUtilKt.opaque(this.textColor), ColorUtilKt.opaque(this.textColor));
            LogisticsBaseGuiScreen.drawHorizontalGradientRect(0, -2, this.fullRect.getRoundedWidth(), -1, 0, 0, ColorUtilKt.opaque(this.textColor));
            LogisticsBaseGuiScreen.drawHorizontalGradientRect(0, this.fullRect.getRoundedHeight(), this.fullRect.getRoundedWidth(), this.fullRect.getRoundedHeight() + 1, 0, 0, ColorUtilKt.opaque(this.textColor));
            string2 = this.fullText;
        } else {
            string2 = this.trimmedText;
        }
        String it = string = string2;
        boolean bl = false;
        this.fontRenderer.func_78276_b(it, 0, 0, this.textColor);
        GlStateManager.func_179109_b((float)(-this.fullRect.getX0()), (float)(-this.fullRect.getY0()), (float)0.0f);
        GlStateManager.func_179121_F();
    }

    public void setText(@NotNull String newFullText) {
        Intrinsics.checkNotNullParameter(newFullText, "newFullText");
        this.fullText = newFullText;
        this.fullRect.setSize(this.fontRenderer.func_78256_a(this.fullText), this.fontRenderer.field_78288_b);
        FontRenderer fontRenderer = this.fontRenderer;
        Intrinsics.checkNotNullExpressionValue(fontRenderer, "fontRenderer");
        this.trimmedText = TextUtil.getTrimmedString$default(this.fullText, this.maxLength, fontRenderer, null, 8, null);
        this.trimmedRect.setSize(this.fontRenderer.func_78256_a(this.trimmedText), this.fontRenderer.field_78288_b);
        int offset = (this.maxLength - this.trimmedRect.getRoundedWidth()) / 2;
        this.fullRect.setPos(this.x + offset, this.y);
        this.trimmedRect.setPos(this.x + offset, this.y);
    }

    public final boolean isTextEqual(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        return this.fullText == text;
    }

    public final boolean hovered$logisticspipes(int mouseX, int mouseY) {
        return (this.hovered ? this.fullRect : this.trimmedRect).contains(mouseX, mouseY);
    }
}

