/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.connection;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.TuplesKt;
import logisticspipes.kotlin.collections.CollectionsKt;
import logisticspipes.kotlin.collections.MapsKt;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import network.rs485.logisticspipes.connection.Adjacent;
import network.rs485.logisticspipes.connection.ConnectionType;
import network.rs485.logisticspipes.connection.LPNeighborTileEntity;
import network.rs485.logisticspipes.connection.NeighborTileEntity;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00070\fH\u0016J\u0014\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000fH\u0016J\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u0005H\u0096\u0002J\u0014\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000fH\u0016J\u001a\u0010\u0015\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\u0004\u0012\u00020\u00070\fH\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00172\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lnetwork/rs485/logisticspipes/connection/SingleAdjacent;", "Lnetwork/rs485/logisticspipes/connection/Adjacent;", "parent", "Llogisticspipes/pipes/basic/CoreRoutedPipe;", "dir", "Lnet/minecraft/util/EnumFacing;", "adjacentType", "Lnetwork/rs485/logisticspipes/connection/ConnectionType;", "(Llogisticspipes/pipes/basic/CoreRoutedPipe;Lnet/minecraft/util/EnumFacing;Lnetwork/rs485/logisticspipes/connection/ConnectionType;)V", "getDir", "()Lnet/minecraft/util/EnumFacing;", "connectedPos", "", "Lnet/minecraft/util/math/BlockPos;", "fluidTanks", "", "Lnetwork/rs485/logisticspipes/connection/NeighborTileEntity;", "Lnet/minecraft/tileentity/TileEntity;", "get", "direction", "inventories", "neighbors", "optionalGet", "Ljava/util/Optional;", "toString", "", "logisticspipes"})
public final class SingleAdjacent
implements Adjacent {
    @NotNull
    private final CoreRoutedPipe parent;
    @NotNull
    private final EnumFacing dir;
    @NotNull
    private final ConnectionType adjacentType;

    public SingleAdjacent(@NotNull CoreRoutedPipe parent, @NotNull EnumFacing dir, @NotNull ConnectionType adjacentType) {
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter(dir, "dir");
        Intrinsics.checkNotNullParameter((Object)adjacentType, "adjacentType");
        this.parent = parent;
        this.dir = dir;
        this.adjacentType = adjacentType;
    }

    @NotNull
    public final EnumFacing getDir() {
        return this.dir;
    }

    @Override
    @NotNull
    public Map<BlockPos, ConnectionType> connectedPos() {
        return MapsKt.mapOf(TuplesKt.to(this.parent.getPos().func_177972_a(this.dir), this.adjacentType));
    }

    @Override
    @Nullable
    public ConnectionType get(@NotNull EnumFacing direction) {
        ConnectionType connectionType;
        Intrinsics.checkNotNullParameter(direction, "direction");
        ConnectionType it = connectionType = this.adjacentType;
        boolean bl = false;
        return this.dir == direction ? connectionType : null;
    }

    @Override
    @NotNull
    public Optional<ConnectionType> optionalGet(@NotNull EnumFacing direction) {
        Optional<ConnectionType> optional;
        Intrinsics.checkNotNullParameter(direction, "direction");
        if (this.dir == direction) {
            Optional<ConnectionType> optional2 = Optional.of(this.adjacentType);
            optional = optional2;
            Intrinsics.checkNotNullExpressionValue(optional2, "{\n            Optional.of(adjacentType)\n        }");
        } else {
            Optional optional3 = Optional.empty();
            optional = optional3;
            Intrinsics.checkNotNullExpressionValue(optional3, "{\n            Optional.empty()\n        }");
        }
        return optional;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Map<NeighborTileEntity<TileEntity>, ConnectionType> neighbors() {
        Map<NeighborTileEntity<TileEntity>, ConnectionType> map2;
        TileEntity tileEntity = this.parent.getWorld().func_175625_s(this.parent.getPos().func_177972_a(this.dir));
        if (tileEntity != null) {
            TileEntity it = tileEntity;
            boolean bl = false;
            Map<LPNeighborTileEntity<TileEntity>, ConnectionType> map3 = MapsKt.mapOf(TuplesKt.to(new LPNeighborTileEntity<TileEntity>(it, this.dir), this.adjacentType));
            if (map3 != null) {
                map2 = map3;
                return map2;
            }
        }
        map2 = MapsKt.emptyMap();
        return map2;
    }

    @Override
    @NotNull
    public List<NeighborTileEntity<TileEntity>> inventories() {
        List<NeighborTileEntity<TileEntity>> list;
        if (this.adjacentType.isItem()) {
            LPNeighborTileEntity<Object> lPNeighborTileEntity;
            TileEntity tileEntity = this.parent.getWorld().func_175625_s(this.parent.getPos().func_177972_a(this.dir));
            if (tileEntity != null) {
                LPNeighborTileEntity<TileEntity> lPNeighborTileEntity2;
                TileEntity tile = tileEntity;
                boolean bl = false;
                LPNeighborTileEntity<TileEntity> it = lPNeighborTileEntity2 = new LPNeighborTileEntity<TileEntity>(tile, this.dir);
                boolean bl2 = false;
                lPNeighborTileEntity = it.canHandleItems() ? lPNeighborTileEntity2 : null;
            } else {
                lPNeighborTileEntity = null;
            }
            list = CollectionsKt.listOfNotNull(lPNeighborTileEntity);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<NeighborTileEntity<TileEntity>> fluidTanks() {
        List<NeighborTileEntity<TileEntity>> list;
        if (this.adjacentType.isFluid()) {
            LPNeighborTileEntity<Object> lPNeighborTileEntity;
            TileEntity tileEntity = this.parent.getWorld().func_175625_s(this.parent.getPos().func_177972_a(this.dir));
            if (tileEntity != null) {
                LPNeighborTileEntity<TileEntity> lPNeighborTileEntity2;
                TileEntity tile = tileEntity;
                boolean bl = false;
                LPNeighborTileEntity<TileEntity> it = lPNeighborTileEntity2 = new LPNeighborTileEntity<TileEntity>(tile, this.dir);
                boolean bl2 = false;
                lPNeighborTileEntity = it.canHandleFluids() ? lPNeighborTileEntity2 : null;
            } else {
                lPNeighborTileEntity = null;
            }
            list = CollectionsKt.listOfNotNull(lPNeighborTileEntity);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public String toString() {
        return "SingleAdjacent(" + this.dir.func_176742_j() + ": " + (Object)((Object)this.adjacentType) + ')';
    }
}

