/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.debug;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.collections.CollectionsKt;
import logisticspipes.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0002\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0015\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0015\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0018J\u001b\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\u001aJ\u0006\u0010\u001e\u001a\u00020\u001aJ\u000e\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\tJ\u000e\u0010 \u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\tR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lnetwork/rs485/debug/ChangeTrackingSortedMap;", "K", "", "V", "", "()V", "orderedKeys", "Ljava/util/ArrayList;", "sessionInsertions", "", "sessionStarted", "", "sessionUpdates", "size", "getSize", "()I", "values", "binarySearch", "key", "(Ljava/lang/Comparable;)I", "getKeyOrNull", "index", "(I)Ljava/lang/Comparable;", "getValueOrNull", "(I)Ljava/lang/Object;", "put", "", "value", "(Ljava/lang/Comparable;Ljava/lang/Object;)V", "startSession", "stopSession", "wasAdded", "wasUpdated", "logisticspipes"})
final class ChangeTrackingSortedMap<K extends Comparable<? super K>, V> {
    @NotNull
    private final ArrayList<K> orderedKeys = new ArrayList();
    @NotNull
    private final ArrayList<V> values = new ArrayList();
    @NotNull
    private final ArrayList<Integer> sessionUpdates = new ArrayList();
    @NotNull
    private final ArrayList<Integer> sessionInsertions = new ArrayList();
    private boolean sessionStarted;

    public final int getSize() {
        return this.orderedKeys.size();
    }

    public final void startSession() {
        this.sessionUpdates.clear();
        this.sessionInsertions.clear();
        this.sessionStarted = true;
    }

    public final void put(@NotNull K key, @NotNull V value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        if (!this.sessionStarted) {
            throw new IllegalStateException("Session not started. Only modify map after session start.");
        }
        int keyIndex = this.binarySearch(key);
        if (keyIndex < 0) {
            int addIndex = -(keyIndex + 1);
            this.orderedKeys.add(addIndex, key);
            this.values.add(addIndex, value);
            this.sessionInsertions.add(addIndex);
        } else if (!Intrinsics.areEqual(this.values.get(keyIndex), value)) {
            this.orderedKeys.set(keyIndex, key);
            this.values.set(keyIndex, value);
            this.sessionUpdates.add(keyIndex);
        }
    }

    public final int binarySearch(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return Collections.binarySearch((List)this.orderedKeys, key);
    }

    public final void stopSession() {
        this.sessionStarted = false;
    }

    @Nullable
    public final K getKeyOrNull(int index) {
        return (K)((Comparable)CollectionsKt.getOrNull((List)this.orderedKeys, index));
    }

    @Nullable
    public final V getValueOrNull(int index) {
        return (V)CollectionsKt.getOrNull((List)this.values, index);
    }

    public final boolean wasUpdated(int index) {
        return this.sessionUpdates.contains(index);
    }

    public final boolean wasAdded(int index) {
        return this.sessionInsertions.contains(index);
    }
}

