/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.math;

import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class Vec2 {
    public static final Vec2 ORIGIN = new Vec2(0.0f, 0.0f);
    public final float x;
    public final float y;
    private float length = Float.NaN;
    private Vec2 normalized;

    public Vec2(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vec2 add(Vec2 other) {
        return new Vec2(this.x + other.x, this.y + other.y);
    }

    public Vec2 sub(Vec2 other) {
        return new Vec2(this.x - other.x, this.y - other.y);
    }

    public Vec2 mul(Vec2 other) {
        return new Vec2(this.x * other.x, this.y * other.y);
    }

    public Vec2 mul(float other) {
        return new Vec2(this.x * other, this.y * other);
    }

    public Vec2 div(Vec2 other) {
        return new Vec2(this.x / other.x, this.y / other.y);
    }

    public Vec2 div(float other) {
        return new Vec2(this.x / other, this.y / other);
    }

    public float dot(Vec2 other) {
        return this.x * other.x + this.y * other.y;
    }

    public float getLength() {
        if (Float.isNaN(this.length)) {
            this.length = (float)Math.sqrt(this.x * this.x + this.y * this.y);
        }
        return this.length;
    }

    public Vec2 getNormalized() {
        if (this.normalized == null) {
            this.normalized = new Vec2(this.x / this.getLength(), this.y / this.getLength());
            this.normalized.length = 1.0f;
        }
        return this.normalized;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vec2 vec2 = (Vec2)o;
        return Float.compare(vec2.x, this.x) == 0 && Float.compare(vec2.y, this.y) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y));
    }

    public String toString() {
        return String.format("(%f, %f)", Float.valueOf(this.x), Float.valueOf(this.y));
    }
}

