/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.gui.extension;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.extension.GuiExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.Slot;

public class GuiExtensionController {
    private final List<GuiExtension> extensions = new ArrayList<GuiExtension>();
    private final List<GuiExtension> extensionsToRemove = new ArrayList<GuiExtension>();
    private int maxBottom;
    private GuiExtension currentlyExtended = null;
    private Map<Slot, Integer> slotMap = new HashMap<Slot, Integer>();
    private Map<GuiButton, Integer> buttonMap = new HashMap<GuiButton, Integer>();
    private final GuiSide side;

    public GuiExtensionController(GuiSide side) {
        this.side = side;
    }

    public void render(int xPos, int yPos) {
        yPos += 4;
        if (this.currentlyExtended == null) {
            for (GuiExtension extension : this.extensions) {
                int right;
                int left;
                extension.setExtending(false);
                if (this.side == GuiSide.LEFT) {
                    left = xPos - extension.getCurrentWidth();
                    right = xPos + 15;
                } else {
                    left = xPos - 15;
                    right = xPos + extension.getCurrentWidth();
                }
                int bottom = yPos + extension.getCurrentHeight();
                extension.update(left, yPos);
                GuiGraphics.drawGuiBackGround(Minecraft.func_71410_x(), left, yPos, right, bottom, 0.0f, true, true, this.side != GuiSide.RIGHT, true, this.side != GuiSide.LEFT);
                extension.renderForeground(left + (this.side == GuiSide.RIGHT ? 20 : 0), yPos);
                yPos = bottom;
            }
        } else if (this.currentlyExtended.isExtending()) {
            int right;
            int left;
            if (this.side == GuiSide.LEFT) {
                left = xPos - this.currentlyExtended.getCurrentWidth();
                right = xPos + 15;
            } else {
                left = xPos - 15;
                right = xPos + this.currentlyExtended.getCurrentWidth();
            }
            int bottom = this.currentlyExtended.getCurrentYPos() + this.currentlyExtended.getCurrentHeight();
            this.currentlyExtended.update(left, yPos);
            GuiGraphics.drawGuiBackGround(Minecraft.func_71410_x(), left, this.currentlyExtended.getCurrentYPos(), right, bottom, 0.0f, true, true, this.side != GuiSide.RIGHT, true, this.side != GuiSide.LEFT);
            this.currentlyExtended.renderForeground(left + (this.side == GuiSide.RIGHT ? 20 : 0), this.currentlyExtended.getCurrentYPos());
        } else {
            int right;
            int left;
            int bottom;
            for (GuiExtension extension : this.extensions) {
                if (extension == this.currentlyExtended) break;
                extension.setExtending(false);
                yPos = bottom = yPos + extension.getCurrentHeight();
            }
            if (this.side == GuiSide.LEFT) {
                left = xPos - this.currentlyExtended.getCurrentWidth();
                right = xPos + 15;
            } else {
                left = xPos - 15;
                right = xPos + this.currentlyExtended.getCurrentWidth();
            }
            bottom = this.currentlyExtended.getCurrentYPos() + this.currentlyExtended.getCurrentHeight();
            this.currentlyExtended.update(left, yPos);
            GuiGraphics.drawGuiBackGround(Minecraft.func_71410_x(), left, this.currentlyExtended.getCurrentYPos(), right, bottom, 0.0f, true, true, this.side != GuiSide.RIGHT, true, this.side != GuiSide.LEFT);
            this.currentlyExtended.renderForeground(left + (this.side == GuiSide.RIGHT ? 20 : 0), this.currentlyExtended.getCurrentYPos());
            if (this.currentlyExtended.isFullyRetracted()) {
                this.currentlyExtended = null;
            }
        }
        if (this.currentlyExtended != null && this.extensionsToRemove.contains(this.currentlyExtended)) {
            this.currentlyExtended = null;
        }
        this.extensions.removeAll(this.extensionsToRemove);
        this.extensionsToRemove.clear();
    }

    public void addExtension(GuiExtension extension) {
        this.extensions.add(extension);
    }

    public void removeExtension(GuiExtension extension) {
        this.extensionsToRemove.add(extension);
    }

    public void mouseClicked(int x, int y, int k) {
        if (this.currentlyExtended == null) {
            this.extensions.stream().filter(extension -> x > extension.getCurrentXPos() && x < extension.getCurrentXPos() + extension.getCurrentWidth() + (this.side == GuiSide.RIGHT ? 15 : 0) && y > extension.getCurrentYPos() && y < extension.getCurrentYPos() + extension.getCurrentHeight()).forEach(extension -> {
                this.currentlyExtended = extension;
                this.currentlyExtended.setExtending(true);
            });
        } else if (x > this.currentlyExtended.getCurrentXPos() && x < this.currentlyExtended.getCurrentXPos() + this.currentlyExtended.getCurrentWidth() + (this.side == GuiSide.RIGHT ? 15 : 0) && y > this.currentlyExtended.getCurrentYPos() && y < this.currentlyExtended.getCurrentYPos() + this.currentlyExtended.getCurrentHeight()) {
            this.currentlyExtended.setExtending(false);
        }
    }

    public void mouseOver(int i, int j) {
        int x = i;
        int y = j;
        if (this.currentlyExtended == null) {
            for (GuiExtension extension : this.extensions) {
                if (x <= extension.getCurrentXPos() || x >= extension.getCurrentXPos() + extension.getCurrentWidth() + (this.side == GuiSide.RIGHT ? 15 : 0) || y <= extension.getCurrentYPos() || y >= extension.getCurrentYPos() + extension.getCurrentHeight()) continue;
                extension.handleMouseOverAt(x, y);
                return;
            }
        } else if (x > this.currentlyExtended.getCurrentXPos() && x < this.currentlyExtended.getCurrentXPos() + this.currentlyExtended.getCurrentWidth() + (this.side == GuiSide.RIGHT ? 15 : 0) && y > this.currentlyExtended.getCurrentYPos() && y < this.currentlyExtended.getCurrentYPos() + this.currentlyExtended.getCurrentHeight()) {
            this.currentlyExtended.handleMouseOverAt(x, y);
            return;
        }
    }

    public int registerControlledSlot(Slot slot) {
        int size = this.slotMap.size();
        this.slotMap.put(slot, size);
        return size;
    }

    public boolean renderSlot(Slot slot) {
        if (!this.slotMap.containsKey(slot)) {
            return true;
        }
        if (this.currentlyExtended == null) {
            return false;
        }
        if (!this.currentlyExtended.isFullyExtended()) {
            return false;
        }
        int id = this.slotMap.get(slot);
        return this.currentlyExtended.renderSlot(id);
    }

    public boolean renderSelectSlot(Slot slot) {
        if (!this.slotMap.containsKey(slot)) {
            return true;
        }
        if (this.currentlyExtended == null) {
            return false;
        }
        if (!this.currentlyExtended.isFullyExtended()) {
            return false;
        }
        int id = this.slotMap.get(slot);
        return this.currentlyExtended.renderSelectSlot(id);
    }

    public int registerControlledButton(GuiButton button) {
        int size = this.buttonMap.size();
        this.buttonMap.put(button, size);
        return size;
    }

    public boolean renderButtonControlled(GuiButton button) {
        return this.buttonMap.containsKey(button);
    }

    public boolean renderButton(GuiButton button) {
        if (!this.buttonMap.containsKey(button)) {
            return true;
        }
        if (this.currentlyExtended == null) {
            return false;
        }
        if (!this.currentlyExtended.isFullyExtended()) {
            return false;
        }
        int id = this.buttonMap.get(button);
        return this.currentlyExtended.renderButton(id);
    }

    public void clear() {
        this.extensions.clear();
        this.extensionsToRemove.clear();
        this.currentlyExtended = null;
    }

    public void retract() {
        if (this.currentlyExtended != null) {
            this.currentlyExtended.setExtending(false);
        }
    }

    public List<Rectangle> getGuiExtraAreas() {
        ArrayList<Rectangle> list = new ArrayList<Rectangle>();
        if (this.currentlyExtended == null) {
            for (GuiExtension extension : this.extensions) {
                list.add(new Rectangle(extension.getCurrentXPos(), extension.getCurrentYPos(), extension.getCurrentWidth() + (this.side == GuiSide.RIGHT ? 15 : 0), extension.getCurrentHeight()));
            }
        } else {
            list.add(new Rectangle(this.currentlyExtended.getCurrentXPos(), this.currentlyExtended.getCurrentYPos(), this.currentlyExtended.getCurrentWidth() + (this.side == GuiSide.RIGHT ? 15 : 0), this.currentlyExtended.getCurrentHeight()));
        }
        return list;
    }

    public boolean isOverPanel(int x, int y, int w, int h) {
        if (this.currentlyExtended == null) {
            for (GuiExtension extension : this.extensions) {
                if (x + w <= extension.getCurrentXPos() || x >= extension.getCurrentXPos() + extension.getCurrentWidth() + (this.side == GuiSide.RIGHT ? 15 : 0) || y + h <= extension.getCurrentYPos() || y >= extension.getCurrentYPos() + extension.getCurrentHeight()) continue;
                return true;
            }
        } else if (x + w > this.currentlyExtended.getCurrentXPos() && x < this.currentlyExtended.getCurrentXPos() + this.currentlyExtended.getCurrentWidth() + (this.side == GuiSide.RIGHT ? 15 : 0) && y + h > this.currentlyExtended.getCurrentYPos() && y < this.currentlyExtended.getCurrentYPos() + this.currentlyExtended.getCurrentHeight()) {
            return true;
        }
        return false;
    }

    public GuiExtensionController setMaxBottom(int maxBottom) {
        this.maxBottom = maxBottom;
        return this;
    }

    public static enum GuiSide {
        LEFT,
        RIGHT;

    }
}

