/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import net.minecraft.world.World;

public class SafeTimeTracker {
    private long lastMark = Long.MIN_VALUE;
    private long duration = -1L;
    private long randomRange = 0L;
    private long lastRandomDelay = 0L;
    private long internalDelay;

    public SafeTimeTracker(long delay) {
        this.internalDelay = delay;
    }

    public SafeTimeTracker(long delay, long random) {
        this.internalDelay = delay;
        this.randomRange = random;
    }

    public boolean markTimeIfDelay(World world) {
        return this.markTimeIfDelay(world, this.internalDelay);
    }

    private boolean markTimeIfDelay(World world, long delay) {
        if (world == null) {
            return false;
        }
        long currentTime = world.func_82737_E();
        if (currentTime < this.lastMark) {
            this.lastMark = currentTime;
            return false;
        }
        if (this.lastMark + delay + this.lastRandomDelay <= currentTime) {
            this.duration = currentTime - this.lastMark;
            this.lastMark = currentTime;
            this.lastRandomDelay = (int)(Math.random() * (double)this.randomRange);
            return true;
        }
        return false;
    }

    public long durationOfLastDelay() {
        return this.duration > 0L ? this.duration : 0L;
    }

    public void markTime(World world) {
        this.lastMark = world.func_82737_E();
    }
}

