/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer.newpipe.tube;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.ITubeOrientation;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.tubes.HSTubeCurve;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.object3d.interfaces.IModel3D;
import logisticspipes.proxy.object3d.operation.LPColourMultiplier;
import logisticspipes.proxy.object3d.operation.LPRotation;
import logisticspipes.proxy.object3d.operation.LPScale;
import logisticspipes.proxy.object3d.operation.LPTranslation;
import logisticspipes.renderer.newpipe.IHighlightPlacementRenderer;
import logisticspipes.renderer.newpipe.ISpecialPipeRenderer;
import logisticspipes.renderer.newpipe.LogisticsNewRenderPipe;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.util.ResourceLocation;

public class CurveTubeRenderer
implements ISpecialPipeRenderer,
IHighlightPlacementRenderer {
    public static final CurveTubeRenderer instance = new CurveTubeRenderer();
    static Map<HSTubeCurve.TurnDirection, List<IModel3D>> tubeTurnBase = new HashMap<HSTubeCurve.TurnDirection, List<IModel3D>>();
    static Map<HSTubeCurve.TurnDirection, Map<Pair<TubeMount, Integer>, IModel3D>> tubeTurnMounts = new HashMap<HSTubeCurve.TurnDirection, Map<Pair<TubeMount, Integer>, IModel3D>>();
    public static Map<HSTubeCurve.TurnDirection, IModel3D> tubeCurve = new HashMap<HSTubeCurve.TurnDirection, IModel3D>();
    private static final ResourceLocation TEXTURE = new ResourceLocation("logisticspipes", "textures/blocks/pipes/HS-Tube.png");

    private CurveTubeRenderer() {
    }

    public static void loadModels() {
        try {
            Map<String, IModel3D> pipePartModels = SimpleServiceLocator.cclProxy.parseObjModels(LogisticsPipes.class.getResourceAsStream("/logisticspipes/models/HSTube-Turn_result.obj"), 7, new LPScale(0.01f));
            for (HSTubeCurve.TurnDirection turn : HSTubeCurve.TurnDirection.values()) {
                tubeTurnBase.put(turn, new ArrayList());
            }
            pipePartModels.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("Lane ") || ((String)entry.getKey()).contains(" Lane ") || ((String)entry.getKey()).endsWith(" Lane")).forEach(entry -> {
                tubeTurnBase.get(HSTubeCurve.TurnDirection.SOUTH_WEST).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).twoFacedCopy().apply(new LPTranslation(0.0, 0.0, 0.0)).apply(new LPRotation(-1.5707963267948966, 0, 1, 0))));
                tubeTurnBase.get(HSTubeCurve.TurnDirection.EAST_SOUTH).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).twoFacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0))));
                tubeTurnBase.get(HSTubeCurve.TurnDirection.NORTH_EAST).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).twoFacedCopy().apply(new LPTranslation(-1.0, 0.0, 1.0)).apply(new LPRotation(1.5707963267948966, 0, 1, 0))));
                tubeTurnBase.get(HSTubeCurve.TurnDirection.WEST_NORTH).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).twoFacedCopy().apply(new LPTranslation(-1.0, 0.0, 0.0)).apply(new LPRotation(Math.PI, 0, 1, 0))));
            });
            if (tubeTurnBase.get(HSTubeCurve.TurnDirection.NORTH_EAST).size() != 4) {
                throw new RuntimeException("Couldn't load Tube Lanes. Only loaded " + tubeTurnBase.get(HSTubeCurve.TurnDirection.NORTH_EAST).size());
            }
            for (HSTubeCurve.TurnDirection turn : HSTubeCurve.TurnDirection.values()) {
                tubeCurve.put(turn, SimpleServiceLocator.cclProxy.combine((Collection<IModel3D>)tubeTurnBase.get(turn)));
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nonnull
    public List<IModel3D> getModelsWithoutPipe() {
        return tubeTurnBase.get(HSTubeCurve.TurnDirection.NORTH_EAST);
    }

    @Override
    @Nonnull
    public List<IModel3D> getModelsFromPipe(@Nonnull CoreUnroutedPipe pipe) {
        if (pipe instanceof HSTubeCurve && ((HSTubeCurve)pipe).getOrientation() != null) {
            HSTubeCurve.TurnDirection orientation = ((HSTubeCurve)pipe).getOrientation().getRenderOrientation();
            return Objects.requireNonNull(tubeTurnBase.get(orientation), "Could not fetch model for CurveTubeRenderer for orientation " + orientation);
        }
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    public void renderHighlight(ITubeOrientation orientation) {
        tubeCurve.get(orientation.getRenderOrientation()).copy().render(LPColourMultiplier.instance(-1));
    }

    static enum TubeMount {
        UP_LEFT,
        UP_RIGHT,
        DOWN_LEFT,
        DOWN_RIGHT;

    }
}

