/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer.newpipe;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.proxy.object3d.interfaces.I3DOperation;
import logisticspipes.proxy.object3d.interfaces.IModel3D;
import logisticspipes.proxy.object3d.operation.LPUVTransformationList;
import logisticspipes.proxy.object3d.operation.LPUVTranslation;
import logisticspipes.renderer.newpipe.RenderEntry;
import net.minecraft.util.ResourceLocation;

public interface ISpecialPipeRenderer {
    default public void modelsToRenderList(@Nonnull ArrayList<RenderEntry> objectsToRender, List<IModel3D> models) {
        objectsToRender.ensureCapacity(objectsToRender.size() + models.size());
        models.stream().map(model -> new RenderEntry((IModel3D)model, new I3DOperation[]{new LPUVTransformationList(new LPUVTranslation(0.0f, 0.0f))}, this.getTexture())).forEach(objectsToRender::add);
    }

    default public void renderToList(@Nullable CoreUnroutedPipe pipe, @Nonnull ArrayList<RenderEntry> objectsToRender) {
        if (pipe == null) {
            this.modelsToRenderList(objectsToRender, this.getModelsWithoutPipe());
        } else {
            this.modelsToRenderList(objectsToRender, this.getModelsFromPipe(pipe));
        }
    }

    @Nonnull
    public List<IModel3D> getModelsWithoutPipe();

    @Nonnull
    public List<IModel3D> getModelsFromPipe(@Nonnull CoreUnroutedPipe var1);

    @Nonnull
    public ResourceLocation getTexture();
}

