/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.signs;

import java.util.List;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.modules.ModuleCrafter;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.cpipe.CPipeSatelliteImportBack;
import logisticspipes.pipes.PipeItemsCraftingLogistics;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.signs.IPipeSign;
import logisticspipes.renderer.LogisticsRenderPipe;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class CraftingPipeSign
implements IPipeSign {
    public CoreRoutedPipe pipe;
    public EnumFacing dir;
    private Object fbo;
    private ItemIdentifierStack oldRenderedStack = null;
    private String oldSatelliteName = "";

    @Override
    public boolean isAllowedFor(CoreRoutedPipe pipe) {
        return pipe instanceof PipeItemsCraftingLogistics;
    }

    @Override
    public void addSignTo(CoreRoutedPipe pipe, EnumFacing dir, EntityPlayer player) {
        pipe.addPipeSign(dir, new CraftingPipeSign(), player);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
    }

    @Override
    public ModernPacket getPacket() {
        PipeItemsCraftingLogistics cpipe = (PipeItemsCraftingLogistics)this.pipe;
        return PacketHandler.getPacket(CPipeSatelliteImportBack.class).setInventory(cpipe.getDummyInventory()).setType(LogisticsModule.ModulePositionType.IN_PIPE).setPosX(cpipe.getX()).setPosY(cpipe.getY()).setPosZ(cpipe.getZ());
    }

    @Override
    public void updateServerSide() {
    }

    @Override
    public void init(CoreRoutedPipe pipe, EnumFacing dir) {
        this.pipe = pipe;
        this.dir = dir;
    }

    @Override
    public void activate(EntityPlayer player) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(CoreRoutedPipe pipe, LogisticsRenderPipe renderer) {
        PipeItemsCraftingLogistics cpipe = (PipeItemsCraftingLogistics)pipe;
        FontRenderer var17 = renderer.func_147498_b();
        this.oldRenderedStack = null;
        if (cpipe != null) {
            List<ItemIdentifierStack> craftables = cpipe.getCraftedItems();
            String name = "";
            if (craftables != null && craftables.size() > 0) {
                ItemIdentifierStack itemstack;
                this.oldRenderedStack = itemstack = craftables.get(0);
                renderer.renderItemStackOnSign(itemstack.unsafeMakeNormalStack());
                Item item = itemstack.getItem().item;
                GlStateManager.func_179132_a((boolean)false);
                GL11.glRotatef((float)-180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.5f, (float)0.08f, (float)0.0f);
                GL11.glScalef((float)0.011111111f, (float)0.011111111f, (float)0.011111111f);
                try {
                    name = item.func_77653_i(itemstack.unsafeMakeNormalStack());
                }
                catch (Exception e) {
                    try {
                        name = item.func_77658_a();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                var17.func_78276_b(String.format("ID: %d", Item.func_150891_b((Item)item)), -var17.func_78256_a(String.format("ID: %d", Item.func_150891_b((Item)item))) / 2, -20, 0);
                ModuleCrafter logisticsMod = cpipe.getLogisticsModule();
                this.oldSatelliteName = logisticsMod.clientSideSatelliteNames.satelliteName;
                if (!this.oldSatelliteName.isEmpty()) {
                    var17.func_78276_b("Sat: " + this.oldSatelliteName, -var17.func_78256_a("Sat: " + this.oldSatelliteName) / 2, -10, 0);
                }
            } else {
                GL11.glRotatef((float)-180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.5f, (float)0.08f, (float)0.0f);
                GL11.glScalef((float)0.011111111f, (float)0.011111111f, (float)0.011111111f);
                name = "Empty";
            }
            name = renderer.cut(name, var17);
            var17.func_78276_b(name, -var17.func_78256_a(name) / 2 - 15, 10, 0);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Framebuffer getMCFrameBufferForSign() {
        if (!OpenGlHelper.func_148822_b()) {
            return null;
        }
        if (this.fbo == null) {
            this.fbo = new Framebuffer(128, 128, true);
        }
        return (Framebuffer)this.fbo;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean doesFrameBufferNeedUpdating(CoreRoutedPipe pipe, LogisticsRenderPipe renderer) {
        ItemIdentifierStack itemstack = this.getItemIdentifierStack((PipeItemsCraftingLogistics)pipe);
        if (itemstack != null && this.oldRenderedStack != null) {
            return this.fbo == null || !this.oldRenderedStack.equals(itemstack);
        }
        if (itemstack == null && this.oldRenderedStack == null) {
            return this.fbo == null;
        }
        return true;
    }

    @Nullable
    private ItemIdentifierStack getItemIdentifierStack(PipeItemsCraftingLogistics cpipe) {
        if (cpipe == null) {
            return null;
        }
        List<ItemIdentifierStack> craftables = cpipe.getCraftedItems();
        ItemIdentifierStack itemstack = null;
        if (craftables != null && craftables.size() > 0) {
            itemstack = craftables.get(0);
        }
        return itemstack;
    }
}

