/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.basic.fluid;

import java.util.List;
import javax.annotation.Nullable;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.ITankUtil;
import logisticspipes.interfaces.routing.IRequireReliableFluidTransport;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.pipes.PipeFluidUtil;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.ItemRoutingInformation;
import logisticspipes.routing.order.LogisticsFluidOrderManager;
import logisticspipes.routing.order.LogisticsOrderManager;
import logisticspipes.textures.Textures;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.transport.PipeFluidTransportLogistics;
import logisticspipes.utils.CacheHolder;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.FluidIdentifierStack;
import logisticspipes.utils.FluidSinkReply;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import network.rs485.logisticspipes.connection.LPNeighborTileEntityKt;
import network.rs485.logisticspipes.connection.NeighborTileEntity;

public abstract class FluidRoutedPipe
extends CoreRoutedPipe {
    private LogisticsFluidOrderManager _orderFluidManager;

    public FluidRoutedPipe(Item item) {
        super(new PipeFluidTransportLogistics(), item);
    }

    @Override
    public void setTile(TileEntity tile) {
        super.setTile(tile);
    }

    @Override
    public boolean logisitcsIsPipeConnected(TileEntity tile, EnumFacing dir) {
        ITankUtil tank = PipeFluidUtil.INSTANCE.getTankUtilForTE(tile, dir.func_176734_d());
        return tank != null && tank.containsTanks() || tile instanceof LogisticsTileGenericPipe;
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public Textures.TextureType getNonRoutedTexture(EnumFacing connection) {
        if (this.isFluidSidedTexture(connection)) {
            return Textures.LOGISTICSPIPE_LIQUID_TEXTURE;
        }
        return super.getNonRoutedTexture(connection);
    }

    private boolean isFluidSidedTexture(EnumFacing connection) {
        return this.getAvailableAdjacent().fluidTanks().stream().filter(neighbor -> neighbor.getDirection() == connection).findFirst().map(neighbor -> {
            ITankUtil tankUtil = LPNeighborTileEntityKt.getTankUtil(neighbor);
            return tankUtil != null && tankUtil.containsTanks();
        }).orElse(false);
    }

    @Override
    @Nullable
    public LogisticsModule getLogisticsModule() {
        return null;
    }

    public final boolean isConnectableTank(TileEntity tile, EnumFacing dir, boolean flag) {
        IFluidHandler fluidHandler;
        if (SimpleServiceLocator.specialTankHandler.hasHandlerFor(tile)) {
            return true;
        }
        boolean fluidTile = false;
        if (tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir) && (fluidHandler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir)) != null) {
            fluidTile = true;
        }
        if (tile instanceof IFluidHandler) {
            fluidTile = true;
        }
        if (!fluidTile) {
            return false;
        }
        if (!this.canPipeConnect(tile, dir)) {
            return false;
        }
        if (tile instanceof LogisticsTileGenericPipe) {
            if (((LogisticsTileGenericPipe)tile).pipe instanceof FluidRoutedPipe) {
                return false;
            }
            if (!flag) {
                return false;
            }
            if (((LogisticsTileGenericPipe)tile).pipe == null || !(((LogisticsTileGenericPipe)tile).pipe.transport instanceof IFluidHandler)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void enabledUpdateEntity() {
        super.enabledUpdateEntity();
        if (this.canInsertFromSideToTanks()) {
            int validDirections = 0;
            List<Pair<NeighborTileEntity<TileEntity>, ITankUtil>> list = PipeFluidUtil.INSTANCE.getAdjacentTanks(this, true);
            for (Pair<NeighborTileEntity<TileEntity>, ITankUtil> pair : list) {
                FluidStack drain;
                int filled;
                if (pair.getValue2() instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)((Object)pair.getValue2())).pipe instanceof CoreRoutedPipe) continue;
                FluidTank internalTank = ((PipeFluidTransportLogistics)this.transport).sideTanks[pair.getValue1().getDirection().ordinal()];
                ++validDirections;
                if (internalTank.getFluid() == null || (filled = pair.getValue2().fill(FluidIdentifierStack.getFromStack(internalTank.getFluid()), true)) == 0 || (drain = internalTank.drain(filled, true)) != null && filled == drain.amount || !LogisticsPipes.isDEBUG()) continue;
                throw new UnsupportedOperationException("Fluid Multiplication");
            }
            if (validDirections == 0) {
                return;
            }
            FluidTank tank = ((PipeFluidTransportLogistics)this.transport).internalTank;
            FluidStack stack = tank.getFluid();
            if (stack == null) {
                return;
            }
            for (Pair<NeighborTileEntity<TileEntity>, ITankUtil> pair : list) {
                FluidStack drain;
                int filled;
                if (pair.getValue1().isLogisticsPipe() && ((LogisticsTileGenericPipe)pair.getValue1().getTileEntity()).pipe instanceof CoreRoutedPipe) continue;
                FluidTank tankSide = ((PipeFluidTransportLogistics)this.transport).sideTanks[pair.getValue1().getDirection().ordinal()];
                stack = tank.getFluid();
                if (stack == null || (filled = tankSide.fill(stack = stack.copy(), true)) == 0 || (drain = tank.drain(filled, true)) != null && filled == drain.amount || !LogisticsPipes.isDEBUG()) continue;
                throw new UnsupportedOperationException("Fluid Multiplication");
            }
        }
    }

    public int countOnRoute(FluidIdentifier ident) {
        int amount = 0;
        for (ItemRoutingInformation next : this._inTransitToMe) {
            FluidIdentifierStack liquid;
            ItemIdentifierStack item = next.getItem();
            if (!item.getItem().isFluidContainer() || !(liquid = SimpleServiceLocator.logisticsFluidManager.getFluidFromContainer(item)).getFluid().equals(ident)) continue;
            amount += liquid.getAmount();
        }
        return amount;
    }

    public abstract boolean canInsertFromSideToTanks();

    public abstract boolean canInsertToTanks();

    public abstract boolean canReceiveFluid();

    public boolean endReached(LPTravelingItem.LPTravelingItemServer arrivingItem, TileEntity tile) {
        if (this.canInsertToTanks() && MainProxy.isServer((IBlockAccess)this.getWorld())) {
            int filled;
            this.getCacheHolder().trigger(CacheHolder.CacheTypes.Inventory);
            if (arrivingItem.getItemIdentifierStack() == null || !arrivingItem.getItemIdentifierStack().getItem().isFluidContainer()) {
                return false;
            }
            if (this.getRouter().getSimpleID() != arrivingItem.getDestination()) {
                return false;
            }
            FluidIdentifierStack liquid = SimpleServiceLocator.logisticsFluidManager.getFluidFromContainer(arrivingItem.getItemIdentifierStack());
            if (this.isConnectableTank(tile, arrivingItem.output, false)) {
                for (Pair<NeighborTileEntity<TileEntity>, ITankUtil> util : PipeFluidUtil.INSTANCE.getAdjacentTanks(this, false)) {
                    filled = util.getValue2().fill(liquid, true);
                    liquid.lowerAmount(filled);
                    if (liquid.getAmount() != 0) continue;
                    return true;
                }
                filled = ((PipeFluidTransportLogistics)this.transport).sideTanks[arrivingItem.output.ordinal()].fill(liquid.makeFluidStack(), true);
                if (filled == liquid.getAmount()) {
                    return true;
                }
                liquid.lowerAmount(filled);
            }
            if ((filled = ((PipeFluidTransportLogistics)this.transport).internalTank.fill(liquid.makeFluidStack(), true)) == liquid.getAmount()) {
                return true;
            }
            liquid.lowerAmount(filled);
            if (this instanceof IRequireReliableFluidTransport) {
                ((IRequireReliableFluidTransport)((Object)this)).liquidNotInserted(liquid.getFluid(), liquid.getAmount());
            }
            LPTravelingItem.LPTravelingItemServer routedItem = SimpleServiceLocator.routedItemHelper.createNewTravelItem(SimpleServiceLocator.logisticsFluidManager.getFluidContainer(liquid));
            Pair<Integer, FluidSinkReply> replies = SimpleServiceLocator.logisticsFluidManager.getBestReply(liquid, this.getRouter(), routedItem.getJamList());
            if (replies == null) {
                routedItem.setDestination(0);
            } else {
                int dest = replies.getValue1();
                routedItem.setDestination(dest);
            }
            routedItem.setTransportMode(IRoutedItem.TransportMode.Passive);
            this.queueRoutedItem(routedItem, arrivingItem.output.func_176734_d());
            return true;
        }
        return false;
    }

    @Override
    public boolean isFluidPipe() {
        return true;
    }

    @Override
    public boolean isOnSameContainer(CoreRoutedPipe other) {
        if (!(other instanceof FluidRoutedPipe)) {
            return false;
        }
        List<TileEntity> theirs = PipeFluidUtil.INSTANCE.getAllTankTiles((FluidRoutedPipe)other);
        for (TileEntity tile : PipeFluidUtil.INSTANCE.getAllTankTiles(this)) {
            if (!theirs.contains(tile)) continue;
            return true;
        }
        return false;
    }

    public LogisticsFluidOrderManager getFluidOrderManager() {
        this._orderFluidManager = this._orderFluidManager != null ? this._orderFluidManager : new LogisticsFluidOrderManager(this);
        return this._orderFluidManager;
    }

    @Override
    public LogisticsOrderManager<?, ?> getOrderManager() {
        return this.getFluidOrderManager();
    }
}

