/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.satpipe;

import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.abstractpackets.StringCoordinatesPacket;
import logisticspipes.network.packets.satpipe.SetNameResult;
import logisticspipes.pipes.SatelliteNamingResult;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.SatellitePipe;

@StaticResolve
public class SatelliteSetNamePacket
extends StringCoordinatesPacket {
    public SatelliteSetNamePacket(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsTileGenericPipe pipe = this.getPipe(player.func_130014_f_(), CoordinatesPacket.LTGPCompletionCheck.PIPE);
        if (pipe == null || pipe.pipe == null) {
            return;
        }
        String newName = this.getString();
        SatelliteNamingResult result2 = null;
        if (newName.trim().isEmpty()) {
            result2 = SatelliteNamingResult.BLANK_NAME;
        } else if (pipe.pipe instanceof SatellitePipe) {
            SatellitePipe satellitePipe = (SatellitePipe)((Object)pipe.pipe);
            if (satellitePipe.getSatellitesOfType().stream().anyMatch(it -> it.getSatellitePipeName().equals(newName))) {
                result2 = SatelliteNamingResult.DUPLICATE_NAME;
            } else {
                result2 = SatelliteNamingResult.SUCCESS;
                satellitePipe.setSatellitePipeName(newName);
                satellitePipe.updateWatchers();
                satellitePipe.ensureAllSatelliteStatus();
            }
        }
        if (result2 != null) {
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(SetNameResult.class).setResult(result2).setNewName(this.getString()), player);
        }
    }

    @Override
    public ModernPacket template() {
        return new SatelliteSetNamePacket(this.getId());
    }
}

