/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.orderer;

import java.util.ArrayList;
import java.util.Collection;
import logisticspipes.asm.ClientSideOnlyMethodContent;
import logisticspipes.config.Configs;
import logisticspipes.gui.orderer.GuiOrderer;
import logisticspipes.gui.orderer.GuiRequestTable;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.request.resources.IResource;
import logisticspipes.request.resources.ResourceNetwork;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.client.FMLClientHandler;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class ComponentList
extends ModernPacket {
    private Collection<IResource> used = new ArrayList<IResource>();
    private Collection<IResource> missing = new ArrayList<IResource>();

    public ComponentList(int id) {
        super(id);
    }

    @Override
    public ModernPacket template() {
        return new ComponentList(this.getId());
    }

    @Override
    @ClientSideOnlyMethodContent
    public void processPacket(EntityPlayer player) {
        if (Configs.DISPLAY_POPUP && FMLClientHandler.instance().getClient().field_71462_r instanceof GuiOrderer) {
            ((GuiOrderer)FMLClientHandler.instance().getClient().field_71462_r).handleSimulateAnswer(this.used, this.missing, (GuiOrderer)FMLClientHandler.instance().getClient().field_71462_r, player);
        } else if (Configs.DISPLAY_POPUP && FMLClientHandler.instance().getClient().field_71462_r instanceof GuiRequestTable) {
            ((GuiRequestTable)FMLClientHandler.instance().getClient().field_71462_r).handleSimulateAnswer(this.used, this.missing, (GuiRequestTable)FMLClientHandler.instance().getClient().field_71462_r, player);
        } else {
            for (IResource item : this.used) {
                player.func_145747_a((ITextComponent)new TextComponentString("Component: " + item.getDisplayText(IResource.ColorCode.SUCCESS)));
            }
            for (IResource item : this.missing) {
                player.func_145747_a((ITextComponent)new TextComponentString("Missing: " + item.getDisplayText(IResource.ColorCode.MISSING)));
            }
        }
    }

    @Override
    public void writeData(LPDataOutput output) {
        output.writeCollection(this.used);
        output.writeCollection(this.missing);
    }

    @Override
    public void readData(LPDataInput input) {
        this.used = input.readArrayList(ResourceNetwork::readResource);
        this.missing = input.readArrayList(ResourceNetwork::readResource);
    }

    public Collection<IResource> getUsed() {
        return this.used;
    }

    public ComponentList setUsed(Collection<IResource> used) {
        this.used = used;
        return this;
    }

    public Collection<IResource> getMissing() {
        return this.missing;
    }

    public ComponentList setMissing(Collection<IResource> missing) {
        this.missing = missing;
        return this;
    }
}

