/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.modules;

import logisticspipes.gui.GuiSupplierPipe;
import logisticspipes.modules.ModuleActiveSupplier;
import logisticspipes.network.abstractpackets.IntegerModuleCoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.client.FMLClientHandler;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class SupplierPipeMode
extends IntegerModuleCoordinatesPacket {
    private boolean hasPatternUpgrade;

    public SupplierPipeMode(int id) {
        super(id);
    }

    @Override
    public ModernPacket template() {
        return new SupplierPipeMode(this.getId());
    }

    @Override
    public void processPacket(EntityPlayer player) {
        ModuleActiveSupplier module = this.getLogisticsModule(player, ModuleActiveSupplier.class);
        if (module == null) {
            return;
        }
        if (this.hasPatternUpgrade) {
            module.patternMode.setValue(ModuleActiveSupplier.PatternMode.values()[this.getInteger()]);
        } else {
            module.requestMode.setValue(ModuleActiveSupplier.SupplyMode.values()[this.getInteger()]);
        }
        if (FMLClientHandler.instance().getClient().field_71462_r instanceof GuiSupplierPipe) {
            ((GuiSupplierPipe)FMLClientHandler.instance().getClient().field_71462_r).refreshMode();
        }
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.hasPatternUpgrade = input.readBoolean();
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeBoolean(this.hasPatternUpgrade);
    }

    public boolean isHasPatternUpgrade() {
        return this.hasPatternUpgrade;
    }

    public SupplierPipeMode setHasPatternUpgrade(boolean hasPatternUpgrade) {
        this.hasPatternUpgrade = hasPatternUpgrade;
        return this;
    }
}

