/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.gui;

import java.util.List;
import java.util.UUID;
import logisticspipes.gui.popup.GuiSelectSatellitePopup;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.utils.StaticResolve;
import logisticspipes.utils.gui.LogisticsBaseGuiScreen;
import logisticspipes.utils.gui.SubGuiScreen;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class ProvideSatellitePipeListPacket
extends ModernPacket {
    private List<Pair<String, UUID>> list;

    public ProvideSatellitePipeListPacket(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.list = input.readArrayList(input1 -> new Pair<String, UUID>(input1.readUTF(), input1.readUUID()));
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeCollection(this.list, (output1, object) -> {
            output1.writeUTF((String)object.getValue1());
            output1.writeUUID((UUID)object.getValue2());
        });
    }

    @Override
    public void processPacket(EntityPlayer player) {
        SubGuiScreen subGUI;
        if (Minecraft.func_71410_x().field_71462_r instanceof LogisticsBaseGuiScreen && (subGUI = ((LogisticsBaseGuiScreen)Minecraft.func_71410_x().field_71462_r).getSubGui()) instanceof GuiSelectSatellitePopup) {
            ((GuiSelectSatellitePopup)subGUI).handleSatelliteList(this.list);
        }
    }

    @Override
    public ModernPacket template() {
        return new ProvideSatellitePipeListPacket(this.getId());
    }

    public List<Pair<String, UUID>> getList() {
        return this.list;
    }

    public ProvideSatellitePipeListPacket setList(List<Pair<String, UUID>> list) {
        this.list = list;
        return this;
    }
}

