/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.gui;

import java.util.Optional;
import java.util.UUID;
import logisticspipes.blocks.LogisticsSecurityTileEntity;
import logisticspipes.interfaces.routing.IChannelManager;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.guis.EditChannelGuiProvider;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.channels.ChannelInformation;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class OpenEditChannelGUIPacket
extends CoordinatesPacket {
    private String identifier;

    public OpenEditChannelGUIPacket(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.identifier = input.readUTF();
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeUTF(this.identifier);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        TileEntity tile = player.func_130014_f_().func_175625_s(new BlockPos(this.getPosX(), this.getPosY(), this.getPosZ()));
        UUID securityID = null;
        if (tile instanceof LogisticsSecurityTileEntity) {
            LogisticsSecurityTileEntity security = (LogisticsSecurityTileEntity)tile;
            securityID = security.getSecId();
        }
        UUID finalSecurityID = securityID;
        IChannelManager channelManager = SimpleServiceLocator.channelManagerProvider.getChannelManager(player.func_130014_f_());
        Optional<ChannelInformation> match = channelManager.getChannels().stream().filter(channel -> channel.getChannelIdentifier().toString().equals(this.getIdentifier())).findFirst();
        match.ifPresent(channel -> NewGuiHandler.getGui(EditChannelGuiProvider.class).setResponsibleSecurityID(finalSecurityID).setChannel((ChannelInformation)channel).open(player));
    }

    @Override
    public ModernPacket template() {
        return new OpenEditChannelGUIPacket(this.getId());
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public OpenEditChannelGUIPacket setIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }
}

