/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.debuggui;

import logisticspipes.commands.commands.debug.DebugGuiController;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class DebugPanelOpen
extends ModernPacket {
    private String name;
    private int identification;

    public DebugPanelOpen(int id) {
        super(id);
    }

    @Override
    public ModernPacket template() {
        return new DebugPanelOpen(this.getId());
    }

    @Override
    public void readData(LPDataInput input) {
        this.setName(input.readUTF());
        this.setIdentification(input.readInt());
    }

    @Override
    public void writeData(LPDataOutput output) {
        output.writeUTF(this.getName());
        output.writeInt(this.getIdentification());
    }

    @Override
    public void processPacket(EntityPlayer player) {
        try {
            DebugGuiController.instance().createNewDebugGui(this.getName(), this.getIdentification());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isCompressable() {
        return true;
    }

    public DebugPanelOpen setName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public int getIdentification() {
        return this.identification;
    }

    public DebugPanelOpen setIdentification(int identification) {
        this.identification = identification;
        return this;
    }
}

