/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.debug;

import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.basic.debug.LogWindow;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class SendNewLogLine
extends ModernPacket {
    private int windowID;
    private String line;

    public SendNewLogLine(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInput input) {
        this.windowID = input.readInt();
        this.line = input.readUTF();
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogWindow.getWindow(this.windowID).newLine(this.line);
    }

    @Override
    public void writeData(LPDataOutput output) {
        output.writeInt(this.windowID);
        output.writeUTF(this.line);
    }

    @Override
    public ModernPacket template() {
        return new SendNewLogLine(this.getId());
    }

    @Override
    public boolean isCompressable() {
        return true;
    }

    public int getWindowID() {
        return this.windowID;
    }

    public SendNewLogLine setWindowID(int windowID) {
        this.windowID = windowID;
        return this;
    }

    public String getLine() {
        return this.line;
    }

    public SendNewLogLine setLine(String line) {
        this.line = line;
        return this;
    }
}

