/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.block;

import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import logisticspipes.blocks.stats.LogisticsStatisticsTileEntity;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.block.AmountTaskSubGui;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.StaticResolve;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;

@StaticResolve
public class RequestAmountTaskSubGui
extends CoordinatesPacket {
    public RequestAmountTaskSubGui(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsStatisticsTileEntity tile = this.getTileAs(player.func_130014_f_(), LogisticsStatisticsTileEntity.class);
        CoreRoutedPipe pipe = tile.getConnectedPipe();
        if (pipe == null) {
            return;
        }
        Map<ItemIdentifier, Integer> _availableItems = SimpleServiceLocator.logisticsManager.getAvailableItems(pipe.getRouter().getIRoutersByCost());
        LinkedList<ItemIdentifier> _craftableItems = SimpleServiceLocator.logisticsManager.getCraftableItems(pipe.getRouter().getIRoutersByCost());
        TreeSet<ItemIdentifierStack> _allItems = new TreeSet<ItemIdentifierStack>();
        for (Map.Entry<ItemIdentifier, Integer> entry : _availableItems.entrySet()) {
            ItemIdentifierStack newStack = entry.getKey().makeStack(entry.getValue());
            _allItems.add(newStack);
        }
        for (ItemIdentifier itemIdentifier : _craftableItems) {
            if (_availableItems.containsKey(itemIdentifier)) continue;
            _allItems.add(itemIdentifier.makeStack(1));
        }
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(AmountTaskSubGui.class).setIdentSet(_allItems), player);
    }

    @Override
    public ModernPacket template() {
        return new RequestAmountTaskSubGui(this.getId());
    }
}

