/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.guis.module.inpipe;

import java.util.BitSet;
import logisticspipes.modules.ModuleItemSink;
import logisticspipes.network.abstractguis.GuiProvider;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import network.rs485.logisticspipes.gui.module.ItemSinkGui;
import network.rs485.logisticspipes.inventory.container.ItemSinkContainer;
import network.rs485.logisticspipes.property.layer.PropertyLayer;
import network.rs485.logisticspipes.property.layer.SimplePropertyOverlay;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class ItemSinkSlot
extends ModuleCoordinatesGuiProvider {
    private boolean isDefaultRoute;
    private boolean hasFuzzyUpgrade;
    private BitSet fuzzyFlags;

    public ItemSinkSlot(int id) {
        super(id);
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeBoolean(this.isDefaultRoute);
        output.writeBoolean(this.hasFuzzyUpgrade);
        output.writeBitSet(this.fuzzyFlags);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.isDefaultRoute = input.readBoolean();
        this.hasFuzzyUpgrade = input.readBoolean();
        this.fuzzyFlags = input.readBitSet();
    }

    @Override
    public Object getClientGui(EntityPlayer player) {
        ModuleItemSink module = this.getLogisticsModule(player.func_130014_f_(), ModuleItemSink.class);
        if (module == null) {
            return null;
        }
        module.setDefaultRoute(this.isDefaultRoute);
        module.setFuzzyFlags(this.fuzzyFlags);
        return ItemSinkGui.create((IInventory)player.field_71071_by, module, ItemStack.field_190927_a, this.hasFuzzyUpgrade, false);
    }

    @Override
    public ItemSinkContainer getContainer(EntityPlayer player) {
        ModuleItemSink module = this.getLogisticsModule(player.func_130014_f_(), ModuleItemSink.class);
        if (module == null) {
            return null;
        }
        return new ItemSinkContainer((IInventory)player.field_71071_by, new SimplePropertyOverlay(module.filterInventory), module, new PropertyLayer(module.getProperties()), this.hasFuzzyUpgrade, ItemStack.field_190927_a);
    }

    @Override
    public GuiProvider template() {
        return new ItemSinkSlot(this.getId());
    }

    public boolean isDefaultRoute() {
        return this.isDefaultRoute;
    }

    public ItemSinkSlot setDefaultRoute(boolean isDefaultRoute) {
        this.isDefaultRoute = isDefaultRoute;
        return this;
    }

    public boolean isHasFuzzyUpgrade() {
        return this.hasFuzzyUpgrade;
    }

    public ItemSinkSlot setHasFuzzyUpgrade(boolean hasFuzzyUpgrade) {
        this.hasFuzzyUpgrade = hasFuzzyUpgrade;
        return this;
    }

    public BitSet getFuzzyFlags() {
        return this.fuzzyFlags;
    }

    public ItemSinkSlot setFuzzyFlags(BitSet fuzzyFlags) {
        this.fuzzyFlags = fuzzyFlags;
        return this;
    }
}

