/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.guis;

import java.util.UUID;
import logisticspipes.gui.popup.GuiEditChannelPopup;
import logisticspipes.network.abstractguis.GuiProvider;
import logisticspipes.network.abstractguis.PopupGuiProvider;
import logisticspipes.routing.channels.ChannelInformation;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class EditChannelGuiProvider
extends PopupGuiProvider {
    private ChannelInformation channel;
    private UUID responsibleSecurityID;

    public EditChannelGuiProvider(int id) {
        super(id);
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeChannelInformation(this.channel);
        output.writeUUID(this.responsibleSecurityID);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.channel = input.readChannelInformation();
        this.responsibleSecurityID = input.readUUID();
    }

    @Override
    public Object getClientGui(EntityPlayer player) {
        return new GuiEditChannelPopup(this.responsibleSecurityID, this.channel);
    }

    @Override
    public GuiProvider template() {
        return new EditChannelGuiProvider(this.getId());
    }

    public ChannelInformation getChannel() {
        return this.channel;
    }

    public EditChannelGuiProvider setChannel(ChannelInformation channel) {
        this.channel = channel;
        return this;
    }

    public UUID getResponsibleSecurityID() {
        return this.responsibleSecurityID;
    }

    public EditChannelGuiProvider setResponsibleSecurityID(UUID responsibleSecurityID) {
        this.responsibleSecurityID = responsibleSecurityID;
        return this;
    }
}

