/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.abstractguis;

import javax.annotation.Nonnull;
import logisticspipes.network.abstractguis.PopupGuiProvider;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;
import network.rs485.logisticspipes.world.DoubleCoordinates;

public abstract class CoordinatesPopupGuiProvider
extends PopupGuiProvider {
    private int posX;
    private int posY;
    private int posZ;

    public CoordinatesPopupGuiProvider(int id) {
        super(id);
    }

    @Override
    public void writeData(LPDataOutput output) {
        output.writeInt(this.posX);
        output.writeInt(this.posY);
        output.writeInt(this.posZ);
    }

    @Override
    public void readData(LPDataInput input) {
        this.posX = input.readInt();
        this.posY = input.readInt();
        this.posZ = input.readInt();
    }

    public CoordinatesPopupGuiProvider setTilePos(TileEntity tile) {
        this.setPosX(tile.func_174877_v().func_177958_n());
        this.setPosY(tile.func_174877_v().func_177956_o());
        this.setPosZ(tile.func_174877_v().func_177952_p());
        return this;
    }

    public CoordinatesPopupGuiProvider setLPPos(DoubleCoordinates pos) {
        this.setPosX(pos.getXInt());
        this.setPosY(pos.getYInt());
        this.setPosZ(pos.getZInt());
        return this;
    }

    @Nonnull
    public <T> T getTileAs(World world, Class<T> clazz) {
        return CoordinatesPacket.getTileAs(this, world, new BlockPos(this.getPosX(), this.getPosY(), this.getPosZ()), clazz);
    }

    public String toString() {
        return "CoordinatesPopupGuiProvider(posX=" + this.getPosX() + ", posY=" + this.getPosY() + ", posZ=" + this.getPosZ() + ")";
    }

    public int getPosX() {
        return this.posX;
    }

    public CoordinatesPopupGuiProvider setPosX(int posX) {
        this.posX = posX;
        return this;
    }

    public int getPosY() {
        return this.posY;
    }

    public CoordinatesPopupGuiProvider setPosY(int posY) {
        this.posY = posY;
        return this;
    }

    public int getPosZ() {
        return this.posZ;
    }

    public CoordinatesPopupGuiProvider setPosZ(int posZ) {
        this.posZ = posZ;
        return this;
    }
}

