/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.IModuleInventoryReceive;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.IPipeServiceProvider;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.interfaces.routing.IRequireReliableTransport;
import logisticspipes.interfaces.routing.ITargetSlotInformation;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.guis.module.inhand.ActiveSupplierInHand;
import logisticspipes.network.guis.module.inpipe.ActiveSupplierSlot;
import logisticspipes.network.packets.hud.HUDStartModuleWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopModuleWatchingPacket;
import logisticspipes.network.packets.module.ModuleInventory;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.PipeLogisticsChassis;
import logisticspipes.pipes.basic.debug.StatusEntry;
import logisticspipes.proxy.MainProxy;
import logisticspipes.request.RequestTree;
import logisticspipes.routing.IRouter;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.connection.AdjacentUtilKt;
import network.rs485.logisticspipes.module.Gui;
import network.rs485.logisticspipes.property.BooleanProperty;
import network.rs485.logisticspipes.property.EnumProperty;
import network.rs485.logisticspipes.property.IntListProperty;
import network.rs485.logisticspipes.property.ItemIdentifierInventoryProperty;
import network.rs485.logisticspipes.property.Property;

public class ModuleActiveSupplier
extends LogisticsModule
implements IRequestItems,
IRequireReliableTransport,
IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver,
IModuleInventoryReceive,
ISimpleInventoryEventHandler,
Gui {
    public static final int SUPPLIER_SLOTS = 9;
    private final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private final HashMap<ItemIdentifier, Integer> _requestedItems = new HashMap();
    public final IntListProperty slotAssignmentPattern = new IntListProperty("slotpattern");
    public final EnumProperty<PatternMode> patternMode = new EnumProperty((Enum)PatternMode.Bulk50, "patternmode", (Enum[])PatternMode.values());
    public final ItemIdentifierInventoryProperty inventory = new ItemIdentifierInventoryProperty(new ItemIdentifierInventory(9, "", 127), "");
    public final EnumProperty<SupplyMode> requestMode = new EnumProperty((Enum)SupplyMode.Bulk50, "requestmode", (Enum[])SupplyMode.values());
    public final BooleanProperty isLimited = new BooleanProperty(true, "limited");
    private final List<Property<?>> properties = ImmutableList.builder().add((Object)this.slotAssignmentPattern).add(this.patternMode).add((Object)this.inventory).add(this.requestMode).add((Object)this.isLimited).build();
    private boolean _lastRequestFailed = false;

    public ModuleActiveSupplier() {
        this.inventory.addListener(this);
        this.slotAssignmentPattern.ensureSize(9);
    }

    public static String getName() {
        return "active_supplier";
    }

    @Override
    @Nonnull
    public String getLPName() {
        return ModuleActiveSupplier.getName();
    }

    @Override
    @NotNull
    public List<Property<?>> getProperties() {
        return this.properties;
    }

    @Override
    @Nonnull
    public List<String> getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Supplied: ");
        list.add("<inventory>");
        list.add("<that>");
        return list;
    }

    @Override
    public void startHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void stopHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ModuleInventory.class).setIdentList(ItemIdentifierStack.getListFromInventory(this.inventory)).setModulePos(this), player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public IHUDModuleRenderer getHUDRenderer() {
        return null;
    }

    @Override
    public void handleInvContent(@Nonnull Collection<ItemIdentifierStack> list) {
        this.inventory.handleItemIdentifierList(list);
    }

    @Override
    public void InventoryChanged(IInventory inventory) {
        if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ModuleInventory.class).setIdentList(ItemIdentifierStack.getListFromInventory(inventory)).setModulePos(this), this.localModeWatchers);
        }
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean receivePassive() {
        return true;
    }

    public boolean isRequestFailed() {
        return this._lastRequestFailed;
    }

    public void setRequestFailed(boolean value) {
        this._lastRequestFailed = value;
    }

    @Override
    public void tick() {
        IPipeServiceProvider service = Objects.requireNonNull(this._service);
        if (!service.isNthTick(100)) {
            return;
        }
        this._requestedItems.values().stream().filter(amount -> amount > 0).forEach(amount -> service.spawnParticle(Particles.VioletParticle, 2));
        AdjacentUtilKt.sneakyInventoryUtils(service.getAvailableAdjacent(), this.getUpgradeManager()).stream().filter(invUtil -> invUtil != null && invUtil.getSizeInventory() > 0).forEach(invUtil -> {
            if (this.getUpgradeManager().hasPatternUpgrade()) {
                this.createPatternRequest((IInventoryUtil)invUtil);
            } else {
                this.createSupplyRequest((IInventoryUtil)invUtil);
            }
        });
    }

    private void createPatternRequest(IInventoryUtil invUtil) {
        IPipeServiceProvider service = Objects.requireNonNull(this._service);
        service.getDebug().log("Supplier: Start calculating pattern request");
        this.setRequestFailed(false);
        for (int i = 0; i < 9; ++i) {
            int neededCount;
            ItemIdentifierStack needed = this.inventory.getIDStackInSlot(i);
            if (needed == null) continue;
            Integer slotAssignedTo = (Integer)this.slotAssignmentPattern.get(i);
            if (invUtil.getSizeInventory() <= slotAssignedTo) continue;
            ItemStack stack = invUtil.getStackInSlot(slotAssignedTo);
            ItemIdentifierStack have = null;
            if (!stack.func_190926_b()) {
                have = ItemIdentifierStack.getFromStack(stack);
            }
            int haveCount = 0;
            if (have != null) {
                if (!have.getItem().equals(needed.getItem())) {
                    service.getDebug().log("Supplier: Slot for " + i + ", " + needed + " already taken by " + have);
                    this.setRequestFailed(true);
                    continue;
                }
                haveCount = have.getStackSize();
            }
            if (this.patternMode.getValue() == PatternMode.Bulk50 && haveCount > needed.getStackSize() / 2 || this.patternMode.getValue() == PatternMode.Bulk100 && haveCount > 0) continue;
            Integer requestedCount = this._requestedItems.get(needed.getItem());
            if (requestedCount != null) {
                haveCount += requestedCount.intValue();
            }
            if ((neededCount = needed.getStackSize() - haveCount) < 1) continue;
            ItemIdentifierStack toRequest = new ItemIdentifierStack(needed.getItem(), neededCount);
            service.getDebug().log("Supplier: Missing for slot " + i + ": " + toRequest);
            if (!service.useEnergy(10)) break;
            boolean success = false;
            PatternSupplierTargetInformation targetInformation = new PatternSupplierTargetInformation(slotAssignedTo, needed.getStackSize());
            if (this.patternMode.getValue() != PatternMode.Full) {
                service.getDebug().log("Supplier: Requesting partial: " + toRequest);
                neededCount = RequestTree.requestPartial(toRequest, this, targetInformation);
                service.getDebug().log("Supplier: Requested: " + toRequest.getItem().makeStack(neededCount));
                if (neededCount > 0) {
                    success = true;
                }
            } else {
                service.getDebug().log("Supplier: Requesting: " + toRequest);
                success = RequestTree.request(toRequest, this, null, targetInformation);
                if (success) {
                    service.getDebug().log("Supplier: Request success");
                } else {
                    service.getDebug().log("Supplier: Request failed");
                }
            }
            if (success) {
                Integer currentRequest = this._requestedItems.get(toRequest.getItem());
                if (currentRequest == null) {
                    this._requestedItems.put(toRequest.getItem(), neededCount);
                    continue;
                }
                this._requestedItems.put(toRequest.getItem(), currentRequest + neededCount);
                continue;
            }
            this.setRequestFailed(true);
        }
    }

    private void createSupplyRequest(IInventoryUtil invUtil) {
        IPipeServiceProvider service = Objects.requireNonNull(this._service);
        service.getDebug().log("Supplier: Start calculating supply request");
        HashMap<ItemIdentifier, Integer> needed = new HashMap<ItemIdentifier, Integer>(this.inventory.getItemsAndCount());
        service.getDebug().log("Supplier: Needed: " + needed);
        Map<ItemIdentifier, Integer> have = invUtil.getItemsAndCount();
        service.getDebug().log("Supplier: Have:   " + have);
        HashMap<ItemIdentifier, Integer> haveUndamaged = new HashMap<ItemIdentifier, Integer>();
        for (Map.Entry<ItemIdentifier, Integer> item : have.entrySet()) {
            haveUndamaged.merge(item.getKey().getUndamaged(), item.getValue(), Integer::sum);
        }
        for (Map.Entry<ItemIdentifier, Integer> item : needed.entrySet()) {
            Integer requestedCount;
            int haveCount = haveUndamaged.getOrDefault(item.getKey().getUndamaged(), 0);
            int spaceAvailable = invUtil.roomForItem(item.getKey().unsafeMakeNormalStack(Integer.MAX_VALUE));
            if (this.requestMode.getValue() == SupplyMode.Infinite) {
                requestedCount = this._requestedItems.get(item.getKey());
                if (requestedCount != null) {
                    spaceAvailable -= requestedCount.intValue();
                }
                item.setValue(Math.min(item.getKey().getMaxStackSize(), Math.max(0, spaceAvailable)));
                continue;
            }
            if (spaceAvailable < 1 || this.requestMode.getValue() == SupplyMode.Bulk50 && haveCount > item.getValue() / 2 || this.requestMode.getValue() == SupplyMode.Bulk100 && haveCount > 0) {
                item.setValue(0);
                continue;
            }
            if (haveCount > 0) {
                item.setValue(item.getValue() - haveCount);
                haveUndamaged.put(item.getKey().getUndamaged(), haveCount - item.getValue());
            }
            if ((requestedCount = this._requestedItems.get(item.getKey())) == null) continue;
            item.setValue(item.getValue() - requestedCount);
        }
        service.getDebug().log("Supplier: Missing:   " + needed);
        this.setRequestFailed(false);
        for (Map.Entry<ItemIdentifier, Integer> need : needed.entrySet()) {
            Integer amountRequested = need.getValue();
            if (amountRequested == null || amountRequested < 1) continue;
            int neededCount = amountRequested;
            if (!service.useEnergy(10)) break;
            boolean success = false;
            SupplierTargetInformation targetInformation = new SupplierTargetInformation();
            if (this.requestMode.getValue() != SupplyMode.Full) {
                service.getDebug().log("Supplier: Requesting partial: " + need.getKey().makeStack(neededCount));
                neededCount = RequestTree.requestPartial(need.getKey().makeStack(neededCount), this, targetInformation);
                service.getDebug().log("Supplier: Requested: " + need.getKey().makeStack(neededCount));
                if (neededCount > 0) {
                    success = true;
                }
            } else {
                service.getDebug().log("Supplier: Requesting: " + need.getKey().makeStack(neededCount));
                success = RequestTree.request(need.getKey().makeStack(neededCount), this, null, targetInformation);
                if (success) {
                    service.getDebug().log("Supplier: Request success");
                } else {
                    service.getDebug().log("Supplier: Request failed");
                }
            }
            if (success) {
                Integer currentRequest = this._requestedItems.get(need.getKey());
                if (currentRequest == null) {
                    this._requestedItems.put(need.getKey(), neededCount);
                    service.getDebug().log("Supplier: Inserting Requested Items: " + neededCount);
                    continue;
                }
                this._requestedItems.put(need.getKey(), currentRequest + neededCount);
                service.getDebug().log("Supplier: Raising Requested Items from: " + currentRequest + " to: " + currentRequest + neededCount);
                continue;
            }
            this.setRequestFailed(true);
        }
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound tag) {
        super.readFromNBT(tag);
        List<Pair> slotArrayList = IntStream.range(0, 9).mapToObj(idx -> new Pair<Integer, String>(idx, "slotArray_" + idx)).filter(it -> tag.func_74764_b((String)it.getValue2())).collect(Collectors.toList());
        if (!slotArrayList.isEmpty()) {
            int[] slotArray = new int[9];
            slotArrayList.forEach(pair -> {
                slotArray[((Integer)pair.getValue1()).intValue()] = tag.func_74762_e((String)pair.getValue2());
            });
            this.slotAssignmentPattern.replaceContent(slotArray);
        }
    }

    private void decreaseRequested(ItemIdentifierStack item) {
        IPipeServiceProvider service = Objects.requireNonNull(this._service);
        int remaining = item.getStackSize();
        Integer count2 = this._requestedItems.get(item.getItem());
        if (count2 != null) {
            service.getDebug().log("Supplier: Exact match. Still missing: " + Math.max(0, count2 - remaining));
            if (count2 - remaining > 0) {
                this._requestedItems.put(item.getItem(), count2 - remaining);
            } else {
                this._requestedItems.remove(item.getItem());
            }
            remaining -= count2.intValue();
        }
        if (remaining <= 0) {
            return;
        }
        Iterator<Map.Entry<ItemIdentifier, Integer>> it = this._requestedItems.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ItemIdentifier, Integer> e = it.next();
            if (e.getKey().equalsWithoutNBT(item.getItem())) {
                int expected = e.getValue();
                service.getDebug().log("Supplier: Fuzzy match with" + e + ". Still missing: " + Math.max(0, expected - remaining));
                if (expected - remaining > 0) {
                    e.setValue(expected - remaining);
                } else {
                    it.remove();
                }
                remaining -= expected;
            }
            if (remaining > 0) continue;
            return;
        }
        service.getDebug().log("Supplier: supplier got unexpected item " + item);
    }

    @Override
    public void itemLost(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        IPipeServiceProvider service = Objects.requireNonNull(this._service);
        service.getDebug().log("Supplier: Registered Item Lost: " + item);
        this.decreaseRequested(item);
    }

    @Override
    public void itemArrived(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        IPipeServiceProvider service = Objects.requireNonNull(this._service);
        service.getDebug().log("Supplier: Registered Item Arrived: " + item);
        this.decreaseRequested(item);
    }

    public void addStatusInformation(List<StatusEntry> status) {
        StatusEntry entry = new StatusEntry();
        entry.name = "Requested Items";
        entry.subEntry = new ArrayList<StatusEntry>();
        for (Map.Entry<ItemIdentifier, Integer> part : this._requestedItems.entrySet()) {
            StatusEntry subEntry = new StatusEntry();
            subEntry.name = part.toString();
            entry.subEntry.add(subEntry);
        }
        status.add(entry);
    }

    @Override
    @Nonnull
    public ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        boolean hasPatternUpgrade = this.hasPatternUpgrade();
        return NewGuiHandler.getGui(ActiveSupplierSlot.class).setPatternUpgarde(hasPatternUpgrade).setSlotArray(this.slotAssignmentPattern.stream().mapToInt(Integer::intValue).toArray()).setMode((hasPatternUpgrade ? (Enum)this.patternMode.getValue() : (Enum)this.requestMode.getValue()).ordinal()).setLimit((Boolean)this.isLimited.getValue());
    }

    @Override
    @Nonnull
    public ModuleInHandGuiProvider getInHandGuiProvider() {
        return NewGuiHandler.getGui(ActiveSupplierInHand.class);
    }

    @Override
    @Nonnull
    public IRouter getRouter() {
        IPipeServiceProvider service = Objects.requireNonNull(this._service);
        return service.getRouter();
    }

    @Override
    public void itemCouldNotBeSend(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        this.itemLost(item, info);
    }

    @Override
    public int compareTo(@Nonnull IRequestItems other) {
        return Integer.compare(this.getID(), other.getID());
    }

    @Override
    public int getID() {
        return this.getRouter().getSimpleID();
    }

    public boolean hasPatternUpgrade() {
        return this.getUpgradeManager().hasPatternUpgrade();
    }

    public class SupplierTargetInformation
    extends PipeLogisticsChassis.ChassiTargetInformation {
        public SupplierTargetInformation() {
            super(ModuleActiveSupplier.this.getPositionInt());
        }
    }

    public class PatternSupplierTargetInformation
    extends SupplierTargetInformation
    implements ITargetSlotInformation {
        private final int amount;
        private final int targetSlot;

        public PatternSupplierTargetInformation(int targetSlot, int amount) {
            this.targetSlot = targetSlot;
            this.amount = amount;
        }

        @Override
        public int getTargetSlot() {
            return this.targetSlot;
        }

        @Override
        public int getAmount() {
            return this.amount;
        }

        @Override
        public boolean isLimited() {
            return (Boolean)ModuleActiveSupplier.this.isLimited.getValue();
        }
    }

    public static enum PatternMode {
        Partial,
        Full,
        Bulk50,
        Bulk100;

    }

    public static enum SupplyMode {
        Partial,
        Full,
        Bulk50,
        Bulk100,
        Infinite;

    }
}

