/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modplugins.jei;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.gui.GuiLogisticsCraftingTable;
import logisticspipes.gui.orderer.GuiRequestTable;
import logisticspipes.gui.popup.GuiRecipeImport;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.NEISetCraftingRecipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.gui.DummyContainer;
import logisticspipes.utils.gui.LogisticsBaseGuiScreen;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;

public class RecipeTransferHandler
implements IRecipeTransferHandler<DummyContainer> {
    private final IRecipeTransferHandlerHelper recipeTransferHandlerHelper;

    public RecipeTransferHandler(IRecipeTransferHandlerHelper recipeTransferHandlerHelper) {
        this.recipeTransferHandlerHelper = recipeTransferHandlerHelper;
    }

    @Nonnull
    public Class<DummyContainer> getContainerClass() {
        return DummyContainer.class;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(@Nonnull DummyContainer container, @Nonnull IRecipeLayout recipeLayout, @Nonnull EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        LogisticsBaseGuiScreen gui = container.guiHolderForJEI;
        if (gui instanceof GuiLogisticsCraftingTable || gui instanceof GuiRequestTable) {
            TileEntity tile = gui instanceof GuiLogisticsCraftingTable ? ((GuiLogisticsCraftingTable)gui)._crafter : ((GuiRequestTable)gui)._table.container;
            if (tile == null) {
                return this.recipeTransferHandlerHelper.createInternalError();
            }
            if (!recipeLayout.getRecipeCategory().getUid().equals("minecraft.crafting")) {
                return this.recipeTransferHandlerHelper.createInternalError();
            }
            NEISetCraftingRecipe packet = PacketHandler.getPacket(NEISetCraftingRecipe.class);
            NonNullList<ItemStack> stackList = packet.getStackList();
            ItemStack[][] stacks = new ItemStack[9][];
            boolean hasCandidates = false;
            IGuiItemStackGroup guiItemStackGroup = recipeLayout.getItemStacks();
            Map guiIngredients = guiItemStackGroup.getGuiIngredients();
            if (doTransfer) {
                for (Map.Entry ps : guiIngredients.entrySet()) {
                    int slot;
                    if (!((IGuiIngredient)ps.getValue()).isInput() || (slot = (Integer)ps.getKey() - 1) >= 9) continue;
                    ItemStack displayedIngredient = (ItemStack)((IGuiIngredient)ps.getValue()).getDisplayedIngredient();
                    stackList.set(slot, (Object)(displayedIngredient == null ? ItemStack.field_190927_a : displayedIngredient));
                    NonNullList itemCandidateList = NonNullList.func_191196_a();
                    ((IGuiIngredient)ps.getValue()).getAllIngredients().stream().filter(itemStack -> Objects.nonNull(itemStack) && !itemStack.func_190926_b()).forEach(arg_0 -> itemCandidateList.add(arg_0));
                    if (itemCandidateList.isEmpty()) continue;
                    Iterator iter = itemCandidateList.iterator();
                    while (iter.hasNext()) {
                        ItemStack wildCardCheckStack = (ItemStack)iter.next();
                        if (wildCardCheckStack.func_77952_i() != Short.MAX_VALUE) continue;
                        iter.remove();
                        CreativeTabs creativeTab = wildCardCheckStack.func_77973_b().func_77640_w();
                        if (creativeTab != null) {
                            NonNullList secondList = NonNullList.func_191196_a();
                            wildCardCheckStack.func_77973_b().func_150895_a(creativeTab, secondList);
                            itemCandidateList.addAll((Collection)secondList);
                        }
                        iter = itemCandidateList.iterator();
                    }
                    stacks[slot] = (ItemStack[])itemCandidateList.toArray((Object[])new ItemStack[0]);
                    if (stacks[slot].length > 1) {
                        hasCandidates = true;
                        continue;
                    }
                    if (stacks[slot].length != 1) continue;
                    stackList.set(slot, (Object)stacks[slot][0]);
                }
                if (hasCandidates) {
                    gui.setSubGui(new GuiRecipeImport(tile, stacks));
                } else {
                    MainProxy.sendPacketToServer(packet.setTilePos(tile));
                }
            }
            return null;
        }
        return this.recipeTransferHandlerHelper.createInternalError();
    }
}

