/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import logisticspipes.items.LogisticsItem;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.pipes.signs.CraftingPipeSign;
import logisticspipes.pipes.signs.IPipeSign;
import logisticspipes.pipes.signs.ItemAmountPipeSign;
import logisticspipes.proxy.MainProxy;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemPipeSignCreator
extends LogisticsItem {
    public static final List<Class<? extends IPipeSign>> signTypes = new ArrayList<Class<? extends IPipeSign>>();

    public ItemPipeSignCreator() {
        this.func_77625_d(1);
        this.func_77656_e(250);
        this.func_77627_a(true);
    }

    public boolean func_77616_k(@Nonnull ItemStack stack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(@Nonnull ItemStack stack, Enchantment enchantment) {
        return false;
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (MainProxy.isClient((IBlockAccess)world)) {
            return EnumActionResult.FAIL;
        }
        ItemStack itemStack = player.field_71071_by.func_70448_g();
        if (itemStack.func_190926_b() || itemStack.func_77952_i() > this.func_77612_l()) {
            return EnumActionResult.FAIL;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof LogisticsTileGenericPipe)) {
            return EnumActionResult.FAIL;
        }
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74768_a("PipeClicked", 0);
        int mode = itemStack.func_77978_p().func_74762_e("CreatorMode");
        if (facing == null) {
            return EnumActionResult.FAIL;
        }
        if (!(((LogisticsTileGenericPipe)tile).pipe instanceof CoreRoutedPipe)) {
            return EnumActionResult.FAIL;
        }
        CoreRoutedPipe pipe = (CoreRoutedPipe)((LogisticsTileGenericPipe)tile).pipe;
        if (pipe == null) {
            return EnumActionResult.FAIL;
        }
        if (!player.func_70093_af()) {
            if (pipe.hasPipeSign(facing)) {
                pipe.activatePipeSign(facing, player);
                return EnumActionResult.SUCCESS;
            }
            if (mode >= 0 && mode < signTypes.size()) {
                Class<? extends IPipeSign> signClass = signTypes.get(mode);
                try {
                    IPipeSign sign = signClass.newInstance();
                    if (sign.isAllowedFor(pipe)) {
                        itemStack.func_77972_a(1, (EntityLivingBase)player);
                        sign.addSignTo(pipe, facing, player);
                        return EnumActionResult.SUCCESS;
                    }
                    return EnumActionResult.FAIL;
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException(e);
                }
            }
            return EnumActionResult.FAIL;
        }
        if (pipe.hasPipeSign(facing)) {
            pipe.removePipeSign(facing, player);
            itemStack.func_77972_a(-1, (EntityLivingBase)player);
        }
        return EnumActionResult.SUCCESS;
    }

    public int getMetadata(@Nonnull ItemStack stack) {
        if (stack.func_190926_b() || !stack.func_77942_o()) {
            return 0;
        }
        int mode = Objects.requireNonNull(stack.func_77978_p()).func_74762_e("CreatorMode");
        return Math.min(mode, signTypes.size() - 1);
    }

    @Override
    public int getModelCount() {
        return signTypes.size();
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (MainProxy.isClient((IBlockAccess)world)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        if (player.func_70093_af()) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (!stack.func_77978_p().func_74764_b("PipeClicked")) {
                int mode = stack.func_77978_p().func_74762_e("CreatorMode");
                if (++mode >= signTypes.size()) {
                    mode = 0;
                }
                stack.func_77978_p().func_74768_a("CreatorMode", mode);
            }
        }
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o("PipeClicked");
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public static void registerPipeSignTypes() {
        signTypes.add(CraftingPipeSign.class);
        signTypes.add(ItemAmountPipeSign.class);
    }
}

