/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui.popup;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.gui.RequestSatellitePipeListPacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.SmallGuiButton;
import logisticspipes.utils.gui.SubGuiScreen;
import logisticspipes.utils.gui.TextListDisplay;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.math.BlockPos;
import network.rs485.logisticspipes.util.TextUtil;
import org.lwjgl.input.Mouse;

public class GuiSelectSatellitePopup
extends SubGuiScreen {
    String GUI_LANG_KEY = "gui.popup.selectsatellite.";
    private final Consumer<UUID> handleResult;
    private List<Pair<String, UUID>> pipeList = Collections.EMPTY_LIST;
    private final TextListDisplay textList;

    public GuiSelectSatellitePopup(BlockPos pos, boolean fluidSatellites, Consumer<UUID> handleResult) {
        super(150, 170, 0, 0);
        this.handleResult = handleResult;
        this.textList = new TextListDisplay(this, 6, 16, 6, 30, 12, new TextListDisplay.List(){

            @Override
            public int getSize() {
                return GuiSelectSatellitePopup.this.pipeList.size();
            }

            @Override
            public String getTextAt(int index) {
                return (String)((Pair)GuiSelectSatellitePopup.this.pipeList.get(index)).getValue1();
            }

            @Override
            public int getTextColor(int index) {
                return 0xFFFFFF;
            }
        });
        MainProxy.sendPacketToServer(PacketHandler.getPacket(RequestSatellitePipeListPacket.class).setFlag(fluidSatellites).setBlockPos(pos));
    }

    protected void drawTitle() {
        this.field_146297_k.field_71466_p.func_175063_a(TextUtil.translate(this.GUI_LANG_KEY + "title", new String[0]), (float)this.xCenter - (float)this.field_146297_k.field_71466_p.func_78256_a(TextUtil.translate(this.GUI_LANG_KEY + "title", new String[0])) / 2.0f, (float)(this.guiTop + 6), 0xFFFFFF);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new SmallGuiButton(0, this.xCenter + 16, this.bottom - 27, 50, 10, TextUtil.translate(this.GUI_LANG_KEY + "select", new String[0])));
        this.field_146292_n.add(new SmallGuiButton(1, this.xCenter + 16, this.bottom - 15, 50, 10, TextUtil.translate(this.GUI_LANG_KEY + "exit", new String[0])));
        this.field_146292_n.add(new SmallGuiButton(2, this.xCenter - 66, this.bottom - 27, 50, 10, TextUtil.translate(this.GUI_LANG_KEY + "unset", new String[0])));
        this.field_146292_n.add(new SmallGuiButton(4, this.xCenter - 12, this.bottom - 27, 25, 10, "/\\"));
        this.field_146292_n.add(new SmallGuiButton(5, this.xCenter - 12, this.bottom - 15, 25, 10, "\\/"));
    }

    @Override
    protected void renderGuiBackground(int mouseX, int mouseY) {
        GuiGraphics.drawGuiBackGround(this.field_146297_k, this.guiLeft, this.guiTop, this.right, this.bottom, this.field_73735_i, true);
        this.drawTitle();
        this.textList.renderGuiBackground(mouseX, mouseY);
    }

    protected void func_73864_a(int i, int j, int k) throws IOException {
        this.textList.mouseClicked(i, j, k);
        super.func_73864_a(i, j, k);
    }

    @Override
    public void handleMouseInputSub() throws IOException {
        int wheel = Mouse.getDWheel() / 120;
        if (wheel == 0) {
            super.handleMouseInputSub();
        }
        if (wheel < 0) {
            this.textList.scrollUp();
        } else if (wheel > 0) {
            this.textList.scrollDown();
        }
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        if (guibutton.field_146127_k == 0) {
            int selected = this.textList.getSelected();
            if (selected >= 0) {
                this.handleResult.accept(this.pipeList.get(selected).getValue2());
                this.exitGui();
            }
        } else if (guibutton.field_146127_k == 1) {
            this.exitGui();
        } else if (guibutton.field_146127_k == 2) {
            this.handleResult.accept(null);
            this.exitGui();
        } else if (guibutton.field_146127_k == 4) {
            this.textList.scrollDown();
        } else if (guibutton.field_146127_k == 5) {
            this.textList.scrollUp();
        } else {
            super.func_146284_a(guibutton);
        }
    }

    public void handleSatelliteList(List<Pair<String, UUID>> list) {
        this.pipeList = list;
    }
}

