/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import logisticspipes.blocks.stats.LogisticsStatisticsTileEntity;
import logisticspipes.blocks.stats.TrackingTask;
import logisticspipes.gui.popup.GuiAddTracking;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.block.RemoveAmoundTask;
import logisticspipes.network.packets.block.RequestAmountTaskSubGui;
import logisticspipes.network.packets.block.RequestRunningCraftingTasks;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.Color;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.ItemDisplay;
import logisticspipes.utils.gui.LogisticsBaseGuiScreen;
import logisticspipes.utils.gui.SmallGuiButton;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.math.Vec2;
import logisticspipes.utils.string.StringUtils;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import network.rs485.logisticspipes.util.TextUtil;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiStatistics
extends LogisticsBaseGuiScreen {
    private final String PREFIX = "gui.networkstatistics.";
    private int currentTab;
    private final TabTracker tabTracker = new TabTracker();
    private final TabCrafting tabCrafting = new TabCrafting();
    private final List<StatisticsTab> tabs = Arrays.asList(this.tabTracker, this.tabCrafting);
    private final LogisticsStatisticsTileEntity tile;
    private int prevMouseDragX;
    private int prevMouseDragY;

    public GuiStatistics(LogisticsStatisticsTileEntity tile) {
        super(180, 220, 0, 0);
        this.tile = tile;
    }

    @Override
    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.tabs.forEach(StatisticsTab::init);
        this.tabTracker.updateItemList();
    }

    @Override
    public void closeGui() throws IOException {
        super.closeGui();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    public void resetSubGui() {
        super.resetSubGui();
        this.tabTracker.updateItemList();
    }

    private StatisticsTab getActiveTab() {
        return this.tabs.get(this.currentTab);
    }

    protected void func_146284_a(GuiButton button) {
        this.getActiveTab().actionPerformed(button);
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        this.getActiveTab().onMouseDrag(mouseX, mouseY, mouseX - this.prevMouseDragX, mouseY - this.prevMouseDragY);
        this.prevMouseDragX = mouseX;
        this.prevMouseDragY = mouseY;
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    @Override
    protected void func_146976_a(float f, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBG();
        this.getActiveTab().draw(mouseX, mouseY);
        super.func_146976_a(f, mouseX, mouseY);
    }

    private void drawBG() {
        GuiGraphics.drawGuiBackGround(this.field_146297_k, this.field_147003_i, this.field_147009_r + 20, this.right, this.bottom, this.field_73735_i, true);
        GuiGraphics.drawGuiBackGround(this.field_146297_k, this.field_147003_i + 25 * this.currentTab + 2, this.field_147009_r - 2, this.field_147003_i + 27 + 25 * this.currentTab, this.field_147009_r + 38, this.field_73735_i, true, true, true, false, true);
        for (int i = 0; i < this.tabs.size(); ++i) {
            GuiGraphics.drawGuiBackGround(this.field_146297_k, this.field_147003_i + 25 * i + 2, this.field_147009_r - 2, this.field_147003_i + 27 + 25 * i, this.field_147009_r + 35, this.field_73735_i, false, true, true, false, true);
        }
        GuiGraphics.drawStatsBackground(this.field_146297_k, this.field_147003_i + 6, this.field_147009_r + 3);
        RenderHelper.func_74520_c();
        ItemStack stack = new ItemStack(Blocks.field_150462_ai, 1);
        GlStateManager.func_179126_j();
        this.field_146296_j.func_180450_b(stack, this.field_147003_i + 31, this.field_147009_r + 3);
        GlStateManager.func_179097_i();
        this.field_146296_j.field_77023_b = 0.0f;
    }

    protected void func_73869_a(char c, int i) throws IOException {
        super.func_73869_a(c, i);
        this.getActiveTab().keyTyped(c, i);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.prevMouseDragX = mouseX;
        this.prevMouseDragY = mouseY;
        if (mouseButton == 0 && mouseX > this.field_147003_i && mouseX < this.field_147003_i + 220 && mouseY > this.field_147009_r && mouseY < this.field_147009_r + 20) {
            this.currentTab = Math.max(0, Math.min((mouseX -= this.field_147003_i + 3) / 25, this.tabs.size() - 1));
        } else {
            this.getActiveTab().handleClick(mouseX, mouseY, mouseButton);
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.getActiveTab().drawForegroundLayer(mouseX, mouseY);
    }

    @Override
    protected void checkButtons() {
        super.checkButtons();
        this.tabs.forEach(StatisticsTab::checkButtons);
    }

    @Override
    public void handleMouseInputSub() throws IOException {
        this.getActiveTab().onMouseScroll(Mouse.getEventDWheel());
        super.handleMouseInputSub();
    }

    public void handlePacket1(List<ItemIdentifierStack> identList) {
        this.tabTracker.handlePacket(identList);
    }

    public void handlePacket2(List<ItemIdentifierStack> identList) {
        this.tabCrafting.handlePacket(identList);
    }

    private class TabCrafting
    implements StatisticsTab {
        private ItemDisplay itemDisplay;
        private final List<GuiButton> BUTTONS = new ArrayList<GuiButton>();

        private TabCrafting() {
        }

        @Override
        public void init() {
            this.BUTTONS.add(GuiStatistics.this.func_189646_b(new GuiButton(6, GuiStatistics.this.field_147003_i + 10, GuiStatistics.this.field_147009_r + 40, 160, 20, TextUtil.translate("gui.networkstatistics.gettasks", new String[0]))));
            this.BUTTONS.add(GuiStatistics.this.func_189646_b(new SmallGuiButton(7, GuiStatistics.this.field_147003_i + 90, GuiStatistics.this.field_147009_r + 65, 10, 10, "<")));
            this.BUTTONS.add(GuiStatistics.this.func_189646_b(new SmallGuiButton(8, GuiStatistics.this.field_147003_i + 160, GuiStatistics.this.field_147009_r + 65, 10, 10, ">")));
            if (this.itemDisplay == null) {
                this.itemDisplay = new ItemDisplay(null, GuiStatistics.this.field_146289_q, GuiStatistics.this, null, GuiStatistics.this.field_147003_i + 10, GuiStatistics.this.field_147009_r + 18, GuiStatistics.this.field_146999_f - 20, GuiStatistics.this.field_147000_g - 100, 0, 0, 0, new int[]{1, 10, 64, 64}, true);
                this.itemDisplay.setItemList(new ArrayList<ItemIdentifierStack>());
            }
            this.itemDisplay.reposition(GuiStatistics.this.field_147003_i + 10, GuiStatistics.this.field_147009_r + 80, GuiStatistics.this.field_146999_f - 20, 125, 0, 0);
        }

        @Override
        public void draw(int mouseX, int mouseY) {
            this.itemDisplay.renderItemArea(GuiStatistics.this.field_73735_i);
            this.itemDisplay.renderPageNumber(GuiStatistics.this.right - 50, GuiStatistics.this.field_147009_r + 66);
        }

        @Override
        public void drawForegroundLayer(int mouseX, int mouseY) {
            GuiStatistics.this.field_146297_k.field_71466_p.func_175065_a(TextUtil.translate("gui.networkstatistics.crafting", new String[0]), 10.0f, 28.0f, Color.getValue(Color.DARKER_GREY), false);
            GuiGraphics.displayItemToolTip(this.itemDisplay.getToolTip(), (Gui)GuiStatistics.this, GuiStatistics.this.field_73735_i, GuiStatistics.this.field_147003_i, GuiStatistics.this.field_147009_r);
        }

        @Override
        public void actionPerformed(GuiButton button) {
            if (button.field_146127_k == 6) {
                MainProxy.sendPacketToServer(PacketHandler.getPacket(RequestRunningCraftingTasks.class).setTilePos(GuiStatistics.this.tile));
            } else if (button.field_146127_k == 7) {
                this.itemDisplay.prevPage();
            } else if (button.field_146127_k == 8) {
                this.itemDisplay.prevPage();
            }
        }

        @Override
        public void keyTyped(char c, int i) {
            if (i == 201) {
                this.itemDisplay.prevPage();
            } else if (i == 209) {
                this.itemDisplay.nextPage();
            }
        }

        @Override
        public void handleClick(int mouseX, int mouseY, int mouseButton) {
            this.itemDisplay.handleClick(mouseX, mouseY, mouseButton);
        }

        @Override
        public void checkButtons() {
            for (GuiButton button : this.BUTTONS) {
                button.field_146125_m = GuiStatistics.this.getActiveTab() == this;
            }
        }

        public void handlePacket(List<ItemIdentifierStack> identList) {
            this.itemDisplay.setItemList(identList);
        }
    }

    private class TabTracker
    implements StatisticsTab {
        private ItemDisplay itemDisplay;
        private float xViewportOffset = -1434.0f;
        private float yViewportOffset;
        private float xViewportScale = 15.0f;
        private float yViewportScale = 15.0f;
        private boolean isDraggingGraph = false;
        private boolean isDraggingXBar = false;
        private boolean isDraggingYBar = false;
        private final List<GuiButton> BUTTONS = new ArrayList<GuiButton>();

        private TabTracker() {
        }

        @Override
        public void init() {
            this.BUTTONS.add(GuiStatistics.this.func_189646_b(new GuiButton(0, GuiStatistics.this.field_147003_i + 10, GuiStatistics.this.field_147009_r + 70, 20, 20, "<")));
            this.BUTTONS.add(GuiStatistics.this.func_189646_b(new GuiButton(1, GuiStatistics.this.field_147003_i + 150, GuiStatistics.this.field_147009_r + 70, 20, 20, ">")));
            this.BUTTONS.add(GuiStatistics.this.func_189646_b(new GuiButton(2, GuiStatistics.this.field_147003_i + 37, GuiStatistics.this.field_147009_r + 70, 40, 20, "Add")));
            this.BUTTONS.add(GuiStatistics.this.func_189646_b(new GuiButton(3, GuiStatistics.this.field_147003_i + 83, GuiStatistics.this.field_147009_r + 70, 60, 20, "Remove")));
            if (this.itemDisplay == null) {
                this.itemDisplay = new ItemDisplay(null, GuiStatistics.this.field_146289_q, GuiStatistics.this, null, GuiStatistics.this.field_147003_i + 10, GuiStatistics.this.field_147009_r + 18, GuiStatistics.this.field_146999_f - 20, GuiStatistics.this.field_147000_g - 100, 0, 0, 0, new int[]{1, 10, 64, 64}, true);
            }
            this.itemDisplay.reposition(GuiStatistics.this.field_147003_i + 10, GuiStatistics.this.field_147009_r + 40, GuiStatistics.this.field_146999_f - 20, 20, 0, 0);
        }

        @Override
        public void draw(int mouseX, int mouseY) {
            this.itemDisplay.renderItemArea(GuiStatistics.this.field_73735_i);
            this.itemDisplay.renderPageNumber(GuiStatistics.this.right - 40, GuiStatistics.this.field_147009_r + 28);
            if (this.itemDisplay.getSelectedItem() != null) {
                TrackingTask task = this.getSelectedTask();
                if (task != null) {
                    GuiGraphics.drawSlotBackground(GuiStatistics.this.field_146297_k, GuiStatistics.this.field_147003_i + 10, GuiStatistics.this.field_147009_r + 99);
                    RenderHelper.func_74520_c();
                    GlStateManager.func_179126_j();
                    GuiStatistics.this.field_146296_j.func_180450_b(task.item.makeNormalStack(1), GuiStatistics.this.field_147003_i + 11, GuiStatistics.this.field_147009_r + 100);
                    GlStateManager.func_179097_i();
                    ((GuiStatistics)GuiStatistics.this).field_146296_j.field_77023_b = 0.0f;
                    GuiStatistics.this.field_146297_k.field_71466_p.func_175065_a(StringUtils.getWithMaxWidth(task.item.getFriendlyName(), 136, GuiStatistics.this.field_146289_q), (float)(GuiStatistics.this.field_147003_i + 32), (float)(GuiStatistics.this.field_147009_r + 104), Color.getValue(Color.DARKER_GREY), false);
                    int xOrigo = GuiStatistics.this.xCenter - 72;
                    int yOrigo = GuiStatistics.this.yCenter + 90;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)xOrigo, (float)yOrigo, (float)0.0f);
                    GuiStatistics.this.drawLine(0, 0, 150, 0, Color.DARKER_GREY);
                    GuiStatistics.this.drawLine(0, 0, 0, -80, Color.DARKER_GREY);
                    GuiStatistics.this.drawLine(-4, -80, 0, -80, Color.DARKER_GREY);
                    GuiStatistics.this.drawLine(150, -1, 150, 4, Color.DARKER_GREY);
                    long[] data = this.getTaskData(task);
                    float xViewportCenter = 75.0f;
                    float yViewportCenter = 40.0f;
                    int rightLimit = 2;
                    for (int i = 0; i < data.length && --rightLimit != 0; ++i) {
                        int interval;
                        float x = i;
                        float y = data[i];
                        float prevX = x;
                        float prevY = y;
                        if (i > 0) {
                            prevX = x - 1.0f;
                            prevY = data[i - 1];
                        }
                        x += this.xViewportOffset;
                        x *= this.xViewportScale;
                        x += xViewportCenter;
                        prevX += this.xViewportOffset;
                        prevX *= this.xViewportScale;
                        prevX += xViewportCenter;
                        y -= this.yViewportOffset;
                        y *= this.yViewportScale;
                        y += yViewportCenter;
                        prevY -= this.yViewportOffset;
                        prevY *= this.yViewportScale;
                        prevY += yViewportCenter;
                        if (x <= 150.0f) {
                            rightLimit = 2;
                        }
                        if (x < 0.0f) continue;
                        if (x <= 150.0f && i % (interval = Math.max(1, (int)(40.0f / this.xViewportScale) + 1)) == 0) {
                            String s = this.formatTime(data.length - i - 1);
                            int w = GuiStatistics.this.field_146297_k.field_71466_p.func_78256_a(s);
                            GuiStatistics.this.drawLine((int)x, -1, (int)x, 4, Color.DARKER_GREY);
                            GuiStatistics.this.field_146297_k.field_71466_p.func_175065_a(s, (float)((int)x) - (float)w / 2.0f, 6.0f, Color.DARKER_GREY.getValue(), false);
                        }
                        if (y > 0.0f && y < 80.0f) {
                            GuiStatistics.this.drawLine(-4, (int)(-y), 0, (int)(-y), Color.DARKER_GREY);
                            GlStateManager.func_179094_E();
                            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                            String s = data[i] + "";
                            int w = GuiStatistics.this.field_146297_k.field_71466_p.func_78256_a(s);
                            GuiStatistics.this.field_146297_k.field_71466_p.func_175065_a(s, (float)((int)(-y)) - (float)w / 2.0f, 6.0f, Color.DARKER_GREY.getValue(), false);
                            GlStateManager.func_179121_F();
                        }
                        this.drawGraphPart((int)prevX, (int)prevY, (int)x, (int)y);
                    }
                }
                GlStateManager.func_179121_F();
            }
        }

        @Nullable
        private TrackingTask getSelectedTask() {
            for (TrackingTask taskLoop : ((GuiStatistics)GuiStatistics.this).tile.tasks) {
                if (taskLoop.item != this.itemDisplay.getSelectedItem().getItem()) continue;
                return taskLoop;
            }
            return null;
        }

        private long[] getTaskData(TrackingTask task) {
            long[] data = new long[task.amountRecorded.length];
            System.arraycopy(task.amountRecorded, task.arrayPos, data, 0, task.amountRecorded.length - task.arrayPos);
            System.arraycopy(task.amountRecorded, 0, data, task.amountRecorded.length - task.arrayPos, task.arrayPos);
            return data;
        }

        @Override
        public void drawForegroundLayer(int mouseX, int mouseY) {
            GuiStatistics.this.field_146297_k.field_71466_p.func_175065_a(TextUtil.translate("gui.networkstatistics.amount", new String[0]), 10.0f, 28.0f, Color.getValue(Color.DARKER_GREY), false);
        }

        @Override
        public void actionPerformed(GuiButton button) {
            if (button.field_146127_k == 0) {
                this.itemDisplay.prevPage();
            } else if (button.field_146127_k == 1) {
                this.itemDisplay.prevPage();
            } else if (button.field_146127_k == 2) {
                MainProxy.sendPacketToServer(PacketHandler.getPacket(RequestAmountTaskSubGui.class).setTilePos(GuiStatistics.this.tile));
            } else if (button.field_146127_k == 3 && this.itemDisplay.getSelectedItem() != null) {
                MainProxy.sendPacketToServer(PacketHandler.getPacket(RemoveAmoundTask.class).setItem(this.itemDisplay.getSelectedItem().getItem()).setTilePos(GuiStatistics.this.tile));
                Iterator<TrackingTask> iter = ((GuiStatistics)GuiStatistics.this).tile.tasks.iterator();
                while (iter.hasNext()) {
                    TrackingTask task = iter.next();
                    if (task.item != this.itemDisplay.getSelectedItem().getItem()) continue;
                    iter.remove();
                    break;
                }
                this.updateItemList();
            }
        }

        @Override
        public void keyTyped(char c, int i) {
            if (i == 201) {
                this.itemDisplay.prevPage();
            } else if (i == 209) {
                this.itemDisplay.nextPage();
            }
        }

        @Override
        public void handleClick(int mouseX, int mouseY, int mouseButton) {
            if (this.itemDisplay.handleClick(mouseX, mouseY, mouseButton)) {
                this.xViewportOffset = Math.max(-1439.0f, Math.min(this.xViewportOffset, 0.0f));
                TrackingTask task = this.getSelectedTask();
                if (task != null) {
                    long[] data = this.getTaskData(task);
                    this.yViewportOffset = data[Math.round(-this.xViewportOffset)];
                }
            }
            int xOrigo = GuiStatistics.this.xCenter - 72;
            int yOrigo = GuiStatistics.this.yCenter + 90;
            this.isDraggingGraph = mouseButton == 0 && mouseX > xOrigo && mouseX < xOrigo + 150 && mouseY < yOrigo && mouseY > yOrigo - 80;
            this.isDraggingXBar = mouseButton == 0 && mouseX > xOrigo && mouseX < xOrigo + 150 && mouseY < yOrigo + 16 && mouseY > yOrigo + 4;
            this.isDraggingYBar = mouseButton == 0 && mouseX > xOrigo - 16 && mouseX < xOrigo - 4 && mouseY < yOrigo && mouseY > yOrigo - 80;
        }

        @Override
        public void checkButtons() {
            for (GuiButton button : this.BUTTONS) {
                boolean bl = button.field_146125_m = GuiStatistics.this.getActiveTab() == this;
                if (!button.field_146126_j.equals("Remove")) continue;
                button.field_146124_l = this.itemDisplay.getSelectedItem() != null;
            }
        }

        @Override
        public void onMouseDrag(int x, int y, int dx, int dy) {
            if (this.isDraggingGraph) {
                this.xViewportOffset += (float)dx / this.xViewportScale;
                this.yViewportOffset += (float)dy / this.yViewportScale;
            } else if (this.isDraggingXBar) {
                float mul = (float)Math.pow(1.25, (float)dx / 2.0f);
                this.xViewportScale *= mul;
            } else if (this.isDraggingYBar) {
                float mul = (float)Math.pow(1.25, (float)(-dy) / 2.0f);
                this.yViewportScale *= mul;
            }
        }

        @Override
        public void onMouseScroll(int dw) {
            float mul = (float)Math.pow(1.25, (float)dw / 60.0f);
            this.xViewportScale *= mul;
            this.yViewportScale *= mul;
        }

        private void drawGraphPart(int prevX, int prevY, int x, int y) {
            Vec2 left = new Vec2(prevX, prevY);
            Vec2 right = new Vec2(x, y);
            Vec2 min = new Vec2(left.x, Math.min(left.y, right.y));
            Vec2 max = new Vec2(right.x, Math.max(left.y, right.y));
            if (!(min.x < 150.0f && max.x > 0.0f && min.y < 80.0f && max.y > 0.0f)) {
                return;
            }
            right = this.clampCorner(left, right, Vec2.ORIGIN, true);
            right = this.clampCorner(left, right, new Vec2(150.0f, 80.0f), false);
            left = this.clampCorner(right, left, Vec2.ORIGIN, true);
            left = this.clampCorner(right, left, new Vec2(150.0f, 80.0f), false);
            GuiStatistics.this.drawLine((int)left.x, (int)(-left.y), (int)right.x, (int)(-right.y), Color.RED);
            int radius = 2;
            if (this.xViewportScale < 4.0f) {
                radius = 1;
            }
            if (prevX >= 0 && prevX <= 150 && prevY >= 0 && prevY <= 80) {
                GuiStatistics.this.drawRect(prevX - radius + 1, -prevY - radius + 1, prevX + radius, -prevY + radius, Color.BLACK);
            }
            if (x >= 0 && x <= 150 && y >= 0 && y <= 80) {
                GuiStatistics.this.drawRect(x - radius + 1, -y - radius + 1, x + radius, -y + radius, Color.BLACK);
            }
        }

        private Vec2 clampYPlane(Vec2 v, Vec2 toClamp, float x0, boolean greater) {
            if (toClamp.x == x0) {
                return toClamp;
            }
            if (toClamp.x == v.x) {
                return toClamp;
            }
            if (!greater && toClamp.x < x0 || greater && toClamp.x > x0) {
                return toClamp;
            }
            Vec2 dir = toClamp.sub(v);
            dir = dir.div(dir.x);
            float dist = x0 - toClamp.x;
            return toClamp.add(dir.mul(dist));
        }

        private Vec2 clampXPlane(Vec2 from, Vec2 to, float y0, boolean greater) {
            Vec2 vec2 = this.clampYPlane(new Vec2(from.y, from.x), new Vec2(to.y, to.x), y0, greater);
            return new Vec2(vec2.y, vec2.x);
        }

        private Vec2 clampCorner(Vec2 from, Vec2 to, Vec2 corner, boolean greater) {
            return this.clampXPlane(from, this.clampYPlane(from, to, corner.x, greater), corner.y, greater);
        }

        private String formatTime(int minutes) {
            if (minutes == 0) {
                return "Now";
            }
            int mins = minutes % 60;
            int hours = minutes /= 60;
            StringBuilder sb = new StringBuilder();
            if (hours > 0) {
                sb.append(hours).append("h");
            }
            if (mins > 0) {
                sb.append(mins).append("min");
            }
            return sb.toString();
        }

        public void updateItemList() {
            List<ItemIdentifierStack> allItems = ((GuiStatistics)GuiStatistics.this).tile.tasks.stream().map(task -> task.item.makeStack(1)).collect(Collectors.toList());
            this.itemDisplay.setItemList(allItems);
        }

        public void handlePacket(List<ItemIdentifierStack> identList) {
            if (GuiStatistics.this.hasSubGui() && GuiStatistics.this.getSubGui() instanceof GuiAddTracking) {
                ((GuiAddTracking)GuiStatistics.this.getSubGui()).handlePacket(identList);
            } else if (!GuiStatistics.this.hasSubGui()) {
                GuiAddTracking sub = new GuiAddTracking(GuiStatistics.this.tile);
                GuiStatistics.this.setSubGui(sub);
                sub.handlePacket(identList);
            }
        }
    }

    private static interface StatisticsTab {
        public void init();

        public void draw(int var1, int var2);

        default public void drawForegroundLayer(int mouseX, int mouseY) {
        }

        default public void checkButtons() {
        }

        default public void actionPerformed(GuiButton button) {
        }

        default public void keyTyped(char c, int i) {
        }

        default public void handleClick(int mouseX, int mouseY, int mouseButton) {
        }

        default public void onMouseDrag(int x, int y, int dx, int dy) {
        }

        default public void onMouseScroll(int dw) {
        }
    }
}

