/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.commands.chathelper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import logisticspipes.LogisticsPipes;
import logisticspipes.asm.ClientSideOnlyMethodContent;
import logisticspipes.commands.chathelper.MorePageDisplay;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.gui.OpenChatGui;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.string.ChatColor;
import logisticspipes.utils.string.StringUtils;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class LPChatListener {
    private static final Map<String, Callable<Boolean>> tasks = new HashMap<String, Callable<Boolean>>();
    private static final Map<String, MorePageDisplay> morePageDisplays = new HashMap<String, MorePageDisplay>();
    private List<String> sendChatMessages = null;

    @SubscribeEvent
    public void serverChat(ServerChatEvent event) {
        EntityPlayerMP player = event.getPlayer();
        if (tasks.containsKey(event.getUsername())) {
            if (event.getMessage().startsWith("/")) {
                player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)ChatColor.RED) + "You need to answer the question, before you can use any other command"));
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OpenChatGui.class), (EntityPlayer)player);
            } else if (!(event.getMessage().equalsIgnoreCase("true") || event.getMessage().equalsIgnoreCase("false") || event.getMessage().equalsIgnoreCase("on") || event.getMessage().equalsIgnoreCase("off") || event.getMessage().equalsIgnoreCase("0") || event.getMessage().equalsIgnoreCase("1") || event.getMessage().equalsIgnoreCase("no") || event.getMessage().equalsIgnoreCase("yes"))) {
                player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)ChatColor.RED) + "Not a valid answer."));
                player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)ChatColor.AQUA) + "Please enter " + (Object)((Object)ChatColor.RESET) + "<" + (Object)((Object)ChatColor.GREEN) + "yes" + (Object)((Object)ChatColor.RESET) + "/" + (Object)((Object)ChatColor.RED) + "no " + (Object)((Object)ChatColor.RESET) + "| " + (Object)((Object)ChatColor.GREEN) + "true" + (Object)((Object)ChatColor.RESET) + "/" + (Object)((Object)ChatColor.RED) + "flase " + (Object)((Object)ChatColor.RESET) + "| " + (Object)((Object)ChatColor.GREEN) + "on" + (Object)((Object)ChatColor.RESET) + "/" + (Object)((Object)ChatColor.RED) + "off " + (Object)((Object)ChatColor.RESET) + "| " + (Object)((Object)ChatColor.GREEN) + "1" + (Object)((Object)ChatColor.RESET) + "/" + (Object)((Object)ChatColor.RED) + "0" + (Object)((Object)ChatColor.RESET) + ">"));
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OpenChatGui.class), (EntityPlayer)player);
            } else {
                boolean flag;
                boolean bl = flag = event.getMessage().equalsIgnoreCase("true") || event.getMessage().equalsIgnoreCase("on") || event.getMessage().equalsIgnoreCase("1") || event.getMessage().equalsIgnoreCase("yes");
                if (!this.handleAnswer(flag, (ICommandSender)player)) {
                    player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)ChatColor.RED) + "Error: Could not handle answer."));
                }
            }
            event.setCanceled(true);
        } else if (morePageDisplays.containsKey(event.getUsername()) && !morePageDisplays.get(event.getUsername()).isTerminated()) {
            if (event.getMessage().startsWith("/")) {
                player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)ChatColor.RED) + "Exit " + (Object)((Object)ChatColor.AQUA) + "PageView" + (Object)((Object)ChatColor.RED) + " first!"));
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OpenChatGui.class), (EntityPlayer)player);
                event.setCanceled(true);
            } else if (morePageDisplays.get(event.getUsername()).handleChat(event.getMessage(), (ICommandSender)player)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void clientChat(ClientChatReceivedEvent event) {
        ITextComponent message = event.getMessage();
        if (message != null) {
            String realMessage = null;
            try {
                realMessage = message.func_150254_d();
            }
            catch (ClassCastException classCastException) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (realMessage != null) {
                if (realMessage.equals("%LPCLEARCHAT%")) {
                    this.clearChat();
                    event.setCanceled(true);
                }
                if (realMessage.equals("%LPSTORESENDMESSAGE%")) {
                    this.storeSendMessages();
                    event.setCanceled(true);
                }
                if (realMessage.equals("%LPRESTORESENDMESSAGE%")) {
                    this.restoreSendMessages();
                    event.setCanceled(true);
                }
                if (realMessage.startsWith("%LPADDTOSENDMESSAGE%")) {
                    this.addSendMessages(realMessage.substring(20));
                    event.setCanceled(true);
                }
                if (realMessage.contains("LPDISPLAYMISSING") && LogisticsPipes.isDEBUG()) {
                    System.out.println("LIST:");
                    StringUtils.UNTRANSLATED_STRINGS.forEach(System.out::println);
                }
            }
        }
    }

    @ClientSideOnlyMethodContent
    private void clearChat() {
        FMLClientHandler.instance().getClient().field_71456_v.func_146158_b().func_146231_a(true);
    }

    @ClientSideOnlyMethodContent
    private void storeSendMessages() {
        this.sendChatMessages = new ArrayList<String>();
        this.sendChatMessages.addAll(FMLClientHandler.instance().getClient().field_71456_v.func_146158_b().func_146238_c());
    }

    @ClientSideOnlyMethodContent
    private void restoreSendMessages() {
        if (this.sendChatMessages != null) {
            for (String o : this.sendChatMessages) {
                FMLClientHandler.instance().getClient().field_71456_v.func_146158_b().func_146239_a(o);
            }
            this.sendChatMessages = null;
        }
    }

    @ClientSideOnlyMethodContent
    private void addSendMessages(String substring) {
        if (this.sendChatMessages != null) {
            this.sendChatMessages.add(substring);
        } else {
            FMLClientHandler.instance().getClient().field_71456_v.func_146158_b().func_146239_a(substring);
        }
    }

    public static void register(MorePageDisplay displayInput, String name) {
        if (morePageDisplays.containsKey(name) && !morePageDisplays.get(name).isTerminated()) {
            return;
        }
        morePageDisplays.put(name, displayInput);
    }

    public static void remove(String name) {
        morePageDisplays.remove(name);
    }

    public boolean handleAnswer(boolean flag, ICommandSender sender) {
        block5: {
            if (!tasks.containsKey(sender.func_70005_c_())) {
                return false;
            }
            if (flag) {
                try {
                    Boolean result2 = tasks.get(sender.func_70005_c_()).call();
                    if (result2 != null && result2 != null && !result2.booleanValue()) {
                        return false;
                    }
                    break block5;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            sender.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)ChatColor.GREEN) + "Answer handled."));
        }
        tasks.remove(sender.func_70005_c_());
        return true;
    }

    public static boolean existTaskFor(String name) {
        return tasks.containsKey(name);
    }

    public static void removeTask(String name) {
        tasks.remove(name);
    }

    public static boolean addTask(Callable<Boolean> input, ICommandSender sender) {
        if (tasks.containsKey(sender.func_70005_c_())) {
            return false;
        }
        tasks.put(sender.func_70005_c_(), input);
        return true;
    }
}

