/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.mffs.common;

import com.google.common.collect.Lists;
import com.nekokittygames.mffs.common.CommonProxy;
import com.nekokittygames.mffs.common.MFFSCreativeTab;
import com.nekokittygames.mffs.common.MFFSMaschines;
import com.nekokittygames.mffs.common.MFFSRecipes;
import com.nekokittygames.mffs.common.MFFSWorldGenerator;
import com.nekokittygames.mffs.common.ProjectorOptions;
import com.nekokittygames.mffs.common.ProjectorTyp;
import com.nekokittygames.mffs.common.Versioninfo;
import com.nekokittygames.mffs.common.block.ModBlocks;
import com.nekokittygames.mffs.common.item.ModItems;
import com.nekokittygames.mffs.common.tileentity.TileEntityControlSystem;
import com.nekokittygames.mffs.common.tileentity.TileEntityMachines;
import com.nekokittygames.mffs.network.PacketTileHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Logger;

@Mod(modid="modularforcefieldsystem", name="Modular ForceField System", version="4.0.1.5", dependencies="after:enderio;after:ic2", acceptedMinecraftVersions="[1.12.2]")
public class ModularForceFieldSystem {
    public static final String MODID = "modularforcefieldsystem";
    public static CreativeTabs MFFSTab;
    public static int MFFSRENDER_ID;
    public static SimpleNetworkWrapper networkWrapper;
    public static int MonazitOreworldamount;
    public static int MonazitOreSmeltAmount;
    public static int forceFieldBlockCost;
    public static int forceFieldBlockCreateModifier;
    public static int forceFieldBlockZapperModifier;
    public static int forceFieldTransportCost;
    public static int forceFieldMaxBlocksPerTick;
    public static boolean forceFieldRemoveOnlyWaterAndLava;
    public static boolean influencedByOtherMods;
    public static boolean adventureMapMode;
    public static boolean ic2Found;
    public static boolean ee3Found;
    public static boolean buildcraftFound;
    public static boolean thermalExpansionFound;
    public static boolean enderIoFound;
    public static boolean computercraftFound;
    public static boolean appliedEnergisticsFound;
    public static boolean enableIC2Recipes;
    public static boolean enableTERecipes;
    public static boolean enableAEGrindStoneRecipe;
    public static int grindRecipeOutput;
    public static int grindRecipeCost;
    public static int graphicsStyle;
    public static boolean showZapperParticles;
    public static boolean enableUUMatterForcicium;
    public static boolean enableChunkLoader;
    public static int ForciciumWorkCycle;
    public static int ForciciumCellWorkCycle;
    public static int ExtractorPassForceEnergyGenerate;
    public static int DefenceStationKillForceEnergy;
    public static int DefenceStationSearchForceEnergy;
    public static int DefenceStationScannForceEnergy;
    public static boolean DefenceStationNPCScannsuppressnotification;
    public static Configuration MFFSconfig;
    public static String Admin;
    public static String VersionLocal;
    public static String VersionRemote;
    public static String VersionRemoteURL;
    @SidedProxy(clientSide="com.nekokittygames.mffs.client.ClientProxy", serverSide="com.nekokittygames.mffs.common.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="modularforcefieldsystem")
    public static ModularForceFieldSystem instance;
    public static boolean enableEIRecipes;
    public static Logger log;
    private static int packetId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) throws Exception {
        log = event.getModLog();
        this.initIC2Plugin();
        this.initBuildcraftPlugin();
        this.initEE3Plugin();
        this.initThermalExpansionPlugin();
        this.initEnderIoPlugin();
        this.initComputerCraftPlugin();
        this.initAEPlugin();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("MFFS");
        networkWrapper.registerMessage(PacketTileHandler.class, PacketTileHandler.class, this.nextID(), Side.SERVER);
        MFFSconfig = new Configuration(event.getSuggestedConfigurationFile());
        event.getModMetadata().version = Versioninfo.curentversion();
        try {
            MFFSconfig.load();
            MFFSTab = new MFFSCreativeTab(CreativeTabs.getNextID(), "MFFS");
            Property prop_VersionremoteUrl = MFFSconfig.get("general", "VersionremoteUrl", "https://bitbucket.org/SeargeDP/modularforcefieldsystem/downloads/versioninfo");
            prop_VersionremoteUrl.setComment("URL to MFFS VersionInfo file");
            VersionRemoteURL = prop_VersionremoteUrl.getString();
            Property chunckloader_prop = MFFSconfig.get("general", "Chunkloader", true);
            chunckloader_prop.setComment("Set this to false to turn off the MFFS Chuncloader ability");
            enableChunkLoader = chunckloader_prop.getBoolean(true);
            Property DefSationNPCScannoti = MFFSconfig.get("general", "DefenceStationNPCScannnotification", false);
            DefSationNPCScannoti.setComment("Set this to true to turn off the DefenceStation notification is in NPC Mode");
            DefenceStationNPCScannsuppressnotification = DefSationNPCScannoti.getBoolean(false);
            Property zapperParticles = MFFSconfig.get("general", "renderZapperParticles", true);
            zapperParticles.setComment("Set this to false to turn off the small smoke particles present around TouchDamage enabled ForceFields.");
            showZapperParticles = zapperParticles.getBoolean(true);
            Property uumatterForciciumprop = MFFSconfig.get("general", "uumatterForcicium", true);
            uumatterForciciumprop.setComment("Add IC2 UU-Matter Recipes for Forcicium");
            enableUUMatterForcicium = uumatterForciciumprop.getBoolean(true);
            Property monazitWorldAmount = MFFSconfig.get("general", "MonazitOreWorldGen", 4);
            monazitWorldAmount.setComment("Controls the size of the ore node that Monazit Ore will generate in");
            MonazitOreworldamount = monazitWorldAmount.getInt(4);
            Property adminList = MFFSconfig.get("general", "ForceFieldMaster", "nobody");
            adminList.setComment("Add users uuids to this list to give them admin permissions split by ;");
            Admin = adminList.getString();
            Property influencedByOther = MFFSconfig.get("general", "influencedbyothermods", true);
            influencedByOther.setComment("Should MFFS be influenced by other mods. e.g. ICBM's EMP");
            influencedByOtherMods = influencedByOther.getBoolean(true);
            Property ffRemoveWaterLavaOnly = MFFSconfig.get("general", "forcefieldremoveonlywaterandlava", false);
            ffRemoveWaterLavaOnly.setComment("Should forcefields only remove water and lava when sponge is enabled?");
            forceFieldRemoveOnlyWaterAndLava = ffRemoveWaterLavaOnly.getBoolean(false);
            Property feTransportCost = MFFSconfig.get("general", "forcefieldtransportcost", 10000);
            feTransportCost.setComment("How much FE should it cost to transport through a field?");
            forceFieldTransportCost = feTransportCost.getInt(10000);
            Property feFieldBlockCost = MFFSconfig.get("general", "forcefieldblockcost", 1);
            feFieldBlockCost.setComment("How much upkeep FE cost a default ForceFieldblock per second");
            forceFieldBlockCost = feFieldBlockCost.getInt(1);
            Property BlockCreateMod = MFFSconfig.get("general", "forcefieldblockcreatemodifier", 10);
            BlockCreateMod.setComment("Energy need for create a ForceFieldblock (forcefieldblockcost*forcefieldblockcreatemodifier)");
            forceFieldBlockCreateModifier = BlockCreateMod.getInt(10);
            Property ffZapperMod = MFFSconfig.get("general", "forcefieldblockzappermodifier", 2);
            ffZapperMod.setComment("Energy need multiplier used when the zapper option is installed");
            forceFieldBlockZapperModifier = ffZapperMod.getInt(2);
            Property maxFFGenPerTick = MFFSconfig.get("general", "forcefieldmaxblockpeerTick", 5000);
            maxFFGenPerTick.setComment("How many field blocks can be generated per tick?");
            forceFieldMaxBlocksPerTick = maxFFGenPerTick.getInt(5000);
            Property fcWorkCycle = MFFSconfig.get("general", "ForceciumWorkCylce", 250);
            fcWorkCycle.setComment("WorkCycle amount of Forcecium inside a Extractor");
            ForciciumWorkCycle = fcWorkCycle.getInt(250);
            Property fcCellWorkCycle = MFFSconfig.get("general", "ForceciumCellWorkCylce", 230);
            fcCellWorkCycle.setComment("WorkCycle amount of Forcecium Cell inside a Extractor");
            ForciciumCellWorkCycle = fcCellWorkCycle.getInt(230);
            Property extractorPassFEGen = MFFSconfig.get("general", "ExtractorPassForceEnergyGenerate", 12000);
            extractorPassFEGen.setComment("How many ForceEnergy generate per WorkCycle");
            ExtractorPassForceEnergyGenerate = extractorPassFEGen.getInt(12000);
            ExtractorPassForceEnergyGenerate = ExtractorPassForceEnergyGenerate / 4000 * 4000;
            Property defStationKillCost = MFFSconfig.get("general", "DefenceStationKillForceEnergy", 10000);
            defStationKillCost.setComment("How much FE does the AreaDefenseStation when killing someone");
            DefenceStationKillForceEnergy = defStationKillCost.getInt(10000);
            Property defStationSearchCost = MFFSconfig.get("general", "DefenceStationSearchForceEnergy", 1000);
            defStationSearchCost.setComment("How much FE does the AreaDefenseStation when searching someone for contraband");
            DefenceStationSearchForceEnergy = defStationSearchCost.getInt(1000);
            Property defStationScannCost = MFFSconfig.get("general", "DefenceStationScannForceEnergy", 10);
            defStationScannCost.setComment("How much FE does the AreaDefenseStation when Scann for Targets (amount * range / tick)");
            DefenceStationScannForceEnergy = defStationScannCost.getInt(10);
            Property Adventuremap = MFFSconfig.get("general", "adventuremap", false);
            Adventuremap.setComment("Set MFFS to AdventureMap Mode Extractor need no Forcecium and ForceField have no click damage");
            adventureMapMode = Adventuremap.getBoolean(false);
            Property ic2Recipes = MFFSconfig.get("general", "enableIC2Recipes", true);
            ic2Recipes.setComment("Set to false to disable IndustrialCraft 2 recipes for MFFS machines.");
            enableIC2Recipes = ic2Recipes.getBoolean(true);
            Property teRecipes = MFFSconfig.get("general", "enableTERecipes", false);
            teRecipes.setComment("Set to false to disable Thermal Expansion recipes for MFFS machines.");
            enableTERecipes = teRecipes.getBoolean(true);
            Property eiRecipes = MFFSconfig.get("general", "enableEIRecipes", true);
            eiRecipes.setComment("Set to false to disable Ender IO recipes for MFFS machines.");
            enableEIRecipes = eiRecipes.getBoolean(true);
            Property grindRecipe = MFFSconfig.get("general", "enableAEGrindStoneRecipe", true);
            grindRecipe.setComment("Set to false to disable the Applied Energistics Grind Stone recipe for MFFS machines.");
            enableAEGrindStoneRecipe = grindRecipe.getBoolean(true);
            Property monazitSmeltOutput = MFFSconfig.get("general", "monazitOreSmeltAmount", 4);
            monazitSmeltOutput.setComment("Amount of Forcium to generate per Monazit ore when smelting");
            MonazitOreSmeltAmount = monazitSmeltOutput.getInt(4);
            Property grindOutput = MFFSconfig.get("general", "grindRecipeOutput", 8);
            grindOutput.setComment("Amount of Forcicium to generate per Monazit ore in the AE Grind Stone.");
            grindRecipeOutput = grindOutput.getInt(8);
            Property grindCost = MFFSconfig.get("general", "grindRecipeCost", 12);
            grindCost.setComment("Number of clicks on the Applied Energistics Grind Stone Crank that must be registered to turn Monazit into Forcicium.");
            grindRecipeCost = grindCost.getInt(12);
            Property controlSystemRange = MFFSconfig.get("general", "controlSystemRange", TileEntityControlSystem.MACHINE_RANGE);
            controlSystemRange.setComment("Range (in meters) a block must be within for the control system to be able to access its GUI.");
            TileEntityControlSystem.MACHINE_RANGE = controlSystemRange.getInt(TileEntityControlSystem.MACHINE_RANGE);
        }
        catch (Exception e) {
            log.error("ModularForceFieldSystem has a problem loading its configuration!", (Throwable)e);
            System.out.println(e.getMessage());
        }
        finally {
            MFFSconfig.save();
        }
        VersionLocal = Versioninfo.curentversion();
        VersionRemote = Versioninfo.newestversion();
        proxy.registerTileEntitySpecialRenderer();
    }

    private int nextID() {
        return packetId++;
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent evt) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new MFFSWorldGenerator(), (int)0);
        OreDictionary.registerOre((String)"dustMonazit", (Item)ModItems.FORCICIUM);
        OreDictionary.registerOre((String)"oreMonazit", (Block)ModBlocks.MONAZIT_ORE);
        MFFSMaschines.initialize();
        ProjectorTyp.initialize();
        ProjectorOptions.initialize();
        MFFSRecipes.init();
        proxy.addBookPages();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)instance, (ForgeChunkManager.LoadingCallback)new MFFSChunkloadCallback());
    }

    public void initComputerCraftPlugin() {
        log.info("Loading module for ComputerCraft");
        try {
            Class.forName("dan200.ComputerCraft");
            computercraftFound = true;
        }
        catch (Throwable t) {
            log.info("Module not loaded: ComputerCraft not found");
        }
    }

    public void initBuildcraftPlugin() {
        log.info("Loading module for Buildcraft");
        try {
            Class.forName("buildcraft.core.Version");
            buildcraftFound = true;
        }
        catch (Throwable t) {
            log.info("Module not loaded: Buildcraft not found");
        }
    }

    public void initThermalExpansionPlugin() {
        log.info("Loading module for ThermalExpansion");
        try {
            Class.forName("thermalexpansion.ThermalExpansion");
            thermalExpansionFound = true;
        }
        catch (Throwable t) {
            log.info("Module not loaded: ThermalExpansion not found");
        }
    }

    public void initEnderIoPlugin() {
        log.info("Loading module for EnderIo");
        try {
            Class.forName("crazypants.enderio.EnderIO");
            enderIoFound = true;
        }
        catch (Throwable t) {
            log.info("Module not loaded: EnderIo not found");
        }
    }

    public void initEE3Plugin() {
        log.info("Loading module for EE3");
        try {
            Class.forName("com.pahimar.ee3.event.ActionRequestEvent");
            ee3Found = true;
        }
        catch (Throwable t) {
            log.info("Module not loaded: EE3 not found");
        }
    }

    public void initIC2Plugin() {
        log.info("Loading module for IC2");
        try {
            Class.forName("ic2.core.IC2");
            ic2Found = true;
        }
        catch (Throwable t) {
            log.info("Module not loaded: IC2 not found");
        }
    }

    public void initAEPlugin() {
        log.info("Loading module for Applied Energistics");
        try {
            Class.forName("appeng.common.AppEng");
            appliedEnergisticsFound = true;
        }
        catch (Throwable t) {
            log.info("Module not loaded: Applied Energistics not found");
        }
    }

    static {
        MFFSRENDER_ID = 2908;
        MonazitOreworldamount = 4;
        MonazitOreSmeltAmount = 4;
        ic2Found = false;
        ee3Found = false;
        buildcraftFound = false;
        thermalExpansionFound = false;
        enderIoFound = false;
        computercraftFound = false;
        appliedEnergisticsFound = false;
        enableIC2Recipes = true;
        enableTERecipes = true;
        enableAEGrindStoneRecipe = true;
        grindRecipeOutput = 8;
        grindRecipeCost = 16;
        graphicsStyle = 1;
        enableChunkLoader = true;
        packetId = 0;
    }

    public class MFFSChunkloadCallback
    implements ForgeChunkManager.OrderedLoadingCallback {
        public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
            for (ForgeChunkManager.Ticket ticket : tickets) {
                int MaschineX = ticket.getModData().func_74762_e("MaschineX");
                int MaschineY = ticket.getModData().func_74762_e("MaschineY");
                int MaschineZ = ticket.getModData().func_74762_e("MaschineZ");
                TileEntityMachines Machines = (TileEntityMachines)world.func_175625_s(new BlockPos(MaschineX, MaschineY, MaschineZ));
                Machines.forceChunkLoading(ticket);
            }
        }

        public List<ForgeChunkManager.Ticket> ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world, int maxTicketCount) {
            ArrayList validTickets = Lists.newArrayList();
            for (ForgeChunkManager.Ticket ticket : tickets) {
                int MaschineZ;
                int MaschineY;
                int MaschineX = ticket.getModData().func_74762_e("MaschineX");
                TileEntity tileEntity = world.func_175625_s(new BlockPos(MaschineX, MaschineY = ticket.getModData().func_74762_e("MaschineY"), MaschineZ = ticket.getModData().func_74762_e("MaschineZ")));
                if (!(tileEntity instanceof TileEntityMachines)) continue;
                validTickets.add(ticket);
            }
            return validTickets;
        }
    }
}

