/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util.styledstring;

import com.pau101.fairylights.util.styledstring.StyledString;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import net.minecraft.client.gui.FontRenderer;
import org.apache.commons.lang3.ArrayUtils;

public class StyledStringSelection
implements Transferable {
    public static final DataFlavor FLAVOR = new DataFlavor(StyledString.class, "Styled String");
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{FLAVOR, DataFlavor.stringFlavor, DataFlavor.fragmentHtmlFlavor};
    private final FontRenderer font;
    private final StyledString value;

    public StyledStringSelection(FontRenderer font, StyledString value) {
        this.font = font;
        this.value = value;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])FLAVORS.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return ArrayUtils.contains((Object[])FLAVORS, (Object)flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor.equals(FLAVOR)) {
            return this.value;
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this.value == null ? "" : this.value.toUnstyledString();
        }
        if (flavor.equals(DataFlavor.fragmentHtmlFlavor)) {
            return StyledString.toHTMLFragment(this.font, this.value);
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

