/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex..shadow.mcopts.commands.parameters.expect;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import ivorius.reccomplex..shadow.mcopts.commands.parameters.NaP;
import ivorius.reccomplex..shadow.mcopts.commands.parameters.Parameter;
import ivorius.reccomplex..shadow.mcopts.commands.parameters.Parameters;
import ivorius.reccomplex..shadow.mcopts.translation.Translations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.tuple.Pair;

public class Expect {
    protected final Map<String, SuggestParameter> params = new HashMap<String, SuggestParameter>();
    protected final Multimap<String, String> aliases = HashMultimap.create();
    protected final Set<String> shortParams = new HashSet<String>();
    protected final Set<String> flags = new HashSet<String>();
    protected String currentName;
    protected final List<String> order = new ArrayList<String>();
    protected int currentCount;
    protected int until = -1;
    protected boolean or;

    public Expect() {
        this.getOrCreate(null);
    }

    public static Stream<?> unwrap(Object arg) {
        if (arg instanceof Pair) {
            arg = Stream.concat(Expect.unwrap(((Pair)arg).getLeft()), Expect.unwrap(((Pair)arg).getRight()));
        }
        while (arg instanceof Optional) {
            arg = ((Optional)((Object)arg)).orElse(Collections.emptyList());
        }
        if (arg instanceof IntStream) {
            arg = ((IntStream)((Object)arg)).mapToObj(String::valueOf);
        }
        if (arg instanceof Collection) {
            arg = ((Collection)((Object)arg)).stream();
        }
        if (arg instanceof Stream) {
            return arg;
        }
        return Stream.of(arg);
    }

    public static Collection<String> toStrings(Object arg) {
        return Expect.unwrap(arg).map(Object::toString).collect(Collectors.toList());
    }

    public static List<String> matching(String arg, Object completion) {
        return CommandBase.func_175762_a((String[])new String[]{arg}, (Collection)Expect.unwrap(completion).collect(Collectors.toList()));
    }

    public static List<String> matchingAny(String arg, Object ... suggest) {
        return CommandBase.func_175762_a((String[])new String[]{arg}, Arrays.asList(suggest));
    }

    public Parameters declareLenient(Parameters parameters) {
        parameters.flags(this.flags);
        this.params.forEach((key, param) -> {
            if (!Objects.equals(param.name, key)) {
                parameters.alias(param.name, (String)key);
            }
        });
        parameters.until(this.until);
        return parameters;
    }

    public Parameters declare(Parameters parameters) {
        TObjectIntHashMap restrict = new TObjectIntHashMap();
        this.params.forEach((arg_0, arg_1) -> Expect.lambda$declare$1((TObjectIntMap)restrict, arg_0, arg_1));
        parameters.restrict((TObjectIntMap<String>)restrict);
        return this.declareLenient(parameters);
    }

    @Nonnull
    protected SuggestParameter getOrCreate(@Nullable String name) {
        SuggestParameter param = this.params.get(name);
        if (param == null) {
            param = new SuggestParameter(name);
            this.params.put(name, param);
        }
        return param;
    }

    public Expect named(@Nonnull String name, String ... aliases) {
        Pair<String, Boolean> p = this.name(name);
        this.currentName = (String)p.getKey();
        SuggestParameter param = this.getOrCreate(this.currentName);
        if (((Boolean)p.getRight()).booleanValue()) {
            this.shortParams.add((String)p.getKey());
        }
        for (String alias : aliases) {
            p = this.name(alias);
            this.params.put(alias, param);
            if (!((Boolean)p.getRight()).booleanValue()) continue;
            this.shortParams.add((String)p.getKey());
        }
        this.aliases.putAll((Object)name, Arrays.asList(aliases));
        return this;
    }

    private Pair<String, Boolean> name(String name) {
        boolean isShort = false;
        if (name.startsWith("--")) {
            name = name.substring("--".length());
        } else if (name.length() == 1) {
            isShort = true;
        } else if (name.startsWith("-")) {
            throw new IllegalArgumentException();
        }
        return Pair.of((Object)name, (Object)isShort);
    }

    public Expect flag(@Nonnull String name, String ... aliases) {
        this.flags.add(name);
        Collections.addAll(this.flags, aliases);
        return this.named(name, aliases);
    }

    public Expect atOnce(int num) {
        this.currentCount = num;
        return this;
    }

    public Expect nextRaw(Completer completion) {
        SuggestParameter cur = this.getOrCreate(this.currentName);
        if (this.or) {
            cur.or(completion);
            this.or = false;
        } else {
            this.order.add(this.currentName);
            cur.next(completion);
            this.currentCount = 1;
            this.optional();
        }
        return this;
    }

    public Expect next(Completer completion) {
        return this.nextRaw((MinecraftServer server, ICommandSender sender, Parameters params, BlockPos pos) -> Expect.matching(params.last(), completion.complete(server, sender, params, pos)));
    }

    public Expect skip() {
        return this.nextRaw((MinecraftServer server, ICommandSender sender, Parameters parameters, BlockPos pos) -> Stream.of(new Object[0]));
    }

    public Expect anyRaw(Object ... completion) {
        return this.nextRaw((MinecraftServer server, ICommandSender sender, Parameters params, BlockPos pos) -> Stream.of(completion));
    }

    public Expect any(Object ... completion) {
        return this.nextRaw((MinecraftServer server, ICommandSender sender, Parameters params, BlockPos pos) -> Expect.matchingAny(params.last(), completion));
    }

    public Expect nextRaw(Object completion) {
        return this.nextRaw((MinecraftServer server, ICommandSender sender, Parameters params, BlockPos pos) -> completion);
    }

    public Expect next(Object completion) {
        return this.nextRaw((MinecraftServer server, ICommandSender sender, Parameters params, BlockPos pos) -> Expect.matching(params.last(), completion));
    }

    public Expect nextRaw(Function<Parameters, ?> completion) {
        return this.nextRaw((MinecraftServer server, ICommandSender sender, Parameters params, BlockPos pos) -> completion.apply(params));
    }

    public Expect next(Function<Parameters, ?> completion) {
        return this.nextRaw((MinecraftServer server, ICommandSender sender, Parameters params, BlockPos pos) -> Expect.matching(params.last(), completion.apply(params)));
    }

    public Expect then(Consumer<Expect> fun) {
        fun.accept(this);
        return this;
    }

    public <P> Expect then(BiConsumer<Expect, P> fun, P p) {
        fun.accept(this, p);
        return this;
    }

    public Expect repeat() {
        SuggestParameter cur = this.params.get(this.currentName);
        if (cur == null) {
            throw new IllegalStateException();
        }
        cur.repeat = true;
        return this;
    }

    public Expect splitInner(Consumer<Expect> consumer) {
        Expect inner = Parameters.expect().then(consumer);
        this.nextRaw((MinecraftServer server, ICommandSender sender, Parameters parameters, BlockPos pos) -> {
            String last = parameters.last();
            String[] split = last.split(" ", -1);
            int lastSplit = last.lastIndexOf(" ");
            String lastStart = lastSplit >= 0 ? last.substring(0, lastSplit) + " " : "";
            return inner.get(server, sender, split, pos).stream().map(s -> lastStart + s);
        });
        return inner;
    }

    public Expect split(Consumer<Expect> consumer) {
        this.splitInner(consumer);
        return this;
    }

    public Expect words(Consumer<Expect> consumer) {
        Expect inner = this.splitInner(expect -> expect.then(consumer).repeat());
        this.descriptionU((String)Iterables.getLast(inner.mapLastDescriptions((i, s) -> s)));
        return this;
    }

    public Expect or() {
        if (this.or) {
            throw new IllegalStateException();
        }
        this.or = true;
        return this;
    }

    public int index() {
        return this.params.size();
    }

    public Expect stopInterpreting() {
        this.until = this.params.get(null).completions.size();
        return this;
    }

    public List<String> get(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        boolean shortFlag;
        Parameters parameters = Parameters.ofLenient(args, this::declare);
        String lastName = parameters.lastName();
        Parameter<String> entered = lastName != null ? parameters.get(lastName) : parameters.get(0);
        SuggestParameter param = this.params.get(lastName);
        String currentArg = parameters.last();
        String currentArgRaw = parameters.lastRaw();
        boolean lastArgStartsQuote = args[args.length - 1].startsWith("\"") && parameters.interpretes();
        boolean lastArgQuoted = currentArgRaw.startsWith("\"") && parameters.interpretes();
        boolean longFlag = Parameters.hasLongPrefix(currentArgRaw) && parameters.interpretes();
        boolean bl = shortFlag = Parameters.hasShortPrefix(currentArgRaw) && parameters.interpretes();
        if (!(param == null || entered.count() > param.completions.size() && !param.repeat || parameters.interpretes() && (longFlag || shortFlag))) {
            Completer completer = param.completions.get(Math.min(entered.count() - 1, param.completions.size() - 1));
            return Expect.toStrings(completer.complete(server, sender, parameters, pos)).stream().map(s -> {
                int wordStartIndex = s.lastIndexOf(32, CommandBase.func_71523_a((String)currentArg, (String)s) ? currentArg.length() - 1 : s.length());
                boolean startQuote = s.contains(" ") && wordStartIndex < 0 || lastArgStartsQuote;
                s = s.substring(wordStartIndex + 1, s.length());
                if (lastArgQuoted || startQuote) {
                    s = Parameters.escape(s);
                }
                if (startQuote) {
                    s = "\"" + s;
                }
                return s;
            }).collect(Collectors.toCollection(ArrayList::new));
        }
        if (!parameters.interpretes()) {
            return Collections.emptyList();
        }
        ArrayList<String> suggest = new ArrayList<String>();
        suggest.addAll(this.remaining(currentArg, parameters, false));
        suggest.addAll(this.remaining(currentArg, parameters, true));
        return Expect.matching(currentArg, suggest);
    }

    @Nonnull
    public Collection<String> remaining(String currentArg, Parameters parameters, boolean useShort) {
        return Expect.toStrings(this.params.entrySet().stream().filter(e -> e.getKey() != null).filter(e -> !parameters.has((String)e.getKey()) || parameters.get((String)e.getKey()).count() < ((SuggestParameter)e.getValue()).completions.size() || ((SuggestParameter)e.getValue()).repeat).map(Map.Entry::getKey).filter(p -> this.shortParams.contains(p) == useShort).map(p -> Parameters.prefix(this.shortParams.contains(p)) + p));
    }

    protected List<String> mapLastDescriptions(BiFunction<Integer, String, String> fun) {
        List<String> relevant = this.order.subList(this.order.size() - this.currentCount, this.order.size());
        int[] idx = new int[1];
        List last = relevant.stream().map(s -> {
            List<String> list = this.params.get((Object)s).descriptions;
            return list.remove(list.size() - 1);
        }).map(s -> {
            int n = idx[0];
            idx[0] = n + 1;
            return (String)fun.apply(n, (String)s);
        }).collect(Collectors.toList());
        relevant.stream().forEach(s -> this.params.get((Object)s).descriptions.add((String)last.remove(last.size() - 1)));
        return relevant;
    }

    protected String stripOptionality(String description) {
        return description.startsWith("[") || description.startsWith("<") ? description.substring(1, description.length() - 1) : description;
    }

    protected String preserveOptionality(String description, String ref) {
        return ref.startsWith("[") ? String.format("[%s]", description) : (ref.startsWith("<") ? String.format("<%s>", description) : description);
    }

    public Expect descriptionU(List<String> description) {
        if (description.size() != this.currentCount) {
            throw new IllegalArgumentException();
        }
        this.mapLastDescriptions((i, s) -> this.preserveOptionality((String)description.get((int)i), (String)s));
        return this;
    }

    public Expect descriptionU(String ... descriptions) {
        return this.descriptionU(Arrays.asList(descriptions));
    }

    public Expect description(String ... keys) {
        return this.descriptionU(Arrays.stream(keys).map(Translations::get).collect(Collectors.toList()));
    }

    public Expect required() {
        this.mapLastDescriptions((i, s) -> String.format("<%s>", this.stripOptionality((String)s)));
        return this;
    }

    public Expect optional() {
        this.mapLastDescriptions((i, s) -> String.format("[%s]", this.stripOptionality((String)s)));
        return this;
    }

    public Expect naked() {
        this.mapLastDescriptions((i, s) -> this.stripOptionality((String)s));
        return this;
    }

    public String usage() {
        return TextFormatting.RESET + Stream.concat(this.params.get(null).usage(), this.params.entrySet().stream().filter(e -> e.getKey() != null).filter(e -> ((String)e.getKey()).equals(((SuggestParameter)e.getValue()).name)).flatMap(e -> this.flags.contains(e.getKey()) ? Stream.of(this.keyRepresentation((String)e.getKey())) : ((SuggestParameter)e.getValue()).usage().map(desc -> String.format("%s %s", this.keyRepresentation((String)e.getKey()), desc)))).reduce("", NaP::join);
    }

    protected String keyRepresentation(String key) {
        ArrayList aliases = Lists.newArrayList((Iterable)this.aliases.get((Object)key));
        Iterator iterator = aliases.iterator();
        while (iterator.hasNext()) {
            String alias = (String)iterator.next();
            if (!key.contains(alias)) continue;
            key = key.replaceFirst(alias, String.format("%s%s%s", TextFormatting.AQUA, alias, TextFormatting.RESET));
            iterator.remove();
        }
        aliases.add(0, key);
        return Parameters.prefix(this.shortParams.contains(key)) + String.join((CharSequence)"|", aliases);
    }

    private static /* synthetic */ void lambda$declare$1(TObjectIntMap restrict, String key, SuggestParameter param) {
        if (Objects.equals(param.name, key)) {
            restrict.put((Object)key, param.repeat ? -1 : param.completions.size());
        }
    }

    protected class SuggestParameter {
        protected String name;
        protected final List<Completer> completions = new ArrayList<Completer>();
        protected final List<String> descriptions = new ArrayList<String>();
        protected boolean repeat;

        public SuggestParameter(String name) {
            this.name = name;
        }

        public SuggestParameter next(Completer completion) {
            this.completions.add(completion);
            this.descriptions.add(String.format("[%d]", this.completions.size()));
            return this;
        }

        public SuggestParameter or(Completer completion) {
            Completer prev = this.completions.remove(this.completions.size() - 1);
            this.completions.add((server, sender, parameters, pos) -> Pair.of((Object)prev.complete(server, sender, parameters, pos), (Object)completion.complete(server, sender, parameters, pos)));
            return this;
        }

        public Stream<String> usage() {
            return IntStream.range(0, this.descriptions.size()).mapToObj(i -> String.format("%s%s%s%s", TextFormatting.YELLOW, this.descriptions.get(i), TextFormatting.RESET, this.repeat && i == this.descriptions.size() - 1 ? "..." : ""));
        }
    }

    public static interface Completer {
        public Object complete(MinecraftServer var1, ICommandSender var2, Parameters var3, @Nullable BlockPos var4);
    }
}

