/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.item;

import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.item.ItemBlockSelector;
import ivorius.reccomplex.item.ItemInputHandler;
import ivorius.reccomplex.item.ItemSyncableTags;
import ivorius.reccomplex.network.PacketSyncItem;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class ItemBlockSelectorFloating
extends ItemBlockSelector
implements ItemSyncableTags,
ItemInputHandler {
    public static final float SCROLL_DISTANCE_SPEED = 0.004f;

    public static BlockPos getHoveredBlock(EntityLivingBase entity, float selectionRange) {
        Vec3d look = entity.func_70040_Z();
        int blockX = MathHelper.func_76128_c((double)(look.field_72450_a * (double)selectionRange + entity.field_70165_t));
        int blockY = MathHelper.func_76128_c((double)(look.field_72448_b * (double)selectionRange + entity.field_70163_u + (double)entity.func_70047_e()));
        int blockZ = MathHelper.func_76128_c((double)(look.field_72449_c * (double)selectionRange + entity.field_70161_v));
        return new BlockPos(blockX, blockY, blockZ);
    }

    @Override
    @Nullable
    public BlockPos hoveredBlock(ItemStack stack, EntityLivingBase entity) {
        return ItemBlockSelectorFloating.getHoveredBlock(entity, this.getSelectionRange(stack));
    }

    public float getSelectionRange(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b("selectionRange", 5) ? stack.func_77978_p().func_74760_g("selectionRange") : 2.0f;
    }

    public void setSelectionRange(ItemStack stack, float range) {
        stack.func_77983_a("selectionRange", (NBTBase)new NBTTagFloat(range));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(String.format("Range: %.02f", Float.valueOf(this.getSelectionRange(stack))));
        tooltip.add("(Hold ctrl and scroll to modify range)");
        tooltip.add("(Hold ctrl for secondary selection)");
    }

    @Override
    public List<Pair<String, Integer>> getSyncedNBTTags() {
        return Collections.singletonList(Pair.of((Object)"selectionRange", (Object)5));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onMouseInput(EntityPlayer player, ItemStack stack, int button, boolean buttonState, int dWheel) {
        if (ItemBlockSelectorFloating.modifierKeyDown() && dWheel != 0) {
            this.setSelectionRange(stack, MathHelper.func_76131_a((float)(this.getSelectionRange(stack) + (float)dWheel * 0.004f), (float)0.0f, (float)40.0f));
            RecurrentComplex.network.sendToServer((IMessage)new PacketSyncItem(player.field_71071_by.field_70461_c, stack));
            return true;
        }
        return false;
    }
}

