/*
 * Decompiled with CFR 0.152.
 */
package uk.gaz492.playerplates.blocks;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class BlockPlayerPlates
extends BlockBasePressurePlate {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public final Sensitivity sensitivity;
    private final String ToolTipText;
    private boolean isInvisible;

    public BlockPlayerPlates(Sensitivity sensitivity, String toolTipText, boolean invisible) {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWERED, (Comparable)Boolean.FALSE));
        this.sensitivity = sensitivity;
        this.ToolTipText = toolTipText;
        this.isInvisible = invisible;
        this.field_149785_s = invisible;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        if (this.isInvisible) {
            return EnumBlockRenderType.INVISIBLE;
        }
        return super.func_149645_b(state);
    }

    public void func_190948_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.GOLD + "Triggered By: " + TextFormatting.GRAY + this.ToolTipText);
        if (this.isInvisible) {
            tooltip.add(TextFormatting.GREEN + "Invisible when placed");
            tooltip.add(TextFormatting.RED + "Silent");
        }
    }

    public int func_176576_e(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 15 : 0;
    }

    public IBlockState func_176575_a(IBlockState state, int strength) {
        return state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(strength > 0));
    }

    public void func_185507_b(World worldIn, BlockPos color) {
        if (!this.isInvisible) {
            worldIn.func_184133_a(null, color, SoundEvents.field_187901_ga, SoundCategory.BLOCKS, 0.3f, 0.6f);
        }
    }

    public void func_185508_c(World worldIn, BlockPos pos) {
        if (!this.isInvisible) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187847_fZ, SoundCategory.BLOCKS, 0.3f, 0.5f);
        }
    }

    public int func_180669_e(World worldIn, BlockPos pos) {
        List list;
        AxisAlignedBB axisalignedbb = field_185511_c.func_186670_a(pos);
        switch (this.sensitivity) {
            case EVERYTHING: {
                list = worldIn.func_72839_b(null, axisalignedbb);
                break;
            }
            case ITEMS: {
                list = worldIn.func_72872_a(EntityItem.class, axisalignedbb);
                break;
            }
            case ITEMS_MOB: {
                List list1 = worldIn.func_72872_a(EntityItem.class, axisalignedbb);
                List list2 = worldIn.func_72872_a(EntityLiving.class, axisalignedbb);
                list = Stream.concat(list1.stream(), list2.stream()).collect(Collectors.toList());
                break;
            }
            case ITEMS_PLAYER: {
                List list1 = worldIn.func_72872_a(EntityItem.class, axisalignedbb);
                List list2 = worldIn.func_72872_a(EntityPlayerMP.class, axisalignedbb);
                list = Stream.concat(list1.stream(), list2.stream()).collect(Collectors.toList());
                break;
            }
            case MOBS_PLAYER: {
                List list1 = worldIn.func_72872_a(EntityLivingBase.class, axisalignedbb);
                List list2 = worldIn.func_72872_a(EntityLiving.class, axisalignedbb);
                list = Stream.concat(list1.stream(), list2.stream()).collect(Collectors.toList());
                break;
            }
            case MOBS: {
                list = worldIn.func_72872_a(EntityLivingBase.class, axisalignedbb);
                break;
            }
            case PLAYER: {
                list = worldIn.func_72872_a(EntityPlayerMP.class, axisalignedbb);
                break;
            }
            default: {
                return 0;
            }
        }
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.func_145773_az()) continue;
                return 15;
            }
        }
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 1 : 0;
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED});
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack pick;
        if (player instanceof EntityPlayerMP && player.func_110124_au().toString().equals("e6aef4a5-48b8-475b-af37-c64d813d1790") && !player.field_71071_by.func_70431_c(pick = new ItemStack(Items.field_151046_w))) {
            int randEnchLowLvl = world.field_73012_v.nextInt(3) + 1;
            int randRange = world.field_73012_v.nextInt(91) + 10;
            pick.func_77966_a(Enchantments.field_185307_s, 10);
            pick.func_77966_a(Enchantments.field_185305_q, 10);
            if (randRange > 95) {
                pick.func_77966_a(Enchantments.field_185308_t, randEnchLowLvl);
            }
            player.field_71071_by.func_70441_a(pick);
        }
        return false;
    }

    public static enum Sensitivity {
        EVERYTHING,
        ITEMS,
        ITEMS_MOB,
        ITEMS_PLAYER,
        MOBS_PLAYER,
        PLAYER,
        MOBS;

    }
}

