/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.vmfixes.mixin;

import com.mamiyaotaru.voxelmap.Map;
import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.interfaces.AbstractMapData;
import com.mamiyaotaru.voxelmap.interfaces.IColorManager;
import com.mamiyaotaru.voxelmap.interfaces.IMap;
import com.mamiyaotaru.voxelmap.util.BiomeRepository;
import com.mamiyaotaru.voxelmap.util.BlockRepository;
import com.mamiyaotaru.voxelmap.util.FullMapData;
import com.mamiyaotaru.voxelmap.util.MutableBlockPos;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Map.class})
public abstract class MapMixin
implements Runnable,
IMap {
    @Shadow
    private MutableBlockPos blockPos;
    @Shadow
    private FullMapData[] mapData;
    @Shadow
    private MapSettingsManager options;
    @Shadow
    private IColorManager colorManager;
    @Shadow
    private int zoom;
    @Shadow
    private int lastY;
    @Shadow
    private Minecraft game;
    @Shadow
    private MutableBlockPos tempBlockPos;

    @Shadow
    protected abstract int[] getSeafloorHeight(World var1, int var2, int var3, int var4);

    @Shadow
    protected abstract int applyHeight(int var1, boolean var2, boolean var3, World var4, int var5, int var6, int var7, int var8, int var9, int var10, boolean var11, int var12);

    @Shadow
    protected abstract int getLight(int var1, IBlockState var2, World var3, int var4, int var5, int var6, boolean var7);

    @Shadow
    protected abstract int getTransparentHeight(boolean var1, boolean var2, World var3, int var4, int var5, int var6);

    @Shadow
    protected abstract int doSlimeAndGrid(int var1, int var2, int var3);

    @Shadow
    protected abstract int getBlockHeight(boolean var1, boolean var2, World var3, int var4, int var5);

    @Overwrite(remap=false)
    private int getPixelColor(boolean needBiome, boolean needHeightAndID, boolean needTint, boolean needLight, boolean nether, boolean caves, World world, int multi, int startX, int startZ, int imageX, int imageY) {
        int color24;
        Material material;
        int light;
        int surfaceColor;
        int blockStateID;
        IBlockState blockState;
        int surfaceHeight;
        int biomeID;
        int seafloorHeight = -1;
        int underwaterTransparentHeight = -1;
        int transparentHeight = -1;
        int foliageHeight = -1;
        int seafloorColor = 0;
        int transparentColor = 0;
        int foliageColor = 0;
        this.blockPos = this.blockPos.withXYZ(startX + imageX, 0, startZ + imageY);
        if (needBiome) {
            biomeID = world.func_175726_f((BlockPos)this.blockPos).func_177410_o() ? Biome.func_185362_a((Biome)world.func_180494_b((BlockPos)this.blockPos)) : -1;
            this.mapData[this.zoom].setBiomeID(imageX, imageY, biomeID);
        } else {
            biomeID = this.mapData[this.zoom].getBiomeID(imageX, imageY);
        }
        if (this.options.biomeOverlay == 1) {
            int color242 = biomeID >= 0 ? BiomeRepository.getBiomeColor((int)biomeID) | 0xFF000000 : 0;
            color242 = this.doSlimeAndGrid(color242, startX + imageX, startZ + imageY);
            return color242;
        }
        boolean blockChangeForcedTint = false;
        boolean solid = false;
        if (needHeightAndID) {
            surfaceHeight = this.getBlockHeight(nether, caves, world, startX + imageX, startZ + imageY);
            blockState = world.func_180495_p((BlockPos)this.blockPos.withXYZ(startX + imageX, surfaceHeight, startZ + imageY));
            if (blockState.func_185904_a() != Material.field_151597_y) {
                blockState = world.func_180495_p((BlockPos)this.blockPos.withXYZ(startX + imageX, surfaceHeight - 1, startZ + imageY));
            }
            blockState = blockState.func_177230_c().hasTileEntity(blockState) ? blockState.func_177230_c().func_176223_P() : blockState.func_185899_b((IBlockAccess)world, (BlockPos)this.blockPos);
            blockStateID = BlockRepository.getStateId((IBlockState)blockState);
            if (this.options.biomes && blockState != this.mapData[this.zoom].getBlockstate(imageX, imageY)) {
                blockChangeForcedTint = true;
            }
            this.mapData[this.zoom].setHeight(imageX, imageY, surfaceHeight);
            this.mapData[this.zoom].setBlockstateID(imageX, imageY, blockStateID);
        } else {
            surfaceHeight = this.mapData[this.zoom].getHeight(imageX, imageY);
            blockStateID = this.mapData[this.zoom].getBlockstateID(imageX, imageY);
            blockState = BlockRepository.getStateById((int)blockStateID);
        }
        if (surfaceHeight == -1) {
            surfaceHeight = this.lastY + 1;
            solid = true;
        }
        if (blockState.func_185904_a() == Material.field_151587_i) {
            solid = false;
        }
        if (this.options.biomes) {
            int tint;
            surfaceColor = this.colorManager.getBlockColor(this.blockPos, blockStateID, biomeID);
            if (needTint || blockChangeForcedTint) {
                tint = this.colorManager.getBiomeTint((AbstractMapData)this.mapData[this.zoom], world, blockState, blockStateID, this.blockPos, this.tempBlockPos, startX, startZ);
                this.mapData[this.zoom].setBiomeTint(imageX, imageY, tint);
            } else {
                tint = this.mapData[this.zoom].getBiomeTint(imageX, imageY);
            }
            if (tint != -1) {
                surfaceColor = this.colorManager.colorMultiplier(surfaceColor, tint);
            }
        } else {
            surfaceColor = this.colorManager.getBlockColorWithDefaultTint(this.blockPos, blockStateID);
        }
        surfaceColor = this.applyHeight(surfaceColor, nether, caves, world, multi, startX, startZ, imageX, imageY, surfaceHeight, solid, 1);
        if (needLight) {
            light = this.getLight(surfaceColor, blockState, world, startX + imageX, startZ + imageY, surfaceHeight, solid);
            this.mapData[this.zoom].setLight(imageX, imageY, light);
        } else {
            light = this.mapData[this.zoom].getLight(imageX, imageY);
        }
        if (light == 0) {
            surfaceColor = 0;
        } else if (light != 255) {
            surfaceColor = this.colorManager.colorMultiplier(surfaceColor, light);
        }
        if (this.options.waterTransparency && ((material = blockState.func_185904_a()) == Material.field_151586_h || material == Material.field_151588_w)) {
            int seafloorLight;
            if (needHeightAndID) {
                int[] underwaterHeights = this.getSeafloorHeight(world, startX + imageX, startZ + imageY, surfaceHeight);
                seafloorHeight = underwaterHeights[0];
                underwaterTransparentHeight = underwaterHeights[1];
                this.blockPos.setXYZ(startX + imageX, seafloorHeight - 1, startZ + imageY);
                blockState = world.func_180495_p((BlockPos)this.blockPos);
                IBlockState iBlockState = blockState = blockState.func_177230_c().hasTileEntity(blockState) ? blockState.func_177230_c().func_176223_P() : blockState.func_185899_b((IBlockAccess)world, (BlockPos)this.blockPos);
                if (blockState.func_185904_a() == Material.field_151586_h) {
                    blockState = BlockRepository.air.func_176223_P();
                }
                blockStateID = BlockRepository.getStateId((IBlockState)blockState);
                if (this.options.biomes && blockState != this.mapData[this.zoom].getOceanFloorBlockstate(imageX, imageY)) {
                    blockChangeForcedTint = true;
                }
                this.mapData[this.zoom].setOceanFloorHeight(imageX, imageY, seafloorHeight);
                this.mapData[this.zoom].setOceanFloorBlockstateID(imageX, imageY, blockStateID);
            } else {
                seafloorHeight = this.mapData[this.zoom].getOceanFloorHeight(imageX, imageY);
                blockStateID = this.mapData[this.zoom].getOceanFloorBlockstateID(imageX, imageY);
                blockState = BlockRepository.getStateById((int)blockStateID);
            }
            if (this.options.biomes) {
                int tint;
                seafloorColor = this.colorManager.getBlockColor(this.blockPos, blockStateID, biomeID);
                if (needTint || blockChangeForcedTint) {
                    tint = this.colorManager.getBiomeTint((AbstractMapData)this.mapData[this.zoom], world, blockState, blockStateID, this.blockPos, this.tempBlockPos, startX, startZ);
                    this.mapData[this.zoom].setOceanFloorBiomeTint(imageX, imageY, tint);
                } else {
                    tint = this.mapData[this.zoom].getOceanFloorBiomeTint(imageX, imageY);
                }
                if (tint != -1) {
                    seafloorColor = this.colorManager.colorMultiplier(seafloorColor, tint);
                }
            } else {
                seafloorColor = this.colorManager.getBlockColorWithDefaultTint(this.blockPos, blockStateID);
            }
            seafloorColor = this.applyHeight(seafloorColor, nether, caves, world, multi, startX, startZ, imageX, imageY, seafloorHeight, solid, 0);
            if (needLight) {
                seafloorLight = this.getLight(seafloorColor, blockState, world, startX + imageX, startZ + imageY, seafloorHeight, solid);
                this.blockPos.setXYZ(startX + imageX, seafloorHeight, startZ + imageY);
                blockState = world.func_180495_p((BlockPos)this.blockPos);
                Material materialAbove = blockState.func_185904_a();
                if (this.options.lightmap && materialAbove == Material.field_151588_w) {
                    int multiplier = 255;
                    if (this.game.field_71474_y.field_74348_k == 1) {
                        multiplier = 200;
                    } else if (this.game.field_71474_y.field_74348_k == 2) {
                        multiplier = 120;
                    }
                    seafloorLight = this.colorManager.colorMultiplier(seafloorLight, 0xFF000000 | multiplier << 16 | multiplier << 8 | multiplier);
                }
                this.mapData[this.zoom].setOceanFloorLight(imageX, imageY, seafloorLight);
            } else {
                seafloorLight = this.mapData[this.zoom].getOceanFloorLight(imageX, imageY);
            }
            if (seafloorLight == 0) {
                seafloorColor = 0;
            } else if (seafloorLight != 255) {
                seafloorColor = this.colorManager.colorMultiplier(seafloorColor, seafloorLight);
            }
        }
        if (this.options.blockTransparency) {
            if (needHeightAndID) {
                transparentHeight = this.getTransparentHeight(nether, caves, world, startX + imageX, startZ + imageY, surfaceHeight);
                if (transparentHeight == -1 && this.options.waterTransparency && underwaterTransparentHeight > 0) {
                    transparentHeight = underwaterTransparentHeight;
                }
                if (transparentHeight != -1) {
                    this.blockPos.setXYZ(startX + imageX, transparentHeight - 1, startZ + imageY);
                    blockState = world.func_180495_p((BlockPos)this.blockPos);
                    blockState = blockState.func_177230_c().hasTileEntity(blockState) ? blockState.func_177230_c().func_176223_P() : blockState.func_185899_b((IBlockAccess)world, (BlockPos)this.blockPos);
                } else {
                    blockState = BlockRepository.air.func_176223_P();
                }
                blockStateID = BlockRepository.getStateId((IBlockState)blockState);
                if (this.options.biomes && blockState != this.mapData[this.zoom].getTransparentBlockstate(imageX, imageY)) {
                    blockChangeForcedTint = true;
                }
                this.mapData[this.zoom].setTransparentHeight(imageX, imageY, transparentHeight);
                this.mapData[this.zoom].setTransparentBlockstateID(imageX, imageY, blockStateID);
            } else {
                transparentHeight = this.mapData[this.zoom].getTransparentHeight(imageX, imageY);
                blockStateID = this.mapData[this.zoom].getTransparentBlockstateID(imageX, imageY);
                blockState = BlockRepository.getStateById((int)blockStateID);
            }
            if (blockState != null && blockState != BlockRepository.air.func_176223_P()) {
                int transparentLight;
                if (this.options.biomes) {
                    int tint;
                    transparentColor = this.colorManager.getBlockColor(this.blockPos, blockStateID, biomeID);
                    if (needTint || blockChangeForcedTint) {
                        tint = this.colorManager.getBiomeTint((AbstractMapData)this.mapData[this.zoom], world, blockState, blockStateID, this.blockPos, this.tempBlockPos, startX, startZ);
                        this.mapData[this.zoom].setTransparentBiomeTint(imageX, imageY, tint);
                    } else {
                        tint = this.mapData[this.zoom].getTransparentBiomeTint(imageX, imageY);
                    }
                    if (tint != -1) {
                        transparentColor = this.colorManager.colorMultiplier(transparentColor, tint);
                    }
                } else {
                    transparentColor = this.colorManager.getBlockColorWithDefaultTint(this.blockPos, blockStateID);
                }
                transparentColor = this.applyHeight(transparentColor, nether, caves, world, multi, startX, startZ, imageX, imageY, transparentHeight, solid, 3);
                if (needLight) {
                    transparentLight = this.getLight(transparentColor, blockState, world, startX + imageX, startZ + imageY, transparentHeight, solid);
                    this.mapData[this.zoom].setTransparentLight(imageX, imageY, transparentLight);
                } else {
                    transparentLight = this.mapData[this.zoom].getTransparentLight(imageX, imageY);
                }
                if (transparentLight == 0) {
                    transparentColor = 0;
                } else if (transparentLight != 255) {
                    transparentColor = this.colorManager.colorMultiplier(transparentColor, transparentLight);
                }
            }
            if (needHeightAndID) {
                IBlockState foliageBlockState = null;
                if (transparentHeight != surfaceHeight + 1) {
                    foliageHeight = surfaceHeight + 1;
                    this.blockPos.setXYZ(startX + imageX, foliageHeight - 1, startZ + imageY);
                    foliageBlockState = world.func_180495_p((BlockPos)this.blockPos);
                    foliageBlockState = foliageBlockState.func_177230_c().hasTileEntity(foliageBlockState) ? foliageBlockState.func_177230_c().func_176223_P() : foliageBlockState.func_185899_b((IBlockAccess)world, (BlockPos)this.blockPos);
                    Material material2 = foliageBlockState.func_185904_a();
                    if (material2 == Material.field_151597_y || material2 == Material.field_151579_a || material2 == Material.field_151587_i) {
                        foliageHeight = -1;
                    }
                    if (foliageBlockState == blockState) {
                        foliageHeight = -1;
                    }
                }
                if (foliageHeight == -1 && this.options.waterTransparency && seafloorHeight > 0 && transparentHeight != seafloorHeight) {
                    foliageHeight = seafloorHeight + 1;
                    this.blockPos.setXYZ(startX + imageX, foliageHeight - 1, startZ + imageY);
                    foliageBlockState = world.func_180495_p((BlockPos)this.blockPos);
                    foliageBlockState = foliageBlockState.func_177230_c().hasTileEntity(foliageBlockState) ? foliageBlockState.func_177230_c().func_176223_P() : foliageBlockState.func_185899_b((IBlockAccess)world, (BlockPos)this.blockPos);
                    Material material3 = foliageBlockState.func_185904_a();
                    if (material3 == Material.field_151579_a || material3 == Material.field_151587_i || material3 == Material.field_151586_h || material3 == Material.field_151588_w) {
                        foliageHeight = -1;
                    }
                    if (foliageBlockState == blockState) {
                        foliageHeight = -1;
                    }
                }
                blockState = foliageHeight != -1 ? foliageBlockState : BlockRepository.air.func_176223_P();
                blockStateID = BlockRepository.getStateId((IBlockState)blockState);
                if (this.options.biomes && blockState != this.mapData[this.zoom].getFoliageBlockstate(imageX, imageY)) {
                    blockChangeForcedTint = true;
                }
                this.mapData[this.zoom].setFoliageHeight(imageX, imageY, foliageHeight);
                this.mapData[this.zoom].setFoliageBlockstateID(imageX, imageY, blockStateID);
            } else {
                foliageHeight = this.mapData[this.zoom].getFoliageHeight(imageX, imageY);
                blockStateID = this.mapData[this.zoom].getFoliageBlockstateID(imageX, imageY);
                blockState = BlockRepository.getStateById((int)blockStateID);
            }
            if (blockState != null && blockState != BlockRepository.air.func_176223_P()) {
                int foliageLight;
                if (this.options.biomes) {
                    int tint;
                    foliageColor = this.colorManager.getBlockColor(this.blockPos, blockStateID, biomeID);
                    if (needTint || blockChangeForcedTint) {
                        tint = this.colorManager.getBiomeTint((AbstractMapData)this.mapData[this.zoom], world, blockState, blockStateID, this.blockPos, this.tempBlockPos, startX, startZ);
                        this.mapData[this.zoom].setFoliageBiomeTint(imageX, imageY, tint);
                    } else {
                        tint = this.mapData[this.zoom].getFoliageBiomeTint(imageX, imageY);
                    }
                    if (tint != -1) {
                        foliageColor = this.colorManager.colorMultiplier(foliageColor, tint);
                    }
                } else {
                    foliageColor = this.colorManager.getBlockColorWithDefaultTint(this.blockPos, blockStateID);
                }
                foliageColor = this.applyHeight(foliageColor, nether, caves, world, multi, startX, startZ, imageX, imageY, foliageHeight, solid, 2);
                if (needLight) {
                    foliageLight = this.getLight(foliageColor, blockState, world, startX + imageX, startZ + imageY, foliageHeight, solid);
                    this.mapData[this.zoom].setFoliageLight(imageX, imageY, foliageLight);
                } else {
                    foliageLight = this.mapData[this.zoom].getFoliageLight(imageX, imageY);
                }
                if (foliageLight == 0) {
                    foliageColor = 0;
                } else if (foliageLight != 255) {
                    foliageColor = this.colorManager.colorMultiplier(foliageColor, foliageLight);
                }
            }
        }
        if (seafloorHeight > 0) {
            color24 = seafloorColor;
            if (foliageColor != 0 && foliageHeight <= surfaceHeight) {
                color24 = this.colorManager.colorAdder(foliageColor, color24);
            }
            if (transparentColor != 0 && transparentHeight <= surfaceHeight) {
                color24 = this.colorManager.colorAdder(transparentColor, color24);
            }
            color24 = this.colorManager.colorAdder(surfaceColor, color24);
        } else {
            color24 = surfaceColor;
        }
        if (foliageColor != 0 && foliageHeight > surfaceHeight) {
            color24 = this.colorManager.colorAdder(foliageColor, color24);
        }
        if (transparentColor != 0 && transparentHeight > surfaceHeight) {
            color24 = this.colorManager.colorAdder(transparentColor, color24);
        }
        if (this.options.biomeOverlay == 2) {
            int bc = 0;
            if (biomeID >= 0) {
                bc = BiomeRepository.getBiomeColor((int)biomeID);
            }
            bc = 0x7F000000 | bc;
            color24 = this.colorManager.colorAdder(bc, color24);
        }
        color24 = this.doSlimeAndGrid(color24, startX + imageX, startZ + imageY);
        return color24;
    }
}

