/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.vmfixes.mixin;

import com.mamiyaotaru.voxelmap.ColorManager;
import com.mamiyaotaru.voxelmap.interfaces.AbstractMapData;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.ImageUtils;
import com.mamiyaotaru.voxelmap.util.MutableBlockPos;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.HashSet;
import mod.acgaming.vmfixes.VMFixes;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ColorManager.class})
public abstract class ColorManagerMixin {
    @Shadow
    Minecraft game;
    @Shadow
    private boolean optifineInstalled;
    @Shadow
    private HashSet<Integer> biomeTintsAvailable;
    @Shadow
    private HashMap<Integer, int[][]> blockTintTables;
    @Shadow
    private int sizeOfBiomeArray;

    @Overwrite(remap=false)
    public int getBiomeTint(AbstractMapData mapData, World world, IBlockState blockState, int blockStateID, MutableBlockPos blockPos, MutableBlockPos loopBlockPos, int startX, int startZ) {
        Chunk chunk = world.func_175726_f((BlockPos)blockPos);
        boolean live = chunk.func_177410_o();
        int tint = -2;
        if (this.optifineInstalled || this.biomeTintsAvailable.contains(blockStateID)) {
            try {
                int[][] tints = this.blockTintTables.get(blockStateID);
                if (tints != null) {
                    int r = 0;
                    int g = 0;
                    int b = 0;
                    for (int t = blockPos.func_177958_n() - 1; t <= blockPos.func_177958_n() + 1; ++t) {
                        for (int s = blockPos.func_177952_p() - 1; s <= blockPos.func_177952_p() + 1; ++s) {
                            int dataX = t - startX;
                            int dataZ = s - startZ;
                            dataX = Math.max(dataX, 0);
                            dataX = Math.min(dataX, mapData.getWidth() - 1);
                            dataZ = Math.max(dataZ, 0);
                            int biomeID = mapData.getBiomeID(dataX, dataZ = Math.min(dataZ, mapData.getHeight() - 1));
                            if (biomeID == -1) {
                                biomeID = 1;
                            }
                            int biomeTint = tints[biomeID][loopBlockPos.func_177956_o() / 8];
                            r += (biomeTint & 0xFF0000) >> 16;
                            g += (biomeTint & 0xFF00) >> 8;
                            b += biomeTint & 0xFF;
                        }
                    }
                    tint = 0xFF000000 | (r / 9 & 0xFF) << 16 | (g / 9 & 0xFF) << 8 | b / 9 & 0xFF;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tint == -2) {
            tint = this.getBuiltInBiomeTint(mapData, world, blockState, blockStateID, blockPos, loopBlockPos, startX, startZ, live);
        }
        return tint;
    }

    @Overwrite(remap=false)
    public final BufferedImage getBlockImage(IBlockState blockState, ItemStack stack, World world) {
        try {
            BufferedImage blockImage = null;
            if (GLUtils.fboEnabled) {
                IBakedModel model = this.game.func_175599_af().func_184393_a(stack, world, null);
                this.drawModel(1.0f, 2, EnumFacing.EAST, blockState, model, stack);
                blockImage = ImageUtils.createBufferedImageFromGLID((int)GLUtils.fboTextureID);
                blockImage = ImageUtils.trimCentered((BufferedImage)blockImage);
            }
            return blockImage;
        }
        catch (Exception e) {
            VMFixes.LOGGER.warn("Error getting block armor image for " + Block.func_149682_b((Block)blockState.func_177230_c()) + "," + blockState.func_177230_c().func_176201_c(blockState) + ": " + e.getLocalizedMessage());
            e.printStackTrace();
            return null;
        }
    }

    @Shadow
    protected abstract void drawModel(float var1, int var2, EnumFacing var3, IBlockState var4, IBakedModel var5, ItemStack var6);

    @Shadow
    protected abstract int getColorForTerrainSprite(IBlockState var1, BlockRendererDispatcher var2);

    @Shadow
    protected abstract int getBuiltInBiomeTint(AbstractMapData var1, World var2, IBlockState var3, int var4, MutableBlockPos var5, MutableBlockPos var6, int var7, int var8, boolean var9);

    @Overwrite(remap=false)
    private void createTintTable(IBlockState blockState, MutableBlockPos loopBlockPos) {
    }

    @Overwrite(remap=false)
    private int tintFromFakePlacedBlock(IBlockState blockState, MutableBlockPos loopBlockPos, byte biomeID) {
        return -1;
    }

    @Overwrite(remap=false)
    private int getColorForBlockPosBlockStateAndFacing(BlockPos blockPos, IBlockState blockState, EnumFacing facing) {
        try {
            EnumBlockRenderType blockRenderType = blockState.func_185901_i();
            BlockRendererDispatcher blockRendererDispatcher = this.game.func_175602_ab();
            if (blockRenderType == EnumBlockRenderType.LIQUID) {
                return this.getColorForTerrainSprite(blockState, blockRendererDispatcher);
            }
            blockState = blockState.func_177230_c().hasTileEntity(blockState) ? blockState.func_177230_c().func_176223_P() : blockState.func_185899_b((IBlockAccess)this.game.field_71441_e, blockPos);
            TextureAtlasSprite icon = ((BakedQuad)blockRendererDispatcher.func_184389_a(blockState).func_188616_a(blockState, facing, 0L).get(0)).func_187508_a();
            return this.getColorForIcon(icon);
        }
        catch (Exception e) {
            MapColor mapColor = blockState.func_185904_a().func_151565_r();
            int index = mapColor.field_76290_q;
            int color = mapColor.func_151643_b(index);
            return color;
        }
    }

    @Overwrite(remap=false)
    private int getColorForIcon(TextureAtlasSprite icon) {
        int color = 0;
        try {
            BufferedImage iconBuff = VMFixes.getBufferedImage(icon);
            if (iconBuff == null) {
                return color;
            }
            Image singlePixel = iconBuff.getScaledInstance(1, 1, 4);
            BufferedImage singlePixelBuff = new BufferedImage(1, 1, iconBuff.getType());
            Graphics2D gfx = singlePixelBuff.createGraphics();
            gfx.drawImage(singlePixel, 0, 0, null);
            gfx.dispose();
            color = singlePixelBuff.getRGB(0, 0);
        }
        catch (Exception e) {
            VMFixes.LOGGER.warn("Error getting color from TextureAtlasSprite " + icon);
        }
        return color;
    }

    @Overwrite(remap=false)
    private void loadTexturePackTerrainImage() {
    }
}

