/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.jei.world_transmute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.WorldTransmutations;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class WorldTransmuteEntry
implements IRecipeWrapper {
    private ItemStack inputItem = ItemStack.field_190927_a;
    private ItemStack leftOutputItem = ItemStack.field_190927_a;
    private ItemStack rightOutputItem = ItemStack.field_190927_a;
    private FluidStack inputFluid;
    private FluidStack leftOutputFluid;
    private FluidStack rightOutputFluid;

    public WorldTransmuteEntry(WorldTransmutations.Entry transmutationEntry) {
        Block inputBlock = transmutationEntry.input.func_177230_c();
        IBlockState leftOutput = (IBlockState)transmutationEntry.outputs.getLeft();
        IBlockState rightOutput = (IBlockState)transmutationEntry.outputs.getRight();
        this.inputFluid = this.fluidFromBlock(inputBlock);
        if (this.inputFluid == null) {
            this.inputItem = this.itemFromBlock(inputBlock, transmutationEntry.input);
        }
        if (leftOutput != null) {
            this.leftOutputFluid = this.fluidFromBlock(leftOutput.func_177230_c());
            if (this.leftOutputFluid == null) {
                this.leftOutputItem = this.itemFromBlock(leftOutput.func_177230_c(), leftOutput);
            }
        }
        if (rightOutput != null) {
            this.rightOutputFluid = this.fluidFromBlock(rightOutput.func_177230_c());
            if (this.rightOutputFluid == null) {
                this.rightOutputItem = this.itemFromBlock(rightOutput.func_177230_c(), rightOutput);
            }
        }
    }

    private FluidStack fluidFromBlock(Block block) {
        if (block == Blocks.field_150355_j) {
            return new FluidStack(FluidRegistry.WATER, 1000);
        }
        if (block == Blocks.field_150353_l) {
            return new FluidStack(FluidRegistry.LAVA, 1000);
        }
        return null;
    }

    private ItemStack itemFromBlock(Block block, IBlockState state) {
        try {
            return block.getPickBlock(state, null, null, null, null);
        }
        catch (Exception e) {
            return ItemHelper.stateToStack(state, 1);
        }
    }

    public boolean isRenderable() {
        boolean hasInput = this.inputFluid != null || !this.inputItem.func_190926_b();
        boolean hasLeftOutput = this.leftOutputFluid != null || !this.leftOutputItem.func_190926_b();
        boolean hasRightOutput = this.rightOutputFluid != null || !this.rightOutputItem.func_190926_b();
        return hasInput && (hasLeftOutput || hasRightOutput);
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        if (this.inputFluid != null) {
            ingredients.setInput(FluidStack.class, (Object)this.inputFluid);
        } else if (!this.inputItem.func_190926_b()) {
            ingredients.setInput(ItemStack.class, (Object)this.inputItem);
        }
        ArrayList<FluidStack> fluidOutputs = new ArrayList<FluidStack>();
        if (this.leftOutputFluid != null) {
            fluidOutputs.add(this.leftOutputFluid);
        }
        if (this.rightOutputFluid != null) {
            fluidOutputs.add(this.rightOutputFluid);
        }
        if (!fluidOutputs.isEmpty()) {
            ingredients.setOutputs(FluidStack.class, fluidOutputs);
        }
        ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
        if (!this.leftOutputItem.func_190926_b()) {
            outputList.add(this.leftOutputItem);
        }
        if (!this.rightOutputItem.func_190926_b()) {
            outputList.add(this.rightOutputItem);
        }
        if (!outputList.isEmpty()) {
            ingredients.setOutputs(ItemStack.class, outputList);
        }
    }

    @Nonnull
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (mouseX > 67 && mouseX < 107 && mouseY > 18 && mouseY < 38) {
            return Collections.singletonList(I18n.func_135052_a((String)"pe.nei.worldtransmute.description", (Object[])new Object[0]));
        }
        return Collections.emptyList();
    }

    public ItemStack getInputItem() {
        return this.inputItem;
    }

    public FluidStack getInputFluid() {
        return this.inputFluid;
    }
}

