/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.tiles;

import javax.annotation.Nonnull;
import moze_intel.projecte.api.tile.IEmcAcceptor;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.tiles.TileEmc;
import moze_intel.projecte.gameObjs.tiles.WrappedItemHandler;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.NBTWhitelist;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class CondenserTile
extends TileEmc
implements IEmcAcceptor {
    protected final ItemStackHandler inputInventory = this.createInput();
    private final ItemStackHandler outputInventory = this.createOutput();
    private final IItemHandler automationInventory = this.createAutomationInventory();
    private final ItemStackHandler lock = new TileEmc.StackHandler(this, 1);
    private boolean isAcceptingEmc;
    private int ticksSinceSync;
    public long displayEmc;
    public float lidAngle;
    public float prevLidAngle;
    public int numPlayersUsing;
    public long requiredEmc;

    public ItemStackHandler getLock() {
        return this.lock;
    }

    public ItemStackHandler getInput() {
        return this.inputInventory;
    }

    public ItemStackHandler getOutput() {
        return this.outputInventory;
    }

    protected ItemStackHandler createInput() {
        return new TileEmc.StackHandler(this, 91);
    }

    protected ItemStackHandler createOutput() {
        return this.inputInventory;
    }

    protected IItemHandler createAutomationInventory() {
        return new WrappedItemHandler((IItemHandlerModifiable)this.inputInventory, WrappedItemHandler.WriteMode.IN_OUT){

            @Override
            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return SlotPredicates.HAS_EMC.test(stack) && !CondenserTile.this.isStackEqualToLock(stack) ? super.insertItem(slot, stack, simulate) : stack;
            }

            @Override
            public ItemStack extractItem(int slot, int max, boolean simulate) {
                if (!this.getStackInSlot(slot).func_190926_b() && CondenserTile.this.isStackEqualToLock(this.getStackInSlot(slot))) {
                    return super.extractItem(slot, max, simulate);
                }
                return ItemStack.field_190927_a;
            }
        };
    }

    public boolean hasCapability(@Nonnull Capability<?> cap, EnumFacing side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(cap, side);
    }

    public <T> T getCapability(@Nonnull Capability<T> cap, EnumFacing side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.automationInventory);
        }
        return (T)super.getCapability(cap, side);
    }

    public void func_73660_a() {
        this.updateChest();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        this.checkLockAndUpdate();
        this.displayEmc = this.getStoredEmc();
        if (!this.lock.getStackInSlot(0).func_190926_b() && this.requiredEmc != 0L) {
            this.condense();
        }
    }

    private void checkLockAndUpdate() {
        if (this.lock.getStackInSlot(0).func_190926_b()) {
            this.displayEmc = 0L;
            this.requiredEmc = 0L;
            this.isAcceptingEmc = false;
            return;
        }
        if (EMCHelper.doesItemHaveEmc(this.lock.getStackInSlot(0))) {
            long lockEmc = EMCHelper.getEmcValue(this.lock.getStackInSlot(0));
            if (this.requiredEmc != lockEmc) {
                this.requiredEmc = lockEmc;
                this.isAcceptingEmc = true;
            }
        } else {
            this.lock.setStackInSlot(0, ItemStack.field_190927_a);
            this.displayEmc = 0L;
            this.requiredEmc = 0L;
            this.isAcceptingEmc = false;
        }
    }

    protected void condense() {
        for (int i = 0; i < this.inputInventory.getSlots(); ++i) {
            ItemStack stack = this.inputInventory.getStackInSlot(i);
            if (stack.func_190926_b() || this.isStackEqualToLock(stack)) continue;
            this.inputInventory.extractItem(i, 1, false);
            this.addEMC(EMCHelper.getEmcSellValue(stack));
            break;
        }
        if (this.getStoredEmc() >= this.requiredEmc && this.hasSpace()) {
            this.removeEMC(this.requiredEmc);
            this.pushStack();
        }
    }

    protected void pushStack() {
        ItemStack lockCopy = this.lock.getStackInSlot(0).func_77946_l();
        if (lockCopy.func_77942_o() && !NBTWhitelist.shouldDupeWithNBT(lockCopy)) {
            lockCopy.func_77982_d(new NBTTagCompound());
        }
        ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputInventory, (ItemStack)lockCopy, (boolean)false);
    }

    protected boolean hasSpace() {
        for (int i = 0; i < this.outputInventory.getSlots(); ++i) {
            ItemStack stack = this.outputInventory.getStackInSlot(i);
            if (stack.func_190926_b()) {
                return true;
            }
            if (!this.isStackEqualToLock(stack) || stack.func_190916_E() >= stack.func_77976_d()) continue;
            return true;
        }
        return false;
    }

    public boolean isStackEqualToLock(ItemStack stack) {
        if (this.lock.getStackInSlot(0).func_190926_b()) {
            return false;
        }
        if (NBTWhitelist.shouldDupeWithNBT(this.lock.getStackInSlot(0))) {
            return ItemHelper.areItemStacksEqual(this.lock.getStackInSlot(0), stack);
        }
        return ItemHelper.areItemStacksEqualIgnoreNBT(this.lock.getStackInSlot(0), stack);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputInventory.deserializeNBT(nbt.func_74775_l("Input"));
        this.lock.deserializeNBT(nbt.func_74775_l("LockSlot"));
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74782_a("Input", (NBTBase)this.inputInventory.serializeNBT());
        nbt.func_74782_a("LockSlot", (NBTBase)this.lock.serializeNBT());
        return nbt;
    }

    private void updateChest() {
        if (++this.ticksSinceSync % 20 * 4 == 0) {
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
        }
        this.prevLidAngle = this.lidAngle;
        float angleIncrement = 0.1f;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float var8 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += angleIncrement) : (this.lidAngle -= angleIncrement);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < 0.5f && var8 >= 0.5f) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int number, int arg) {
        if (number == 1) {
            this.numPlayersUsing = arg;
            return true;
        }
        return super.func_145842_c(number, arg);
    }

    @Override
    public long acceptEMC(@Nonnull EnumFacing side, long toAccept) {
        if (this.isAcceptingEmc) {
            long toAdd = Math.min(this.maximumEMC - this.currentEMC, toAccept);
            this.addEMC(toAdd);
            return toAdd;
        }
        return 0L;
    }
}

