/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.PESounds;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.api.item.IProjectileShooter;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntitySWRGProjectile;
import moze_intel.projecte.gameObjs.items.IFlightProvider;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.handlers.InternalAbilities;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class SWRG
extends ItemPE
implements IBauble,
IPedestalItem,
IFlightProvider,
IProjectileShooter {
    public SWRG() {
        this.func_77655_b("swrg");
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.setNoRepair();
    }

    private void tick(ItemStack stack, EntityPlayer player) {
        player.field_70143_R = 0.0f;
        if (ItemHelper.getOrCreateCompound(stack).func_74762_e("Mode") > 1) {
            WorldHelper.repelEntitiesInAABBFromPoint(player.func_130014_f_(), player.func_174813_aQ().func_186662_g(5.0), player.field_70165_t, player.field_70163_u, player.field_70161_v, true);
        }
        if (player.func_130014_f_().field_72995_K) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        if (SWRG.getEmc(stack) == 0L && !SWRG.consumeFuel(player, stack, 64L, false)) {
            if (stack.func_77978_p().func_74762_e("Mode") > 0) {
                this.changeMode(player, stack, 0);
            }
            if (playerMP.field_71075_bZ.field_75101_c) {
                ((InternalAbilities)playerMP.getCapability(InternalAbilities.CAPABILITY, null)).disableSwrgFlightOverride();
            }
            return;
        }
        if (!playerMP.field_71075_bZ.field_75101_c) {
            ((InternalAbilities)playerMP.getCapability(InternalAbilities.CAPABILITY, null)).enableSwrgFlightOverride();
        }
        if (playerMP.field_71075_bZ.field_75100_b) {
            if (!this.isFlyingEnabled(stack)) {
                this.changeMode(player, stack, stack.func_77978_p().func_74762_e("Mode") == 0 ? 1 : 3);
            }
        } else if (this.isFlyingEnabled(stack)) {
            this.changeMode(player, stack, stack.func_77978_p().func_74762_e("Mode") == 1 ? 0 : 2);
        }
        float toRemove = 0.0f;
        if (playerMP.field_71075_bZ.field_75100_b) {
            toRemove = 0.32f;
        }
        if (stack.func_77978_p().func_74762_e("Mode") == 2) {
            toRemove = 0.32f;
        } else if (stack.func_77978_p().func_74762_e("Mode") == 3) {
            toRemove = 0.64f;
        }
        SWRG.removeEmc(stack, EMCHelper.removeFractionalEMC(stack, toRemove));
    }

    private boolean isFlyingEnabled(ItemStack stack) {
        return stack.func_77978_p().func_74762_e("Mode") == 1 || stack.func_77978_p().func_74762_e("Mode") == 3;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int invSlot, boolean isHeldItem) {
        if (invSlot > 8 || !(entity instanceof EntityPlayer)) {
            return;
        }
        this.tick(stack, (EntityPlayer)entity);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            int newMode = 0;
            switch (ItemHelper.getOrCreateCompound(stack).func_74762_e("Mode")) {
                case 0: {
                    newMode = 2;
                    break;
                }
                case 1: {
                    newMode = 3;
                    break;
                }
                case 2: {
                    newMode = 0;
                    break;
                }
                case 3: {
                    newMode = 1;
                }
            }
            this.changeMode(player, stack, newMode);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public void changeMode(EntityPlayer player, ItemStack stack, int mode) {
        int oldMode = ItemHelper.getOrCreateCompound(stack).func_74762_e("Mode");
        if (mode == oldMode) {
            return;
        }
        ItemHelper.getOrCreateCompound(stack).func_74768_a("Mode", mode);
        if (player == null) {
            return;
        }
        if (mode == 0 || oldMode == 3) {
            player.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.UNCHARGE, SoundCategory.PLAYERS, 0.8f, 1.0f);
        } else if (oldMode == 0 || mode == 3) {
            player.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.HEAL, SoundCategory.PLAYERS, 0.8f, 1.0f);
        }
    }

    @Override
    public boolean canProvideFlight(ItemStack stack, EntityPlayerMP player) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.RING;
    }

    @Optional.Method(modid="baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase ent) {
        if (!(ent instanceof EntityPlayer)) {
            return;
        }
        this.tick(stack, (EntityPlayer)ent);
    }

    @Optional.Method(modid="baubles")
    public void onEquipped(ItemStack stack, EntityLivingBase player) {
    }

    @Optional.Method(modid="baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="baubles")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        if (!world.field_72995_K && ProjectEConfig.pedestalCooldown.swrgPedCooldown != -1) {
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof DMPedestalTile)) {
                return;
            }
            DMPedestalTile tile = (DMPedestalTile)te;
            if (tile.getActivityCooldown() <= 0) {
                List list = world.func_72872_a(EntityLiving.class, tile.getEffectBounds());
                for (EntityLiving living : list) {
                    if (living instanceof EntityTameable && ((EntityTameable)living).func_70909_n()) continue;
                    world.func_72942_c((Entity)new EntityLightningBolt(world, living.field_70165_t, living.field_70163_u, living.field_70161_v, false));
                }
                tile.setActivityCooldown(ProjectEConfig.pedestalCooldown.swrgPedCooldown);
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public List<String> getPedestalDescription() {
        ArrayList<String> list = new ArrayList<String>();
        if (ProjectEConfig.pedestalCooldown.swrgPedCooldown != -1) {
            list.add(TextFormatting.BLUE + I18n.func_135052_a((String)"pe.swrg.pedestal1", (Object[])new Object[0]));
            list.add(TextFormatting.BLUE + I18n.func_135052_a((String)"pe.swrg.pedestal2", (Object[])new Object[]{MathUtils.tickToSecFormatted(ProjectEConfig.pedestalCooldown.swrgPedCooldown)}));
        }
        return list;
    }

    @Override
    public boolean shootProjectile(@Nonnull EntityPlayer player, @Nonnull ItemStack stack, @Nullable EnumHand hand) {
        EntitySWRGProjectile projectile = new EntitySWRGProjectile(player.field_70170_p, player, false);
        projectile.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
        player.field_70170_p.func_72838_d((Entity)projectile);
        return true;
    }
}

