/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.items.OreDictNames;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.IntCircuitRecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.material.type.FluidMaterial;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.GTUtility;
import gregtech.common.items.MetaItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;

public class WireRecipeHandler {
    public static final Map<FluidMaterial, Integer> INSULATION_MATERIALS = new HashMap<FluidMaterial, Integer>();
    private static final OrePrefix[] WIRE_DOUBLING_ORDER;
    private static final OrePrefix[] CABLE_DOUBLING_ORDER;

    public static void register() {
        OrePrefix.wireGtSingle.addProcessingHandler(IngotMaterial.class, WireRecipeHandler::processWireSingle);
        for (OrePrefix wirePrefix : WIRE_DOUBLING_ORDER) {
            wirePrefix.addProcessingHandler(IngotMaterial.class, WireRecipeHandler::generateWireRecipe);
            wirePrefix.addProcessingHandler(Material.class, WireRecipeHandler::generateWireCombiningRecipe);
        }
        for (OrePrefix cablePrefix : CABLE_DOUBLING_ORDER) {
            cablePrefix.addProcessingHandler(Material.class, WireRecipeHandler::generateCableCombiningRecipe);
        }
    }

    public static void processWireSingle(OrePrefix wirePrefix, IngotMaterial material) {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_WIRE)).outputs(OreDictUnifier.get(OrePrefix.wireGtSingle, material, 2))).duration((int)material.getAverageMass() * 2)).EUt(6 * WireRecipeHandler.getVoltageMultiplier(material))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.WIREMILL_RECIPES.recipeBuilder().input(OrePrefix.ingot, material)).outputs(OreDictUnifier.get(OrePrefix.wireGtSingle, material, 2))).duration((int)material.getAverageMass())).EUt(WireRecipeHandler.getVoltageMultiplier(material))).buildAndRegister();
        if (!material.hasFlag(DustMaterial.MatFlags.NO_WORKING)) {
            ModHandler.addShapedRecipe(String.format("%s_wire_single", material), OreDictUnifier.get(OrePrefix.wireGtSingle, material), "Xx", Character.valueOf('X'), new UnificationEntry(OrePrefix.plate, material));
        }
    }

    public static void generateWireRecipe(OrePrefix wirePrefix, IngotMaterial material) {
        int cableAmount = (int)(wirePrefix.materialAmount * 2L / 3628800L);
        OrePrefix cablePrefix = OrePrefix.valueOf("cable" + wirePrefix.name().substring(4));
        ItemStack cableStack = OreDictUnifier.get(cablePrefix, material);
        if (material.cableProperties == null) {
            return;
        }
        if (WireRecipeHandler.isPaperInsulatedCable(material) && cableAmount <= 7) {
            Object[] ingredients = new Object[2 + cableAmount];
            ingredients[0] = new UnificationEntry(wirePrefix, material);
            ingredients[ingredients.length - 1] = OreDictNames.string;
            for (int i = 1; i < ingredients.length - 1; ++i) {
                ingredients[i] = new ItemStack(Blocks.field_150404_cg, 1, EnumDyeColor.BLACK.func_176765_a());
            }
            ModHandler.addShapelessRecipe(String.format("%s_cable_%d", material, cableAmount), cableStack, ingredients);
        }
        if (WireRecipeHandler.isPaperInsulatedCable(material)) {
            ItemStack carpetStack = new ItemStack(Blocks.field_150404_cg, cableAmount, EnumDyeColor.BLACK.func_176765_a());
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PACKER_RECIPES.recipeBuilder().input(wirePrefix, material)).inputs(carpetStack)).outputs(cableStack)).duration(100)).EUt(8)).buildAndRegister();
        }
        for (FluidMaterial insulationMaterial : INSULATION_MATERIALS.keySet()) {
            byte cableTier = GTUtility.getTierByVoltage(material.cableProperties.voltage);
            int materialAmount = WireRecipeHandler.getMaterialAmount(cableTier, INSULATION_MATERIALS.get(insulationMaterial));
            if (materialAmount == -1) continue;
            if (wirePrefix != OrePrefix.wireGtSingle) {
                ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.wireGtSingle, material, cableAmount)).circuitMeta(24 + ArrayUtils.indexOf((Object[])WIRE_DOUBLING_ORDER, (Object)((Object)wirePrefix))).fluidInputs(insulationMaterial.getFluid(materialAmount * cableAmount))).outputs(cableStack)).duration(150)).EUt(8)).buildAndRegister();
            }
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(wirePrefix, material)).circuitMeta(24).fluidInputs(insulationMaterial.getFluid(materialAmount * cableAmount))).outputs(cableStack)).duration(150)).EUt(8)).buildAndRegister();
        }
    }

    public static void generateWireCombiningRecipe(OrePrefix wirePrefix, Material material) {
        int wireIndex = ArrayUtils.indexOf((Object[])WIRE_DOUBLING_ORDER, (Object)((Object)wirePrefix));
        if (wireIndex < WIRE_DOUBLING_ORDER.length - 1) {
            ModHandler.addShapelessRecipe(String.format("%s_wire_%s_doubling", new Object[]{material, wirePrefix}), OreDictUnifier.get(WIRE_DOUBLING_ORDER[wireIndex + 1], material), new UnificationEntry(wirePrefix, material), new UnificationEntry(wirePrefix, material));
        }
        if (wireIndex > 0) {
            ModHandler.addShapelessRecipe(String.format("%s_wire_%s_splitting", new Object[]{material, wirePrefix}), OreDictUnifier.get(WIRE_DOUBLING_ORDER[wireIndex - 1], material, 2), new UnificationEntry(wirePrefix, material));
        }
        if (wireIndex < 3) {
            ModHandler.addShapelessRecipe(String.format("%s_wire_%s_quadrupling", new Object[]{material, wirePrefix}), OreDictUnifier.get(WIRE_DOUBLING_ORDER[wireIndex + 2], material), new UnificationEntry(wirePrefix, material), new UnificationEntry(wirePrefix, material), new UnificationEntry(wirePrefix, material), new UnificationEntry(wirePrefix, material));
        }
    }

    public static void generateCableCombiningRecipe(OrePrefix cablePrefix, Material material) {
        int cableIndex = ArrayUtils.indexOf((Object[])CABLE_DOUBLING_ORDER, (Object)((Object)cablePrefix));
        if (cableIndex < CABLE_DOUBLING_ORDER.length - 1) {
            ModHandler.addShapelessRecipe(String.format("%s_cable_%s_doubling", new Object[]{material, cablePrefix}), OreDictUnifier.get(CABLE_DOUBLING_ORDER[cableIndex + 1], material), new UnificationEntry(cablePrefix, material), new UnificationEntry(cablePrefix, material));
        }
        if (cableIndex > 0) {
            ModHandler.addShapelessRecipe(String.format("%s_cable_%s_splitting", new Object[]{material, cablePrefix}), OreDictUnifier.get(CABLE_DOUBLING_ORDER[cableIndex - 1], material, 2), new UnificationEntry(cablePrefix, material));
        }
        if (cableIndex < 3) {
            ModHandler.addShapelessRecipe(String.format("%s_cable_%s_quadrupling", new Object[]{material, cablePrefix}), OreDictUnifier.get(CABLE_DOUBLING_ORDER[cableIndex + 2], material), new UnificationEntry(cablePrefix, material), new UnificationEntry(cablePrefix, material), new UnificationEntry(cablePrefix, material), new UnificationEntry(cablePrefix, material));
        }
    }

    private static int getMaterialAmount(int cableTier, int insulationTier) {
        if (cableTier > insulationTier) {
            return -1;
        }
        int insulationDiscount = (insulationTier - cableTier) / 2;
        return Math.max(36, 144 / (1 + insulationDiscount));
    }

    public static boolean isPaperInsulatedCable(IngotMaterial material) {
        return material.cableProperties != null && GTUtility.getTierByVoltage(material.cableProperties.voltage) <= 1;
    }

    private static int getVoltageMultiplier(Material material) {
        return material instanceof IngotMaterial && ((IngotMaterial)material).blastFurnaceTemperature >= 2800 ? 32 : 8;
    }

    static {
        INSULATION_MATERIALS.put(Materials.Rubber, 3);
        INSULATION_MATERIALS.put(Materials.StyreneButadieneRubber, 6);
        INSULATION_MATERIALS.put(Materials.SiliconeRubber, 9);
        WIRE_DOUBLING_ORDER = new OrePrefix[]{OrePrefix.wireGtSingle, OrePrefix.wireGtDouble, OrePrefix.wireGtQuadruple, OrePrefix.wireGtOctal, OrePrefix.wireGtHex};
        CABLE_DOUBLING_ORDER = new OrePrefix[]{OrePrefix.cableGtSingle, OrePrefix.cableGtDouble, OrePrefix.cableGtQuadruple, OrePrefix.cableGtOctal, OrePrefix.cableGtHex};
    }
}

