/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.recipe.primitive;

import com.google.common.collect.ImmutableList;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public class OreByProduct
implements IRecipeWrapper {
    private static final ImmutableList<OrePrefix> ORES = ImmutableList.of((Object)((Object)OrePrefix.ore), (Object)((Object)OrePrefix.oreBasalt), (Object)((Object)OrePrefix.oreBlackgranite), (Object)((Object)OrePrefix.oreEndstone), (Object)((Object)OrePrefix.oreGravel), (Object)((Object)OrePrefix.oreMarble), (Object)((Object)OrePrefix.oreNetherrack), (Object)((Object)OrePrefix.oreRedgranite), (Object)((Object)OrePrefix.oreSand));
    private final List<List<ItemStack>> matchingInputs = new ArrayList<List<ItemStack>>();
    private final List<ItemStack> oreProcessingSteps = new ArrayList<ItemStack>();
    private final List<ItemStack> outputs = new ArrayList<ItemStack>();
    private final DustMaterial material;
    private final List<ItemStack> oreIngredients;
    private final List<ItemStack> byProductIngredients;

    public OreByProduct(DustMaterial material) {
        this.material = material;
        this.oreIngredients = new ArrayList<ItemStack>();
        for (OrePrefix ore : ORES) {
            this.oreIngredients.add(OreDictUnifier.get(ore, material));
        }
        this.byProductIngredients = new ArrayList<ItemStack>();
        for (Material mat : material.oreByProducts) {
            this.byProductIngredients.add(OreDictUnifier.get(OrePrefix.dust, mat));
        }
        this.oreProcessingSteps.add(OreDictUnifier.get(OrePrefix.crushed, material));
        this.oreProcessingSteps.add(OreDictUnifier.get(OrePrefix.crushedPurified, material));
        this.oreProcessingSteps.add(OreDictUnifier.get(OrePrefix.crushedCentrifuged, material));
        this.oreProcessingSteps.add(OreDictUnifier.get(OrePrefix.dustImpure, material));
        this.oreProcessingSteps.add(OreDictUnifier.get(OrePrefix.dustPure, material));
        this.oreProcessingSteps.add(OreDictUnifier.get(OrePrefix.dust, material));
        ArrayList<ItemStack> inputOres = new ArrayList<ItemStack>();
        inputOres.addAll(this.oreIngredients);
        this.matchingInputs.add(inputOres);
        for (ItemStack stack : this.oreProcessingSteps) {
            ArrayList<ItemStack> stepStack = new ArrayList<ItemStack>();
            stepStack.add(stack);
            this.matchingInputs.add(stepStack);
        }
        this.outputs.addAll(this.byProductIngredients);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.matchingInputs);
        ingredients.setOutputs(ItemStack.class, this.outputs);
    }

    public boolean hasByProducts() {
        return !this.outputs.isEmpty();
    }

    public void addTooltip(int slotIndex, boolean input, Object ingredient, List<String> tooltip) {
        switch (slotIndex) {
            case 0: {
                this.addOreTooltip(tooltip, 0, RecipeMaps.MACERATOR_RECIPES.getLocalizedName(), false);
                break;
            }
            case 1: {
                this.addOreTooltip(tooltip, 0, RecipeMaps.ORE_WASHER_RECIPES.getLocalizedName(), false);
                this.addOreTooltip(tooltip, 0, RecipeMaps.MACERATOR_RECIPES.getLocalizedName(), false);
                if (this.material.washedIn != null) {
                    this.addOreTooltip(tooltip, 3, RecipeMaps.CHEMICAL_BATH_RECIPES.getLocalizedName(), false);
                }
                this.addOreTooltip(tooltip, 0, RecipeMaps.THERMAL_CENTRIFUGE_RECIPES.getLocalizedName(), false);
                break;
            }
            case 2: {
                this.addOreTooltip(tooltip, 1, RecipeMaps.MACERATOR_RECIPES.getLocalizedName(), false);
                this.addOreTooltip(tooltip, 1, RecipeMaps.THERMAL_CENTRIFUGE_RECIPES.getLocalizedName(), false);
                break;
            }
            case 3: {
                this.addOreTooltip(tooltip, 2, RecipeMaps.MACERATOR_RECIPES.getLocalizedName(), false);
                break;
            }
            case 4: {
                this.addOreTooltip(tooltip, 2, RecipeMaps.CENTRIFUGE_RECIPES.getLocalizedName(), false);
                break;
            }
            case 5: {
                this.addOreTooltip(tooltip, 1, RecipeMaps.CENTRIFUGE_RECIPES.getLocalizedName(), false);
                break;
            }
            case 7: {
                this.addOreTooltip(tooltip, 0, RecipeMaps.MACERATOR_RECIPES.getLocalizedName(), true);
                this.addOreTooltip(tooltip, 1, RecipeMaps.ORE_WASHER_RECIPES.getLocalizedName(), true);
                this.addOreTooltip(tooltip, 1, RecipeMaps.THERMAL_CENTRIFUGE_RECIPES.getLocalizedName(), true);
                if (this.material.washedIn == null || this.material.oreByProducts.size() != 1) break;
                this.addOreTooltip(tooltip, 1, RecipeMaps.CHEMICAL_BATH_RECIPES.getLocalizedName(), true);
                break;
            }
            case 8: {
                this.addOreTooltip(tooltip, 2, RecipeMaps.MACERATOR_RECIPES.getLocalizedName(), true);
                this.addOreTooltip(tooltip, 2, RecipeMaps.THERMAL_CENTRIFUGE_RECIPES.getLocalizedName(), true);
                this.addOreTooltip(tooltip, 5, RecipeMaps.CENTRIFUGE_RECIPES.getLocalizedName(), true);
                if (this.material.washedIn == null || this.material.oreByProducts.size() != 2) break;
                this.addOreTooltip(tooltip, 1, RecipeMaps.CHEMICAL_BATH_RECIPES.getLocalizedName(), true);
                break;
            }
            case 9: {
                this.addOreTooltip(tooltip, 3, RecipeMaps.MACERATOR_RECIPES.getLocalizedName(), true);
                this.addOreTooltip(tooltip, 4, RecipeMaps.CENTRIFUGE_RECIPES.getLocalizedName(), true);
                if (this.material.washedIn == null || this.material.oreByProducts.size() != 3) break;
                this.addOreTooltip(tooltip, 1, RecipeMaps.CHEMICAL_BATH_RECIPES.getLocalizedName(), true);
                break;
            }
            case 10: {
                if (this.material.washedIn != null) {
                    this.addOreTooltip(tooltip, 1, RecipeMaps.CHEMICAL_BATH_RECIPES.getLocalizedName(), true);
                    break;
                }
                tooltip.add(I18n.func_135052_a((String)"gregtech.jei.ore_by_product_not_obtainable", (Object[])new Object[0]));
                break;
            }
        }
    }

    public int getOutputCount() {
        return this.outputs.size();
    }

    public int getProcessingStepCount() {
        return this.oreProcessingSteps.size();
    }

    public void addOreTooltip(List<String> tooltip, int byproduct, String machine, boolean result) {
        Material byProductMaterial = GTUtility.selectItemInList(byproduct, this.material, this.material.oreByProducts, DustMaterial.class);
        if (!result) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.jei.ore_by_product_from_ore", (Object[])new Object[]{machine, byProductMaterial.getLocalizedName()}));
        } else {
            String oreType = byproduct == 0 ? this.oreIngredients.get(0).func_82833_r() : this.oreProcessingSteps.get(byproduct - 1).func_82833_r();
            tooltip.add(I18n.func_135052_a((String)"gregtech.jei.ore_by_product_from_machine", (Object[])new Object[]{oreType, machine}));
        }
    }
}

