/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.multiblock.infos;

import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.BlockWireCoil;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.integration.jei.multiblock.MultiblockInfoPage;
import gregtech.integration.jei.multiblock.MultiblockShapeInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class ElectricBlastFurnaceInfo
extends MultiblockInfoPage {
    @Override
    public MultiblockControllerBase getController() {
        return MetaTileEntities.ELECTRIC_BLAST_FURNACE;
    }

    @Override
    public List<MultiblockShapeInfo> getMatchingShapes() {
        ArrayList<MultiblockShapeInfo> shapeInfo = new ArrayList<MultiblockShapeInfo>();
        for (BlockWireCoil.CoilType coilType : BlockWireCoil.CoilType.values()) {
            shapeInfo.add(MultiblockShapeInfo.builder().aisle("IFX", "CCC", "CCC", "XXX").aisle("SXE", "C#C", "C#C", "XXX").aisle("ODX", "CCC", "CCC", "XXX").where('X', MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.INVAR_HEATPROOF)).where('C', MetaBlocks.WIRE_COIL.getState(coilType)).where('S', MetaTileEntities.ELECTRIC_BLAST_FURNACE, EnumFacing.WEST).where('E', MetaTileEntities.ENERGY_INPUT_HATCH[2], EnumFacing.EAST).where('I', MetaTileEntities.ITEM_IMPORT_BUS[1], EnumFacing.WEST).where('O', MetaTileEntities.ITEM_EXPORT_BUS[1], EnumFacing.WEST).where('F', MetaTileEntities.FLUID_IMPORT_HATCH[1], EnumFacing.NORTH).where('D', MetaTileEntities.FLUID_IMPORT_HATCH[1], EnumFacing.SOUTH).where('#', Blocks.field_150350_a.func_176223_P()).build());
        }
        return shapeInfo;
    }

    @Override
    public String[] getDescription() {
        return new String[]{I18n.func_135052_a((String)"gregtech.multiblock.electric_blast_furnace.description", (Object[])new Object[0])};
    }

    @Override
    protected void generateBlockTooltips() {
        super.generateBlockTooltips();
        ITextComponent tooltip = new TextComponentTranslation("gregtech.multiblock.preview.limit", new Object[]{10}).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA));
        this.addBlockTooltip(MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.INVAR_HEATPROOF), tooltip);
    }
}

