/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.multiblock;

import gregtech.api.GTValues;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.util.ItemStackHashStrategy;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.integration.jei.multiblock.MultiblockShapeInfo;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public abstract class MultiblockInfoPage {
    private final Hash.Strategy<ItemStack> strategy = ItemStackHashStrategy.comparingAllButCount();
    private Map<ItemStack, List<ITextComponent>> blockTooltips = new Object2ObjectOpenCustomHashMap(this.strategy);
    private static final ITextComponent defaultText = new TextComponentTranslation("gregtech.multiblock.preview.any_hatch", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN));

    public abstract MultiblockControllerBase getController();

    public abstract List<MultiblockShapeInfo> getMatchingShapes();

    public abstract String[] getDescription();

    public float getDefaultZoom() {
        return 1.0f;
    }

    public List<String> informationText() {
        return Stream.of("gregtech.multiblock.preview.tilt", "gregtech.multiblock.preview.zoom", "gregtech.multiblock.preview.pan", "gregtech.multiblock.preview.move", "gregtech.multiblock.preview.reset").map(x$0 -> I18n.func_135052_a((String)x$0, (Object[])new Object[0])).collect(Collectors.toList());
    }

    public Map<ItemStack, List<ITextComponent>> getBlockTooltipMap() {
        if (this.blockTooltips.size() == 0) {
            this.generateBlockTooltips();
        }
        return this.blockTooltips;
    }

    protected void generateBlockTooltips() {
        for (int i = 0; i < GTValues.V.length; ++i) {
            this.addBlockTooltip(MetaTileEntities.ITEM_EXPORT_BUS[i].getStackForm(), defaultText);
            this.addBlockTooltip(MetaTileEntities.ITEM_IMPORT_BUS[i].getStackForm(), defaultText);
            this.addBlockTooltip(MetaTileEntities.FLUID_EXPORT_HATCH[i].getStackForm(), defaultText);
            this.addBlockTooltip(MetaTileEntities.FLUID_IMPORT_HATCH[i].getStackForm(), defaultText);
        }
    }

    protected void addBlockTooltip(ItemStack itemStack, ITextComponent tooltip) {
        List tooltipList = this.blockTooltips.getOrDefault(itemStack, null);
        if (tooltipList == null) {
            ArrayList<ITextComponent> tooltipToAdd = new ArrayList<ITextComponent>();
            tooltipToAdd.add(tooltip);
            this.blockTooltips.put(itemStack, tooltipToAdd);
        } else {
            tooltipList.add(tooltip);
            this.blockTooltips.put(itemStack, tooltipList);
        }
    }
}

