/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.multiblock;

import gregtech.api.gui.GuiTextures;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.integration.jei.multiblock.MultiblockInfoRecipeWrapper;
import gregtech.integration.jei.multiblock.infos.CokeOvenInfo;
import gregtech.integration.jei.multiblock.infos.CrackerUnitInfo;
import gregtech.integration.jei.multiblock.infos.DieselEngineInfo;
import gregtech.integration.jei.multiblock.infos.DistillationTowerInfo;
import gregtech.integration.jei.multiblock.infos.ElectricBlastFurnaceInfo;
import gregtech.integration.jei.multiblock.infos.ImplosionCompressorInfo;
import gregtech.integration.jei.multiblock.infos.LargeBoilerInfo;
import gregtech.integration.jei.multiblock.infos.LargeTurbineInfo;
import gregtech.integration.jei.multiblock.infos.MultiSmelterInfo;
import gregtech.integration.jei.multiblock.infos.PrimitiveBlastFurnaceInfo;
import gregtech.integration.jei.multiblock.infos.PyrolyzeOvenInfo;
import gregtech.integration.jei.multiblock.infos.VacuumFreezerInfo;
import java.util.HashMap;
import java.util.Map;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.gui.recipes.RecipeLayout;
import net.minecraft.client.resources.I18n;

public class MultiblockInfoCategory
implements IRecipeCategory<MultiblockInfoRecipeWrapper> {
    private final IDrawable background;
    private final IDrawable icon;
    private final IGuiHelper guiHelper;
    public static final Map<String, MultiblockInfoRecipeWrapper> multiblockRecipes = new HashMap<String, MultiblockInfoRecipeWrapper>(){
        {
            this.put("primitive_blast_furnace", new MultiblockInfoRecipeWrapper(new PrimitiveBlastFurnaceInfo()));
            this.put("coke_oven", new MultiblockInfoRecipeWrapper(new CokeOvenInfo()));
            this.put("vacuum_freezer", new MultiblockInfoRecipeWrapper(new VacuumFreezerInfo()));
            this.put("implosion_compressor", new MultiblockInfoRecipeWrapper(new ImplosionCompressorInfo()));
            this.put("pyrolyze_oven", new MultiblockInfoRecipeWrapper(new PyrolyzeOvenInfo()));
            this.put("cracker_unit", new MultiblockInfoRecipeWrapper(new CrackerUnitInfo()));
            this.put("diesel_engine", new MultiblockInfoRecipeWrapper(new DieselEngineInfo()));
            this.put("distillation_tower", new MultiblockInfoRecipeWrapper(new DistillationTowerInfo()));
            this.put("electric_blast_furnace", new MultiblockInfoRecipeWrapper(new ElectricBlastFurnaceInfo()));
            this.put("multi_smelter", new MultiblockInfoRecipeWrapper(new MultiSmelterInfo()));
            this.put("large_bronze_boiler", new MultiblockInfoRecipeWrapper(new LargeBoilerInfo(MetaTileEntities.LARGE_BRONZE_BOILER)));
            this.put("large_steel_boiler", new MultiblockInfoRecipeWrapper(new LargeBoilerInfo(MetaTileEntities.LARGE_STEEL_BOILER)));
            this.put("large_titanium_boiler", new MultiblockInfoRecipeWrapper(new LargeBoilerInfo(MetaTileEntities.LARGE_TITANIUM_BOILER)));
            this.put("large_tungstensteel_boiler", new MultiblockInfoRecipeWrapper(new LargeBoilerInfo(MetaTileEntities.LARGE_TUNGSTENSTEEL_BOILER)));
            this.put("large_steam_turbine", new MultiblockInfoRecipeWrapper(new LargeTurbineInfo(MetaTileEntities.LARGE_STEAM_TURBINE)));
            this.put("large_gas_turbine", new MultiblockInfoRecipeWrapper(new LargeTurbineInfo(MetaTileEntities.LARGE_GAS_TURBINE)));
            this.put("large_plasma_turbine", new MultiblockInfoRecipeWrapper(new LargeTurbineInfo(MetaTileEntities.LARGE_PLASMA_TURBINE)));
        }
    };

    public MultiblockInfoCategory(IJeiHelpers helpers) {
        this.guiHelper = helpers.getGuiHelper();
        this.background = this.guiHelper.createBlankDrawable(176, 166);
        this.icon = this.guiHelper.drawableBuilder(GuiTextures.MULTIBLOCK_CATEGORY.imageLocation, 0, 0, 18, 18).setTextureSize(18, 18).build();
    }

    public static void registerRecipes(IModRegistry registry) {
        registry.addRecipes(multiblockRecipes.values(), "gregtech:multiblock_info");
    }

    public String getUid() {
        return "gregtech:multiblock_info";
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"gregtech.multiblock.title", (Object[])new Object[0]);
    }

    public String getModName() {
        return "gregtech";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayout recipeLayout, MultiblockInfoRecipeWrapper recipeWrapper, IIngredients ingredients) {
        recipeWrapper.setRecipeLayout((RecipeLayout)recipeLayout, this.guiHelper);
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        itemStackGroup.addTooltipCallback(recipeWrapper::addBlockTooltips);
    }
}

