/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei;

import gregtech.api.GTValues;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.type.Material;
import gregtech.api.worldgen.config.OreDepositDefinition;
import gregtech.api.worldgen.filler.BlockFiller;
import gregtech.api.worldgen.filler.FillerEntry;
import gregtech.api.worldgen.populator.FluidSpringPopulator;
import gregtech.api.worldgen.populator.IVeinPopulator;
import gregtech.api.worldgen.populator.SurfaceBlockPopulator;
import gregtech.api.worldgen.populator.SurfaceRockPopulator;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import org.apache.commons.lang3.tuple.Pair;

public class GTOreInfo
implements IRecipeWrapper {
    private final OreDepositDefinition definition;
    private final int maxHeight;
    private final int minHeight;
    private final String name;
    private final String description;
    private final int weight;
    private final IVeinPopulator veinPopulator;
    private final BlockFiller blockFiller;
    private List<List<ItemStack>> groupedInputsAsItemStacks = new ArrayList<List<ItemStack>>();
    private List<List<ItemStack>> groupedOutputsAsItemStacks = new ArrayList<List<ItemStack>>();
    private final Function<Biome, Integer> biomeFunction;

    public GTOreInfo(OreDepositDefinition definition) {
        this.definition = definition;
        if (GTValues.isModLoaded("cubicchunks")) {
            this.maxHeight = definition.getMaximumHeight() == Integer.MAX_VALUE ? Integer.MAX_VALUE : definition.getMaximumHeight();
            this.minHeight = definition.getMinimumHeight() == Integer.MIN_VALUE ? Integer.MIN_VALUE : definition.getMinimumHeight();
        } else {
            this.maxHeight = definition.getMaximumHeight() == Integer.MAX_VALUE ? 255 : definition.getMaximumHeight();
            this.minHeight = definition.getMinimumHeight() == Integer.MIN_VALUE ? 0 : definition.getMinimumHeight();
        }
        this.name = definition.getAssignedName() == null ? this.makePrettyName(definition.getDepositName()) : definition.getAssignedName();
        this.description = definition.getDescription();
        this.weight = definition.getWeight();
        this.veinPopulator = definition.getVeinPopulator();
        ItemStack identifierStack = this.findSurfaceBlock(this.veinPopulator);
        this.blockFiller = definition.getBlockFiller();
        this.biomeFunction = definition.getBiomeWeightModifier();
        List<ItemStack> generatedBlocksAsItemStacks = this.findComponentBlocksAsItemStacks();
        this.groupedInputsAsItemStacks.add(generatedBlocksAsItemStacks);
        this.groupedInputsAsItemStacks.add(Collections.singletonList(identifierStack));
        this.groupedOutputsAsItemStacks = this.findUniqueBlocksAsItemStack(generatedBlocksAsItemStacks);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.groupedInputsAsItemStacks);
        ingredients.setOutputLists(ItemStack.class, this.groupedOutputsAsItemStacks);
    }

    public List<ItemStack> findComponentBlocksAsItemStacks() {
        ArrayList<IBlockState> containedStates = new ArrayList<IBlockState>();
        ArrayList<ItemStack> containedBlocksAsItemStacks = new ArrayList<ItemStack>();
        List<FillerEntry> possibleStates = this.blockFiller.getAllPossibleStates();
        for (FillerEntry entry : possibleStates) {
            containedStates.addAll(entry.getPossibleResults());
        }
        if (this.veinPopulator instanceof FluidSpringPopulator) {
            for (IBlockState state : containedStates) {
                Block temp = state.func_177230_c();
                if (!(temp instanceof IFluidBlock)) continue;
                Fluid fluid = ((IFluidBlock)temp).getFluid();
                FluidStack fStack = new FluidStack(fluid, 1000);
                ItemStack stack = FluidUtil.getFilledBucket((FluidStack)fStack);
                containedBlocksAsItemStacks.add(stack);
            }
        } else {
            for (IBlockState state : containedStates) {
                containedBlocksAsItemStacks.add(new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)));
            }
        }
        return containedBlocksAsItemStacks;
    }

    public List<List<ItemStack>> findUniqueBlocksAsItemStack(List<ItemStack> itemList) {
        ArrayList<List<ItemStack>> groupedItems = new ArrayList<List<ItemStack>>();
        int entries = itemList.size();
        if (this.veinPopulator instanceof FluidSpringPopulator) {
            groupedItems.add(new ArrayList<ItemStack>(itemList));
            return groupedItems;
        }
        ItemStack firstItem = itemList.get(0);
        ArrayList<ItemStack> oreList = new ArrayList<ItemStack>();
        oreList.add(firstItem);
        for (int counter = 1; counter < entries; ++counter) {
            ItemStack item = itemList.get(counter);
            if (firstItem.func_77973_b() != item.func_77973_b()) {
                groupedItems.add(new ArrayList(oreList));
                oreList.clear();
            }
            oreList.add(item);
            firstItem = item;
        }
        groupedItems.add(new ArrayList(oreList));
        return groupedItems;
    }

    public ItemStack findSurfaceBlock(IVeinPopulator veinPopulator) {
        IBlockState state;
        Block temp;
        ItemStack stack = new ItemStack(Items.field_190931_a);
        if (veinPopulator instanceof SurfaceRockPopulator) {
            Material mat = ((SurfaceRockPopulator)veinPopulator).getMaterial();
            stack = OreDictUnifier.getDust(mat.createMaterialStack(403200L));
            return stack.func_190926_b() ? new ItemStack(Items.field_190931_a) : stack;
        }
        if (veinPopulator instanceof SurfaceBlockPopulator) {
            IBlockState state2 = ((SurfaceBlockPopulator)veinPopulator).getBlockState();
            stack = new ItemStack(state2.func_177230_c(), 1, state2.func_177230_c().func_176201_c(state2));
            return stack;
        }
        if (veinPopulator instanceof FluidSpringPopulator && (temp = (state = ((FluidSpringPopulator)veinPopulator).getFluidState()).func_177230_c()) instanceof IFluidBlock) {
            Fluid fluid = ((IFluidBlock)temp).getFluid();
            FluidStack fStack = new FluidStack(fluid, 1000);
            stack = FluidUtil.getFilledBucket((FluidStack)fStack);
            return stack;
        }
        return stack;
    }

    public String makePrettyName(String name) {
        FileSystem fs = FileSystems.getDefault();
        String separator = fs.getSeparator();
        String[] tempName = name.split(Matcher.quoteReplacement(separator));
        String newName = tempName[tempName.length - 1];
        tempName = newName.split("\\.");
        newName = tempName[0];
        newName = newName.replaceAll("_", " ");
        newName = newName.substring(0, 1).toUpperCase() + newName.substring(1);
        return newName;
    }

    public void addTooltip(int slotIndex, boolean input, Object ingredient, List<String> tooltip) {
        if (slotIndex == 0) {
            tooltip.addAll(this.createBiomeTooltip());
            if (this.description != null) {
                tooltip.add(this.description);
            }
        } else if (slotIndex == 1) {
            if (this.veinPopulator instanceof SurfaceRockPopulator) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.jei.ore.surface_rock_1", (Object[])new Object[0]));
                tooltip.add(I18n.func_135052_a((String)"gregtech.jei.ore.surface_rock_2", (Object[])new Object[0]));
            }
        } else {
            tooltip.addAll(this.createOreWeightingTooltip(slotIndex));
        }
    }

    public List<String> createBiomeTooltip() {
        Iterator biomeIterator = Biome.field_185377_q.iterator();
        HashMap<Biome, Integer> modifiedBiomeMap = new HashMap<Biome, Integer>();
        ArrayList<String> tooltip = new ArrayList<String>();
        while (biomeIterator.hasNext()) {
            Biome biome = (Biome)biomeIterator.next();
            int biomeWeight = this.biomeFunction.apply(biome);
            if (biomeWeight == this.weight) continue;
            modifiedBiomeMap.put(biome, this.weight + biomeWeight);
        }
        for (Map.Entry entry : modifiedBiomeMap.entrySet()) {
            if ((Integer)entry.getValue() == this.weight) continue;
            if ((Integer)entry.getValue() <= 0) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.jei.ore.biome_weighting_no_spawn", (Object[])new Object[]{((Biome)entry.getKey()).func_185359_l()}));
                continue;
            }
            tooltip.add(I18n.func_135052_a((String)"gregtech.jei.ore.biome_weighting", (Object[])new Object[]{((Biome)entry.getKey()).func_185359_l(), entry.getValue()}));
        }
        return tooltip;
    }

    public List<String> createOreWeightingTooltip(int slotIndex) {
        ArrayList<String> tooltip = new ArrayList<String>();
        int totalWeight = 0;
        List<FillerEntry> fillerEntries = this.blockFiller.getAllPossibleStates();
        for (FillerEntry entries : fillerEntries) {
            if (entries == null || entries.getEntries().isEmpty()) continue;
            for (Pair<Integer, FillerEntry> entry : entries.getEntries()) {
                totalWeight += ((Integer)entry.getKey()).intValue();
            }
        }
        for (FillerEntry entry : fillerEntries) {
            if (entry.getEntries() == null || entry.getEntries().isEmpty()) continue;
            Pair<Integer, FillerEntry> entryWithWeight = entry.getEntries().get(slotIndex - 2);
            double weight = Math.round((double)((Integer)entryWithWeight.getKey()).intValue() / (double)totalWeight * 100.0);
            tooltip.add("Weight in vein: " + weight + "%");
        }
        return tooltip;
    }

    public int getOutputCount() {
        return this.groupedOutputsAsItemStacks.size();
    }

    public String getVeinName() {
        return this.name;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getWeight() {
        return this.weight;
    }

    public OreDepositDefinition getDefinition() {
        return this.definition;
    }
}

